/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/actions/BuildRunConfigNotifier;", "", "<init>", "()V", "notifyNoRunConfigFound", "", "project", "Lcom/intellij/openapi/project/Project;", "notifyNoModulesFoundToBuild", "runConfigName", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.projectSystem.gradle"})
public final class BuildRunConfigNotifier {
    @NotNull
    public static final BuildRunConfigNotifier INSTANCE = new BuildRunConfigNotifier();

    private BuildRunConfigNotifier() {
    }

    public final void notifyNoRunConfigFound(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = "Unable to find Run Configuration to build: No Configuration selected.";
        Object object = new Object[]{};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String logMessage = string2;
        this.getLogger().warn(logMessage);
        object = "Unable to find Run Configuration to build: No Configuration selected.";
        Object[] objectArray = new Object[]{};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String message = string3;
        NotificationGroupManager.getInstance().getNotificationGroup("Android Gradle Tasks").createNotification(message, NotificationType.WARNING).notify(project);
    }

    public final void notifyNoModulesFoundToBuild(@NotNull String runConfigName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfigName, (String)"runConfigName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = "Unable to find modules to build for '%s' Run Configuration";
        Object object = new Object[]{runConfigName};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String logMessage = string2;
        this.getLogger().warn(logMessage);
        object = "Unable to find modules to build for '%s' Run Configuration";
        Object[] objectArray = new Object[]{runConfigName};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String message = string3;
        NotificationGroupManager.getInstance().getNotificationGroup("Android Gradle Tasks").createNotification(message, NotificationType.WARNING).notify(project);
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(BuildRunConfigNotifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }
}

