/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.fonts.ProjectFonts;
import com.android.tools.idea.fonts.FontDownloadService;
import com.android.tools.idea.fonts.FontFamilyCreator;
import com.android.tools.idea.fonts.StudioDownloadableFontCacheService;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.SelectedListValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoreFontsDialog
extends DialogWrapper {
    public static final String ACTION_NAME = "More Fonts...";
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 5;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 10;
    private final FontListModel myModel;
    private final DefaultListModel<FontDetail> myDetailModel;
    private final FontFamilyCreator myFontCreator;
    private final StudioResourceRepositoryManager myResourceRepository;
    private final StringProperty myNewFontName;
    private final SelectedListValueProperty<FontFamily> mySelectedFontFamily;
    private SearchTextField mySearchField;
    private JBList<FontFamily> myFontList;
    private JComboBox<String> myProvider;
    private JPanel myContentPanel;
    private JBScrollPane myFontListScrollPane;
    private JBList<FontDetail> myFontDetailList;
    private JBLabel myFontLabel;
    private JPanel myPreviewPanel;
    private JPanel myFontListPanel;
    private JPanel myCreateParams;
    private JTextField myFontNameEditor;
    private JBLabel myFontName;
    private JPanel myDownloadable;
    private JRadioButton myMakeDownloadable;
    private ValidatorPanel myValidatorPanel;
    private HyperlinkLabel myLicenseLabel;
    private FontFamily myLastSelectedFont;
    private String myResultingFont;

    private void createUIComponents() {
        this.myContentPanel = new JPanel();
        this.mySearchField = new SearchTextField(false);
        this.myValidatorPanel = new ValidatorPanel(this.myDisposable, (JComponent)new JPanel());
    }

    public MoreFontsDialog(@NotNull AndroidFacet facet, @Nullable String currentValue, @NotNull Boolean showExistingFonts) {
        super(facet.getModule().getProject());
        this.setupUI();
        this.setTitle("Resources");
        this.myResourceRepository = StudioResourceRepositoryManager.getInstance(facet);
        this.myContentPanel.setPreferredSize(new Dimension(MoreFontsDialog.getDefaultWidth(), MoreFontsDialog.getDefaultHeight()));
        this.myFontList.setMinimumSize(new Dimension(MoreFontsDialog.getMinFontListWidth(), MoreFontsDialog.getMinFontListHeight()));
        this.myFontList.setSelectionMode(0);
        this.myFontList.setName("Font list");
        this.myFontDetailList.setMinimumSize(new Dimension(MoreFontsDialog.getMinFontPreviewWidth(), MoreFontsDialog.getMinFontPreviewHeight()));
        this.myFontDetailList.setSelectionMode(0);
        ProjectFonts projectFonts = showExistingFonts != false ? new ProjectFonts(StudioDownloadableFontCacheService.getInstance(), this.myResourceRepository) : null;
        this.myModel = new FontListModel(projectFonts, showExistingFonts);
        this.myModel.setRepopulateListener(this::repopulated);
        this.myDetailModel = new DefaultListModel();
        this.myCreateParams.setLayout(this.createGroupLayoutForCreateParams());
        this.myFontNameEditor.setVisible(false);
        this.myDownloadable.setVisible(false);
        this.myFontList.setCellRenderer((ListCellRenderer)((Object)new FontFamilyRenderer()));
        this.myFontList.setFixedCellHeight(MoreFontsDialog.computeFontHeightInFontList(this.myFontList));
        this.myFontList.setFixedCellWidth(MoreFontsDialog.getMinFontListWidth() + JBUI.scale((int)MoreFontsDialog.getDescenderSpace()));
        this.myFontList.setModel((ListModel)this.myModel);
        this.myFontListScrollPane.setVerticalScrollBarPolicy(22);
        JScrollBar scrollBar = this.myFontListScrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(5);
        scrollBar.setBlockIncrement(10);
        this.myFontDetailList.setCellRenderer((ListCellRenderer)((Object)new FontDetailRenderer()));
        this.myFontDetailList.setModel(this.myDetailModel);
        this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                MoreFontsDialog.this.myModel.setFilter(MoreFontsDialog.this.mySearchField.getText().trim());
            }
        });
        this.myFontList.addListSelectionListener(event -> this.fontListSelectionChanged());
        this.myFontDetailList.addListSelectionListener(event -> this.fontDetailSelectionChanged());
        this.myFontCreator = new FontFamilyCreator(facet);
        this.myContentPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                Insets fontListInsets = MoreFontsDialog.this.myFontListPanel.getBorder().getBorderInsets(MoreFontsDialog.this.myFontListPanel);
                int width = (MoreFontsDialog.this.myContentPanel.getWidth() - MoreFontsDialog.this.myFontLabel.getWidth()) / 2 - fontListInsets.left - fontListInsets.right;
                MoreFontsDialog.this.myFontList.setFixedCellWidth(Math.min(MoreFontsDialog.getMinFontListWidth(), width));
                MoreFontsDialog.this.myPreviewPanel.setPreferredSize(new Dimension(width, MoreFontsDialog.getMinFontPreviewHeight()));
            }
        });
        this.myProvider.addItem("Google Fonts");
        this.myProvider.setSelectedIndex(0);
        this.myNewFontName = new StringValueProperty();
        this.mySelectedFontFamily = new SelectedListValueProperty<FontFamily>((JList<FontFamily>)this.myFontList);
        this.bindComponents();
        this.addValidators();
        if (currentValue != null) {
            this.myFontList.setSelectedValue((Object)this.myModel.getFont(currentValue), true);
        }
        this.myLicenseLabel.setHyperlinkText("These fonts are available under the ", "Apache License Version 2.0 or Open Font License", "");
        this.myLicenseLabel.setHyperlinkTarget("https://fonts.google.com");
        this.init();
    }

    @Nullable
    public String getResultingFont() {
        return this.myResultingFont;
    }

    public void show() {
        if (this.myModel.getSize() == 0) {
            Messages.showErrorDialog((String)"Please setup your SDK first. Make sure the folder is writable. Then try again.", (String)"Font Cache Missing");
            return;
        }
        super.show();
    }

    protected void doOKAction() {
        FontFamily family = (FontFamily)this.myFontList.getSelectedValue();
        if (family == null) {
            Messages.showErrorDialog((Component)this.myContentPanel, (String)"Please select a font family on the left");
            return;
        }
        FontDetail detail = (FontDetail)this.myFontDetailList.getSelectedValue();
        if (detail == null) {
            Messages.showErrorDialog((Component)this.myContentPanel, (String)"Please select a specific font among the previewed fonts on the right");
            return;
        }
        try {
            switch (family.getFontSource()) {
                case SYSTEM: {
                    this.myResultingFont = family.getName();
                    break;
                }
                case PROJECT: {
                    this.myResultingFont = "@font/" + family.getName();
                    break;
                }
                case DOWNLOADABLE: {
                    this.myResultingFont = this.myFontCreator.createFontFamily(detail, this.myFontNameEditor.getText(), this.myMakeDownloadable.isSelected());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected font source " + String.valueOf(family.getFontSource()));
                }
            }
        }
        catch (Exception ex) {
            Logger.getInstance(MoreFontsDialog.class).warn("Could not create font resource file", (Throwable)ex);
            Messages.showErrorDialog((Component)this.myContentPanel, (String)(ex instanceof FontFamilyCreator.UpdateManifestFileException ? ex.getMessage() : "Could not create font resource file"));
            return;
        }
        super.doOKAction();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Downloadable.Font.Dialog.Size";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    private void setupUI() {
        this.createUIComponents();
        this.myContentPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.myContentPanel.add((Component)panel1, "North");
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), null, 0, 0, null, null));
        panel1.add((Component)this.mySearchField, "West");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "East");
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Source");
        panel2.add((Component)jBLabel1, "West");
        this.myProvider = new JComboBox();
        panel2.add(this.myProvider, "Center");
        this.myFontLabel = new JBLabel();
        this.myFontLabel.setText("Fonts");
        this.myFontLabel.setVerticalAlignment(1);
        this.myContentPanel.add((Component)this.myFontLabel, "West");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        this.myContentPanel.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "South");
        panel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8), null, 0, 0, this.getFont(null, -1, -1, panel4.getFont()), null));
        panel4.add((Component)this.myValidatorPanel.getRootComponent(), "South");
        this.myLicenseLabel = new HyperlinkLabel();
        panel4.add((Component)this.myLicenseLabel, "Center");
        this.myFontListPanel = new JPanel();
        this.myFontListPanel.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)this.myFontListPanel, "Center");
        this.myFontListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 8, 0, 4), null, 0, 0, null, null));
        this.myFontListScrollPane = new JBScrollPane();
        this.myFontListPanel.add((Component)this.myFontListScrollPane, "Center");
        this.myFontList = new JBList();
        this.myFontListScrollPane.setViewportView(this.myFontList);
        this.myPreviewPanel = new JPanel();
        this.myPreviewPanel.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)this.myPreviewPanel, "East");
        this.myPreviewPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 4, 0, 8), null, 0, 0, null, null));
        JPanel panel5 = new JPanel();
        panel5.setLayout(new BorderLayout(0, 12));
        this.myPreviewPanel.add((Component)panel5, "North");
        panel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Preview");
        panel5.add((Component)jBLabel2, "South");
        this.myCreateParams = new JPanel();
        this.myCreateParams.setLayout(new BorderLayout(0, 0));
        panel5.add((Component)this.myCreateParams, "Center");
        this.myFontName = new JBLabel();
        this.myFontName.setText("Font Name:");
        this.myFontName.setVerticalAlignment(0);
        this.myCreateParams.add((Component)this.myFontName, "West");
        this.myFontNameEditor = new JTextField();
        this.myFontNameEditor.setText("droid_sans");
        this.myCreateParams.add((Component)this.myFontNameEditor, "Center");
        this.myDownloadable = new JPanel();
        this.myDownloadable.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myCreateParams.add((Component)this.myDownloadable, "South");
        this.myMakeDownloadable = new JRadioButton();
        this.myMakeDownloadable.setSelected(true);
        this.myMakeDownloadable.setText("Create downloadable font");
        this.myDownloadable.add((Component)this.myMakeDownloadable, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JRadioButton radioButton1 = new JRadioButton();
        radioButton1.setText("Add font to project");
        this.myDownloadable.add((Component)radioButton1, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.myPreviewPanel.add((Component)jBScrollPane1, "Center");
        this.myFontDetailList = new JBList();
        jBScrollPane1.setViewportView(this.myFontDetailList);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myMakeDownloadable);
        buttonGroup.add(radioButton1);
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private static int computeFontHeightInFontList(@NotNull JComponent component) {
        return component.getFontMetrics(component.getFont().deriveFont(MoreFontsDialog.getFontSizeInList())).getHeight();
    }

    private LayoutManager createGroupLayoutForCreateParams() {
        GroupLayout layout = new GroupLayout(this.myCreateParams);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)this.myFontName).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myFontNameEditor).addComponent(this.myDownloadable)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.myFontName).addComponent(this.myFontNameEditor)).addComponent(this.myDownloadable));
        return layout;
    }

    private void bindComponents() {
        BindingsManager bindings = new BindingsManager();
        bindings.bindTwoWay(new TextProperty(this.myFontNameEditor), this.myNewFontName);
    }

    private void addValidators() {
        this.myValidatorPanel.registerValidator((ObservableValue)this.myNewFontName, this::checkFontName, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(this.mySelectedFontFamily, this::checkSelectedFontFamily, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myValidatorPanel.hasErrors(), this::updateOkButton, new ObservableValue[0]);
    }

    @NotNull
    private Validator.Result checkFontName(@NotNull String fontName) {
        if (!this.myFontNameEditor.isVisible()) {
            return Validator.Result.OK;
        }
        if (this.myResourceRepository.getProjectResources().getResources(ResourceNamespace.TODO(), ResourceType.FONT).containsKey((Object)fontName)) {
            return new Validator.Result(Validator.Severity.ERROR, "A font named: \"" + fontName + "\" already exists");
        }
        if (fontName.isEmpty()) {
            return new Validator.Result(Validator.Severity.ERROR, "A font name must be specified");
        }
        return Validator.Result.OK;
    }

    @NotNull
    private Validator.Result checkSelectedFontFamily(@NotNull Optional<FontFamily> font) {
        return Validator.Result.fromNullableMessage((String)this.myModel.getErrorMessage(font.orElse(null)));
    }

    @NotNull
    private Validator.Result updateOkButton(@NotNull Boolean hasErrors) {
        this.setOKActionEnabled(hasErrors == false);
        return Validator.Result.OK;
    }

    private void fontListSelectionChanged() {
        FontFamily family = (FontFamily)this.myFontList.getSelectedValue();
        if (Objects.equals(family, this.myLastSelectedFont)) {
            return;
        }
        if (family == null || family.getFontSource() == FontSource.HEADER) {
            this.myLicenseLabel.setVisible(false);
            this.myFontName.setText("");
            this.myFontNameEditor.setVisible(false);
            this.myDownloadable.setVisible(false);
            this.myDetailModel.clear();
            this.setOKActionEnabled(false);
        } else {
            this.myLicenseLabel.setVisible(family.getFontSource() == FontSource.DOWNLOADABLE);
            Runnable downloaded = () -> this.selectedFontLoaded(family);
            FontDownloadService.download(Collections.singletonList(family), false, downloaded, downloaded);
            this.setOKActionEnabled((Boolean)this.myValidatorPanel.hasErrors().get() == false);
        }
        this.myLastSelectedFont = family;
    }

    private void selectedFontLoaded(@NotNull FontFamily familyLoaded) {
        UIUtil.invokeLaterIfNeeded(() -> this.selectedFontLoadedEDT(familyLoaded));
    }

    private void selectedFontLoadedEDT(@NotNull FontFamily familyLoaded) {
        if (!familyLoaded.equals((Object)this.myLastSelectedFont)) {
            return;
        }
        switch (familyLoaded.getFontSource()) {
            case SYSTEM: 
            case PROJECT: {
                this.myFontName.setText("Font Name: " + familyLoaded.getName());
                this.myFontNameEditor.setVisible(false);
                this.myFontNameEditor.setText("");
                this.myDownloadable.setVisible(false);
                break;
            }
            case DOWNLOADABLE: {
                this.myFontName.setText("Font Name:");
                this.myFontNameEditor.setText("");
                this.myFontNameEditor.setVisible(true);
                this.myDownloadable.setVisible(true);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected font source " + String.valueOf(familyLoaded.getFontSource()));
            }
        }
        this.myDetailModel.clear();
        for (FontDetail detail : familyLoaded.getFonts()) {
            this.myDetailModel.addElement(detail);
        }
        if (!familyLoaded.getFonts().isEmpty()) {
            this.myFontDetailList.setSelectedIndex(0);
        }
    }

    private void fontDetailSelectionChanged() {
        if (!this.myFontNameEditor.isVisible()) {
            return;
        }
        FontFamily family = (FontFamily)this.myFontList.getSelectedValue();
        FontDetail detail = (FontDetail)this.myFontDetailList.getSelectedValue();
        if (family != null && detail != null) {
            this.myFontNameEditor.setText(FontFamilyCreator.getFontName(detail));
        }
    }

    private void repopulated() {
        this.myFontList.setSelectedIndex(this.myModel.getElementIndex(this.myLastSelectedFont));
    }

    private static String findDisplayableTextForFont(@NotNull Font font, @NotNull String text2) {
        if (font.canDisplayUpTo(text2) < 0) {
            return text2;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 200; i < 65535; ++i) {
            if (!font.canDisplay((char)i)) continue;
            builder.append((char)i);
            if (builder.length() > 14) break;
        }
        return builder.toString();
    }

    private static float getFontSizeInList() {
        return JBUI.scaleFontSize((float)16.0f);
    }

    private static int getDefaultHeight() {
        return JBUI.scale((int)400);
    }

    private static int getDefaultWidth() {
        return JBUI.scale((int)600);
    }

    private static int getMinFontListHeight() {
        return JBUI.scale((int)200);
    }

    private static int getMinFontListWidth() {
        return JBUI.scale((int)250);
    }

    private static int getMinFontPreviewHeight() {
        return JBUI.scale((int)200);
    }

    private static int getMinFontPreviewWidth() {
        return JBUI.scale((int)150);
    }

    private static int getDescenderSpace() {
        return JBUI.scale((int)4);
    }

    private static class FontListModel
    extends DefaultListModel<FontFamily> {
        private static final int DOWNLOAD_SIZE = 25;
        private final DownloadableFontCacheService myFontService = StudioDownloadableFontCacheService.getInstance();
        @Nullable
        private final ProjectFonts myProjectFonts;
        private final SpeedSearchComparator myComparator;
        private final List<FontFamily> myFilteredList;
        private Runnable myRepopulateListener;
        private String myFilter;
        private int myFirstLoadedFontIndex;
        private int myLoadedFontIndex;
        private boolean myShowFrameworkFonts;

        private FontListModel(@Nullable ProjectFonts projectFonts, @NotNull Boolean showFrameworkFonts) {
            this.myProjectFonts = projectFonts;
            this.myComparator = new SpeedSearchComparator();
            this.myFilteredList = new ArrayList<FontFamily>();
            this.myFilter = "";
            this.populateModel();
            this.myLoadedFontIndex = -1;
            this.myFirstLoadedFontIndex = -1;
            this.myShowFrameworkFonts = showFrameworkFonts;
            this.myFontService.refresh(this::repopulateModel, null);
        }

        public void setRepopulateListener(@NotNull Runnable listener2) {
            this.myRepopulateListener = listener2;
        }

        public void setFilter(@NotNull String filter2) {
            this.myFilter = filter2;
            this.redoFiltering();
        }

        @Override
        public int getSize() {
            return this.myFilter.isEmpty() ? super.getSize() : this.myFilteredList.size();
        }

        @Override
        public FontFamily getElementAt(int index) {
            return this.myFilter.isEmpty() ? (FontFamily)super.get(index) : this.myFilteredList.get(index);
        }

        public int getElementIndex(@Nullable FontFamily family) {
            if (family == null) {
                return -1;
            }
            return this.myFilter.isEmpty() ? super.indexOf(family) : this.myFilteredList.indexOf(family);
        }

        private void redoFiltering() {
            this.myFilteredList.clear();
            if (!this.myFilter.isEmpty()) {
                int size = super.getSize();
                for (int index = 0; index < size; ++index) {
                    FontFamily family = (FontFamily)super.get(index);
                    if (family.getFontSource() == FontSource.HEADER || this.myComparator.matchingFragments(this.myFilter, family.getName()) == null) continue;
                    this.myFilteredList.add(family);
                }
            }
            if (this.myRepopulateListener != null) {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
                this.myRepopulateListener.run();
            }
        }

        private void repopulateModel() {
            UIUtil.invokeLaterIfNeeded(this::repopulateModelEDT);
        }

        private void repopulateModelEDT() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            boolean startLoad = this.myLoadedFontIndex < 0;
            this.populateModel();
            if (startLoad) {
                this.myLoadedFontIndex = 0;
                this.loadRemainingFonts();
            }
        }

        private void populateModel() {
            this.clear();
            if (this.myProjectFonts != null) {
                this.addFamilies("Project", this.myProjectFonts.getFonts());
            }
            if (this.myShowFrameworkFonts) {
                this.addFamilies("Android", this.myFontService.getSystemFontFamilies());
            }
            this.addFamilies("Downloadable", this.myFontService.getFontFamilies());
            this.redoFiltering();
        }

        private void addFamilies(@NotNull String sectionName, @NotNull Collection<FontFamily> families) {
            if (families.isEmpty()) {
                return;
            }
            this.addElement(new FontFamily(FontProvider.EMPTY_PROVIDER, FontSource.HEADER, sectionName, "", "", Collections.emptyList()));
            for (FontFamily fontFamily : families) {
                this.addElement(fontFamily);
            }
        }

        @Nullable
        public FontFamily getFont(@NotNull String name2) {
            return this.myProjectFonts != null ? this.myProjectFonts.getFont(name2) : null;
        }

        @Nullable
        public String getErrorMessage(@Nullable FontFamily family) {
            return this.myProjectFonts != null ? this.myProjectFonts.getErrorMessage(family) : null;
        }

        private void loadRemainingFonts() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            int size = super.getSize();
            if (this.myLoadedFontIndex >= size) {
                this.myLoadedFontIndex = -1;
                this.myFirstLoadedFontIndex = -1;
                return;
            }
            ArrayList<FontFamily> fontsToDownload = new ArrayList<FontFamily>();
            this.myFirstLoadedFontIndex = this.myLoadedFontIndex;
            while (this.myLoadedFontIndex < size && fontsToDownload.size() < 25) {
                FontFamily family;
                if ((family = (FontFamily)super.get(this.myLoadedFontIndex++)).getFontSource() != FontSource.DOWNLOADABLE) continue;
                fontsToDownload.add(family);
            }
            FontDownloadService.download(fontsToDownload, true, this::loadDone, this::loadDone);
        }

        private void loadDone() {
            UIUtil.invokeLaterIfNeeded(this::loadDoneEDT);
        }

        private void loadDoneEDT() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.fireContentsChanged(this, this.myFirstLoadedFontIndex, this.myLoadedFontIndex);
            this.loadRemainingFonts();
        }
    }

    private static class FontFamilyRenderer
    extends ColoredListCellRenderer<FontFamily> {
        private static final int FONT_CACHE_LOAD_BATCH_SIZE = 15;
        private final DownloadableFontCacheService myFontService;
        private final JLabel myTitle;
        private final Cache<FontFamily, Font> myMenuFontCache = CacheBuilder.newBuilder().softValues().build();

        private FontFamilyRenderer() {
            this.myFontService = StudioDownloadableFontCacheService.getInstance();
            this.myTitle = new HeaderLabel();
            this.myTitle.setBorder((Border)JBUI.Borders.empty((int)0, (int)35, (int)0, (int)5));
            this.warmUpCache();
        }

        private void warmUpCache() {
            List<FontFamily> families = this.myFontService.getFontFamilies();
            int familyCount = families.size();
            if (familyCount == 0) {
                return;
            }
            int batches = familyCount / 15 + 1;
            for (int i = 0; i < batches; ++i) {
                int batchStart = i * 15;
                int batchEnd = Math.min((i + 1) * 15, familyCount);
                ForkJoinPool.commonPool().execute(() -> {
                    for (int j = batchStart; j < batchEnd; ++j) {
                        FontFamily family = (FontFamily)families.get(j);
                        Font addedFont = this.getMenuFontFromFamily(family);
                        if (addedFont == null) continue;
                        FontRenderContext fontRenderContext = this.getFontMetrics(addedFont).getFontRenderContext();
                        addedFont.getStringBounds(family.getMenuName(), fontRenderContext);
                    }
                });
            }
        }

        @Nullable
        private Font getMenuFontFromFamily(@NotNull FontFamily fontFamily) {
            Font font = (Font)this.myMenuFontCache.getIfPresent((Object)fontFamily);
            if (font == null) {
                font = this.myFontService.loadMenuFont(fontFamily);
                String text2 = fontFamily.getMenuName();
                if (font != null && font.canDisplayUpTo(text2) < 0) {
                    font = font.deriveFont(MoreFontsDialog.getFontSizeInList());
                    this.myMenuFontCache.put((Object)fontFamily, (Object)font);
                }
            }
            return font;
        }

        public Component getListCellRendererComponent(@NotNull JList<? extends FontFamily> list2, @NotNull FontFamily fontFamily, int index, boolean selected, boolean hasFocus) {
            if (fontFamily.getFontSource() == FontSource.HEADER) {
                this.myTitle.setText(fontFamily.getName());
                return this.myTitle;
            }
            return super.getListCellRendererComponent(list2, (Object)fontFamily, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends FontFamily> list2, @NotNull FontFamily fontFamily, int index, boolean selected, boolean hasFocus) {
            Font font = this.getMenuFontFromFamily(fontFamily);
            if (font != null) {
                this.setFont(font);
            }
            this.append(fontFamily.getMenuName());
            this.setIconTextGap(JBUI.scale((int)4));
            switch (fontFamily.getFontSource()) {
                case SYSTEM: {
                    this.setIcon(StudioIcons.Shell.Filetree.ANDROID_PROJECT);
                    break;
                }
                case DOWNLOADABLE: {
                    this.setIcon(StudioIcons.Common.LINK);
                    break;
                }
                case PROJECT: {
                    if (fontFamily.getMenu().startsWith("file://")) {
                        this.setIcon(StudioIcons.Shell.Filetree.FONT_FILE);
                        break;
                    }
                    if (fontFamily.getMenu().startsWith("https://")) {
                        this.setIcon(StudioIcons.Common.LINK);
                        break;
                    }
                    this.setIcon(AllIcons.General.BalloonError);
                    break;
                }
            }
        }
    }

    private static class FontDetailRenderer
    extends ColoredListCellRenderer<FontDetail> {
        private final DownloadableFontCacheService myFontService = StudioDownloadableFontCacheService.getInstance();

        private FontDetailRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends FontDetail> list2, @NotNull FontDetail fontDetail, int index, boolean selected, boolean hasFocus) {
            String text2 = fontDetail.getStyleName();
            Font font = this.myFontService.loadDetailFont(fontDetail);
            if (font != null) {
                this.setFont(font.deriveFont(MoreFontsDialog.getFontSizeInList()));
                text2 = MoreFontsDialog.findDisplayableTextForFont(font, text2);
            }
            this.mySelectionForeground = this.myForeground;
            this.setBackground(null);
            this.append(text2);
            if (selected) {
                this.setIcon(LafIconLookup.getIcon((String)"checkmark"));
                this.setBorderInsets((Insets)new JBInsets(0, 0, 0, 0));
            } else {
                this.setBorderInsets(new Insets(0, AllIcons.Actions.Checked.getIconWidth() + this.getIconTextGap(), 0, 0));
            }
        }
    }

    private static class HeaderLabel
    extends JBLabel {
        private static final Color CONTRAST_BORDER_COLOR = JBColor.lazy((Supplier)new Supplier<Color>(){
            final Color color = new JBColor(0x9B9B9B, 0x4B4B4B);

            @Override
            @NotNull
            public Color get() {
                if (SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("IntelliJ")) {
                    return Gray.xC9;
                }
                return this.color;
            }
        });

        private HeaderLabel() {
        }

        protected void paintComponent(@NotNull Graphics graphics) {
            super.paintComponent(graphics);
            int width = this.getWidth();
            int height = this.getHeight() / 2;
            int textWidth = (int)this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), graphics).getWidth();
            graphics.setColor(CONTRAST_BORDER_COLOR);
            graphics.drawLine(JBUI.scale((int)5), height, JBUI.scale((int)30), height);
            graphics.drawLine(textWidth + JBUI.scale((int)40), height, width - JBUI.scale((int)5), height);
        }
    }
}

