/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.tools.fonts.FontDirectoryDownloader;
import com.android.tools.fonts.Fonts;
import com.android.tools.idea.downloads.DownloadService;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FontDirectoryDownloadService
implements FontDirectoryDownloader {
    private static final String SERVICE_POSTFIX = " Downloadable Fonts";
    private static final String TEMPORARY_FONT_DIRECTORY_FILENAME = "temp_font_directory.xml";
    private final DownloadService myDownloadService;
    private final FontProvider myProvider;

    public FontDirectoryDownloadService(final @NotNull FontLoader fontLoader, @NotNull FontProvider provider, @NotNull File fontCachePath) {
        this.myDownloadService = new DownloadService(provider.getName() + SERVICE_POSTFIX, provider.getUrl(), Fonts.getFallbackResourceUrl(provider), FontDirectoryDownloadService.getCachePath(provider, fontCachePath), TEMPORARY_FONT_DIRECTORY_FILENAME, "font_directory.xml"){

            public void loadFromFile(@NotNull URL url) {
                fontLoader.loadDirectory(FontDirectoryDownloadService.this.myProvider, url);
            }
        };
        this.myProvider = provider;
    }

    @Override
    public void refreshFonts(@Nullable Runnable success, @Nullable Runnable failure) {
        this.myDownloadService.refresh(success, failure);
    }

    @NotNull
    private static File getCachePath(@NotNull FontProvider provider, @NotNull File fontCachePath) {
        File providerPath = new File(fontCachePath, provider.getAuthority());
        File directoryPath = new File(providerPath, "directory");
        FileUtil.createDirectory((File)directoryPath);
        return directoryPath;
    }
}

