/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fileTypes;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.projectsystem.AndroidIconProviderProjectToken;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.FlagManager;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element instanceof XmlFile) {
            FolderConfiguration config;
            String parentName;
            int index;
            VirtualFile file = ((XmlFile)element).getVirtualFile();
            if (file == null) {
                return null;
            }
            if ("AndroidManifest.xml".equals(file.getName())) {
                return StudioIcons.Shell.Filetree.MANIFEST_FILE;
            }
            VirtualFile parent = file.getParent();
            if (parent != null && (index = (parentName = parent.getName()).indexOf(45)) != -1 && (config = FolderConfiguration.getConfigForFolder((String)parentName)) != null && config.getLocaleQualifier() != null && ResourceFolderType.getFolderType((String)parentName) != null) {
                return FlagManager.get().getFlag(config);
            }
        }
        Project project = element.getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        AndroidIconProviderProjectToken token = AndroidIconProviderProjectToken.getEP_NAME().getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        if (token != null) {
            return token.getIcon(projectSystem, element);
        }
        return null;
    }
}

