/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorKt;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorState;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorStateListener;
import com.android.tools.idea.execution.common.processhandler.TextEmitter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 /2\u00020\u0001:\u0001/BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010(\u001a\u00020\u000eJ\b\u0010)\u001a\u00020\u000eH\u0002J\b\u0010*\u001a\u00020\u000eH\u0002J\u0006\u0010+\u001a\u00020\u000eJ\u0010\u0010,\u001a\u00020\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u0007J\b\u0010.\u001a\u00020\u000eH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000e0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitor;", "Ljava/io/Closeable;", "targetApplicationId", "", "targetDevice", "Lcom/android/ddmlib/IDevice;", "listener", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorStateListener;", "deploymentApplicationService", "Lcom/android/tools/idea/run/DeploymentApplicationService;", "textEmitter", "Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;", "finishAndroidProcessCallback", "Lkotlin/Function1;", "", "stateUpdaterExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "listenerExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Ljava/lang/String;Lcom/android/ddmlib/IDevice;Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorStateListener;Lcom/android/tools/idea/run/DeploymentApplicationService;Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ScheduledExecutorService;Ljava/util/concurrent/Executor;)V", "getTargetApplicationId", "()Ljava/lang/String;", "getTargetDevice", "()Lcom/android/ddmlib/IDevice;", "<set-?>", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorState;", "myState", "getMyState", "()Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorState;", "setMyState", "(Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorState;)V", "myState$delegate", "Lkotlin/properties/ReadWriteProperty;", "myMonitoringPids", "Ljava/util/concurrent/ConcurrentHashMap;", "", "myStateUpdaterScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "myTimeoutScheduledFuture", "start", "updateState", "timeout", "detachAndClose", "replaceListenerAndClose", "newListener", "close", "Companion", "intellij.android.execution.common"})
@SourceDebugExtension(value={"SMAP\nSingleDeviceAndroidProcessMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleDeviceAndroidProcessMonitor.kt\ncom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitor\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n33#2,3:276\n1#3:279\n1869#4,2:280\n*S KotlinDebug\n*F\n+ 1 SingleDeviceAndroidProcessMonitor.kt\ncom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitor\n*L\n90#1:276,3\n133#1:280,2\n*E\n"})
public final class SingleDeviceAndroidProcessMonitor
implements Closeable {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String targetApplicationId;
    @NotNull
    private final IDevice targetDevice;
    @NotNull
    private SingleDeviceAndroidProcessMonitorStateListener listener;
    @NotNull
    private final DeploymentApplicationService deploymentApplicationService;
    @NotNull
    private final TextEmitter textEmitter;
    @NotNull
    private final Function1<IDevice, Unit> finishAndroidProcessCallback;
    @NotNull
    private final ScheduledExecutorService stateUpdaterExecutor;
    @NotNull
    private final ReadWriteProperty myState$delegate;
    @NotNull
    private final ConcurrentHashMap<Integer, Unit> myMonitoringPids;
    @Nullable
    private ScheduledFuture<?> myStateUpdaterScheduledFuture;
    @Nullable
    private ScheduledFuture<?> myTimeoutScheduledFuture;
    public static final long POLLING_INTERVAL_MILLIS = 1000L;
    public static final long APP_PROCESS_DISCOVERY_TIMEOUT_MILLIS = 180000L;

    public SingleDeviceAndroidProcessMonitor(@NotNull String targetApplicationId, @NotNull IDevice targetDevice, @NotNull SingleDeviceAndroidProcessMonitorStateListener listener2, @NotNull DeploymentApplicationService deploymentApplicationService, @NotNull TextEmitter textEmitter, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, @NotNull ScheduledExecutorService stateUpdaterExecutor, @NotNull Executor listenerExecutor) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter((Object)targetDevice, (String)"targetDevice");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        Intrinsics.checkNotNullParameter((Object)textEmitter, (String)"textEmitter");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)stateUpdaterExecutor, (String)"stateUpdaterExecutor");
        Intrinsics.checkNotNullParameter((Object)listenerExecutor, (String)"listenerExecutor");
        this.targetApplicationId = targetApplicationId;
        this.targetDevice = targetDevice;
        this.listener = listener2;
        this.deploymentApplicationService = deploymentApplicationService;
        this.textEmitter = textEmitter;
        this.finishAndroidProcessCallback = finishAndroidProcessCallback;
        this.stateUpdaterExecutor = stateUpdaterExecutor;
        Delegates delegates = Delegates.INSTANCE;
        SingleDeviceAndroidProcessMonitorState initialValue$iv = SingleDeviceAndroidProcessMonitorState.INIT;
        boolean $i$f$observable = false;
        this.myState$delegate = (ReadWriteProperty)new ObservableProperty<SingleDeviceAndroidProcessMonitorState>((Object)initialValue$iv, listenerExecutor, this){
            final /* synthetic */ Executor $listenerExecutor$inlined;
            final /* synthetic */ SingleDeviceAndroidProcessMonitor this$0;
            {
                this.$listenerExecutor$inlined = executor;
                this.this$0 = singleDeviceAndroidProcessMonitor;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property2, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                SingleDeviceAndroidProcessMonitorState singleDeviceAndroidProcessMonitorState = (SingleDeviceAndroidProcessMonitorState)((Object)newValue);
                SingleDeviceAndroidProcessMonitorState cfr_ignored_0 = (SingleDeviceAndroidProcessMonitorState)((Object)oldValue);
                boolean bl = false;
                this.$listenerExecutor$inlined.execute(new Runnable(this.this$0, (SingleDeviceAndroidProcessMonitorState)newValue2){
                    final /* synthetic */ SingleDeviceAndroidProcessMonitor this$0;
                    final /* synthetic */ SingleDeviceAndroidProcessMonitorState $newValue;
                    {
                        this.this$0 = $receiver;
                        this.$newValue = $newValue;
                    }

                    public final void run() {
                        SingleDeviceAndroidProcessMonitor.access$getListener$p(this.this$0).onStateChanged(this.this$0, this.$newValue);
                    }
                });
            }
        };
        this.myMonitoringPids = new ConcurrentHashMap();
    }

    public /* synthetic */ SingleDeviceAndroidProcessMonitor(String string, IDevice iDevice, SingleDeviceAndroidProcessMonitorStateListener singleDeviceAndroidProcessMonitorStateListener, DeploymentApplicationService deploymentApplicationService, TextEmitter textEmitter, Function1 function1, ScheduledExecutorService scheduledExecutorService, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = AppExecutorUtil.getAppScheduledExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"getAppScheduledExecutorService(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        if ((n & 0x80) != 0) {
            ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
            executor = executorService;
        }
        this(string, iDevice, singleDeviceAndroidProcessMonitorStateListener, deploymentApplicationService, textEmitter, (Function1<? super IDevice, Unit>)function1, scheduledExecutorService, executor);
    }

    @NotNull
    public final String getTargetApplicationId() {
        return this.targetApplicationId;
    }

    @NotNull
    public final IDevice getTargetDevice() {
        return this.targetDevice;
    }

    private final SingleDeviceAndroidProcessMonitorState getMyState() {
        return (SingleDeviceAndroidProcessMonitorState)((Object)this.myState$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    private final void setMyState(SingleDeviceAndroidProcessMonitorState singleDeviceAndroidProcessMonitorState) {
        this.myState$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)singleDeviceAndroidProcessMonitorState);
    }

    public final synchronized void start() {
        boolean bl;
        boolean bl2 = bl = this.getMyState() == SingleDeviceAndroidProcessMonitorState.INIT;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "State: " + this.getMyState();
            throw new AssertionError((Object)string);
        }
        this.setMyState(SingleDeviceAndroidProcessMonitorState.WAITING_FOR_PROCESS);
        this.myStateUpdaterScheduledFuture = this.stateUpdaterExecutor.scheduleWithFixedDelay(this::updateState, 0L, 1000L, TimeUnit.MILLISECONDS);
        this.myTimeoutScheduledFuture = this.stateUpdaterExecutor.schedule(this::timeout, 180000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateState() {
        SingleDeviceAndroidProcessMonitor singleDeviceAndroidProcessMonitor = this;
        synchronized (singleDeviceAndroidProcessMonitor) {
            boolean bl = false;
            if (SingleDeviceAndroidProcessMonitorKt.isTerminalState(this.getMyState())) {
                ScheduledFuture<?> scheduledFuture = this.myStateUpdaterScheduledFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                this.myStateUpdaterScheduledFuture = null;
                ScheduledFuture<?> scheduledFuture2 = this.myTimeoutScheduledFuture;
                if (scheduledFuture2 != null) {
                    scheduledFuture2.cancel(false);
                }
                this.myTimeoutScheduledFuture = null;
                return;
            }
            Unit $i$a$-synchronized-SingleDeviceAndroidProcessMonitor$updateState$3 = Unit.INSTANCE;
        }
        List<Client> clients = this.deploymentApplicationService.findClient(this.targetDevice, this.targetApplicationId);
        boolean isTargetProcessFound = !((Collection)clients).isEmpty();
        SingleDeviceAndroidProcessMonitor singleDeviceAndroidProcessMonitor2 = this;
        synchronized (singleDeviceAndroidProcessMonitor2) {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getMyState().ordinal()]) {
                case 1: {
                    if (!isTargetProcessFound) break;
                    this.setMyState(SingleDeviceAndroidProcessMonitorState.PROCESS_IS_RUNNING);
                    SingleDeviceAndroidProcessMonitor.updateState$startLogcatOutputCapture(clients, this);
                    break;
                }
                case 2: {
                    if (isTargetProcessFound) break;
                    this.detachAndClose();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final synchronized void timeout() {
        if (this.getMyState() == SingleDeviceAndroidProcessMonitorState.WAITING_FOR_PROCESS) {
            this.setMyState(SingleDeviceAndroidProcessMonitorState.PROCESS_NOT_FOUND);
            this.close();
        }
    }

    public final synchronized void detachAndClose() {
        if (!SingleDeviceAndroidProcessMonitorKt.isTerminalState(this.getMyState())) {
            this.setMyState(SingleDeviceAndroidProcessMonitorState.PROCESS_DETACHED);
            this.close();
        }
    }

    public final synchronized void replaceListenerAndClose(@Nullable SingleDeviceAndroidProcessMonitorStateListener newListener) {
        SingleDeviceAndroidProcessMonitorStateListener singleDeviceAndroidProcessMonitorStateListener = newListener;
        if (singleDeviceAndroidProcessMonitorStateListener == null) {
            singleDeviceAndroidProcessMonitorStateListener = new SingleDeviceAndroidProcessMonitorStateListener(){

                public void onStateChanged(SingleDeviceAndroidProcessMonitor monitor, SingleDeviceAndroidProcessMonitorState newState2) {
                    Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
                    Intrinsics.checkNotNullParameter((Object)((Object)newState2), (String)"newState");
                }
            };
        }
        this.listener = singleDeviceAndroidProcessMonitorStateListener;
        this.close();
    }

    @Override
    @WorkerThread
    public synchronized void close() {
        block5: {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getMyState().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    this.finishAndroidProcessCallback.invoke((Object)this.targetDevice);
                    this.setMyState(SingleDeviceAndroidProcessMonitorState.PROCESS_FINISHED);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ScheduledFuture<?> scheduledFuture = this.myStateUpdaterScheduledFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            ScheduledFuture<?> scheduledFuture2 = this.myTimeoutScheduledFuture;
            if (scheduledFuture2 == null) break block5;
            scheduledFuture2.cancel(false);
        }
    }

    private static final void updateState$startLogcatOutputCapture(List<? extends Client> clients, SingleDeviceAndroidProcessMonitor this$0) {
        Iterable $this$forEach$iv = clients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Client client = (Client)element$iv;
            boolean bl = false;
            this$0.myMonitoringPids.computeIfAbsent(client.getClientData().getPid(), arg_0 -> SingleDeviceAndroidProcessMonitor.updateState$startLogcatOutputCapture$lambda$1$1(arg_0 -> SingleDeviceAndroidProcessMonitor.updateState$startLogcatOutputCapture$lambda$1$0(this$0, arg_0), arg_0));
        }
    }

    private static final Unit updateState$startLogcatOutputCapture$lambda$1$0(SingleDeviceAndroidProcessMonitor this$0, Integer pid) {
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        TextEmitter textEmitter = this$0.textEmitter;
        String string = "Connected to process " + pid + " on device '" + this$0.targetDevice.getName() + "'.\n";
        Key key = ProcessOutputTypes.STDOUT;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"STDOUT");
        textEmitter.emit(string, key);
        return Unit.INSTANCE;
    }

    private static final Unit updateState$startLogcatOutputCapture$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ SingleDeviceAndroidProcessMonitorStateListener access$getListener$p(SingleDeviceAndroidProcessMonitor $this) {
        return $this.listener;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SingleDeviceAndroidProcessMonitor.class, "myState", "getMyState()Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorState;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitor$Companion;", "", "<init>", "()V", "POLLING_INTERVAL_MILLIS", "", "APP_PROCESS_DISCOVERY_TIMEOUT_MILLIS", "intellij.android.execution.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SingleDeviceAndroidProcessMonitorState.values().length];
            try {
                nArray[SingleDeviceAndroidProcessMonitorState.WAITING_FOR_PROCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SingleDeviceAndroidProcessMonitorState.PROCESS_IS_RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SingleDeviceAndroidProcessMonitorState.INIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SingleDeviceAndroidProcessMonitorState.PROCESS_DETACHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SingleDeviceAndroidProcessMonitorState.PROCESS_FINISHED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SingleDeviceAndroidProcessMonitorState.PROCESS_NOT_FOUND.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

