/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.ddmlib.Client;
import com.android.tools.idea.execution.common.debug.utils.FacetFinderToken;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ApplicationProjectContextProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/execution/common/debug/utils/FacetFinder;", "", "<init>", "()V", "findFacetForProcess", "Lcom/android/tools/idea/execution/common/debug/utils/FacetFinder$Result;", "project", "Lcom/intellij/openapi/project/Project;", "client", "Lcom/android/ddmlib/Client;", "tryFindFacetForProcess", "info", "Lcom/android/tools/idea/projectsystem/ApplicationProjectContextProvider$RunningApplicationIdentity;", "findFacetForApplicationId", "applicationId", "", "findFacetForGlobalProcess", "processName", "androidModuleTypeComparator", "Ljava/util/Comparator;", "Lcom/intellij/openapi/module/Module;", "Lkotlin/Comparator;", "Result", "intellij.android.execution.common"})
@SourceDebugExtension(value={"SMAP\nFacetFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetFinder.kt\ncom/android/tools/idea/execution/common/debug/utils/FacetFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class FacetFinder {
    @NotNull
    public static final FacetFinder INSTANCE = new FacetFinder();
    @NotNull
    private static final Comparator<Module> androidModuleTypeComparator;

    private FacetFinder() {
    }

    @NotNull
    public final Result findFacetForProcess(@NotNull Project project, @NotNull Client client) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Result result2 = this.tryFindFacetForProcess(project, ApplicationProjectContextProvider.RunningApplicationIdentity.Companion.asRunningApplicationIdentity(client));
        if (result2 == null) {
            throw new ExecutionException("Unable to find project context to attach debugger for process " + client.getClientData().getProcessName());
        }
        return result2;
    }

    @Nullable
    public final Result tryFindFacetForProcess(@NotNull Project project, @NotNull ApplicationProjectContextProvider.RunningApplicationIdentity info) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                object = info.getHeuristicApplicationId();
                if (object == null) break block5;
                String heuristicApplicationId = object;
                boolean bl = false;
                Result result2 = INSTANCE.findFacetForApplicationId(project, heuristicApplicationId);
                object = result2;
                if (result2 != null) break block6;
            }
            String string = info.getProcessName();
            if (string != null) {
                String clientDescription = string;
                boolean bl = false;
                object = INSTANCE.findFacetForGlobalProcess(project, clientDescription);
            } else {
                object = null;
            }
        }
        return object;
    }

    private final Result findFacetForApplicationId(Project project, String applicationId2) {
        Result result2;
        Module module = (Module)CollectionsKt.lastOrNull((Iterable)ProjectSystemUtil.getProjectSystem(project).findModulesWithApplicationId(applicationId2));
        if (module != null && (module = ModuleExtensionsKt.getAndroidFacet((Module)module)) != null) {
            Module it = module;
            boolean bl = false;
            result2 = new Result((AndroidFacet)it, applicationId2);
        } else {
            result2 = null;
        }
        return result2;
    }

    private final Result findFacetForGlobalProcess(Project project, String processName) {
        Module module = FacetFinderToken.Companion.findGlobalProcessDefinition(project, processName);
        if (module == null) {
            return null;
        }
        Module definingModule = module;
        AndroidModuleSystem definingModuleSystem = ProjectSystemUtil.getModuleSystem(definingModule);
        if (FacetFinderToken.Companion.isDirectlyDeployable(project, definingModule)) {
            String string;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)definingModule);
            if (androidFacet == null) {
                throw new IllegalStateException("AndroidFacet is null".toString());
            }
            AndroidFacet androidFacet2 = androidFacet;
            ApplicationIdProvider applicationIdProvider = definingModuleSystem.getApplicationIdProvider();
            AndroidFacet androidFacet3 = androidFacet2;
            boolean bl = false;
            if (FacetFinderToken.Companion.hasTestNature(project, definingModule)) {
                string = it.getTestPackageName();
                if (string == null) {
                    throw new IllegalStateException("testPackageName is null".toString());
                }
            } else {
                String string2 = it.getPackageName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
            }
            String string3 = string;
            AndroidFacet androidFacet4 = androidFacet3;
            return new Result(androidFacet4, string3);
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        Collection collection2 = GraphAlgorithms.getInstance().findNodeNeighbourhood(moduleManager.moduleGraph(), (Object)definingModule, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findNodeNeighbourhood(...)");
        Collection candidates2 = collection2;
        Iterable iterable = candidates2;
        Comparator<Module> comparator = ProjectSystemUtil.getProjectSystem(project).getProjectSystemModuleTypeComparator().reversed().thenComparing(androidModuleTypeComparator).thenComparing(moduleManager.moduleDependencyComparator());
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        Module module2 = (Module)CollectionsKt.maxWithOrNull((Iterable)iterable, comparator);
        if (module2 == null) {
            return null;
        }
        Module candidate = module2;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)candidate);
        if (androidFacet == null) {
            throw new IllegalStateException((candidate.getName() + " depends on an AndroidModule " + definingModule.getName() + " but AndroidFacet was not found").toString());
        }
        AndroidFacet androidFacet5 = androidFacet;
        String string = ProjectSystemUtil.getModuleSystem(androidFacet5).getApplicationIdProvider().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        return new Result(androidFacet5, string);
    }

    private static final Integer androidModuleTypeComparator$lambda$0(Module it) {
        Intrinsics.checkNotNull((Object)it);
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(it);
        return switch (WhenMappings.$EnumSwitchMapping$0[moduleSystem.getType().ordinal()]) {
            case 1 -> 0;
            case 2, 3 -> 1;
            case 4 -> 2;
            case 5, 6, 7, 8, 9 -> 3;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Integer androidModuleTypeComparator$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    static {
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> FacetFinder.androidModuleTypeComparator$lambda$1(FacetFinder::androidModuleTypeComparator$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        androidModuleTypeComparator = comparator;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/execution/common/debug/utils/FacetFinder$Result;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "applicationId", "", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Ljava/lang/String;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "getApplicationId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.execution.common"})
    public static final class Result {
        @NotNull
        private final AndroidFacet facet;
        @NotNull
        private final String applicationId;

        public Result(@NotNull AndroidFacet facet, @NotNull String applicationId2) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
            this.facet = facet;
            this.applicationId = applicationId2;
        }

        @NotNull
        public final AndroidFacet getFacet() {
            return this.facet;
        }

        @NotNull
        public final String getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final AndroidFacet component1() {
            return this.facet;
        }

        @NotNull
        public final String component2() {
            return this.applicationId;
        }

        @NotNull
        public final Result copy(@NotNull AndroidFacet facet, @NotNull String applicationId2) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
            return new Result(facet, applicationId2);
        }

        public static /* synthetic */ Result copy$default(Result result2, AndroidFacet androidFacet, String string, int n, Object object) {
            if ((n & 1) != 0) {
                androidFacet = result2.facet;
            }
            if ((n & 2) != 0) {
                string = result2.applicationId;
            }
            return result2.copy(androidFacet, string);
        }

        @NotNull
        public String toString() {
            return "Result(facet=" + this.facet + ", applicationId=" + this.applicationId + ")";
        }

        public int hashCode() {
            int result2 = this.facet.hashCode();
            result2 = result2 * 31 + this.applicationId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.facet, (Object)result2.facet)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.applicationId, (Object)result2.applicationId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidModuleSystem.Type.values().length];
            try {
                nArray[AndroidModuleSystem.Type.TYPE_NON_ANDROID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_LIBRARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_FUSED_LIBRARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_TEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_APP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_INSTANTAPP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_ATOM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_FEATURE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidModuleSystem.Type.TYPE_DYNAMIC_FEATURE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

