/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.applychanges;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.UtilsKt;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAction
extends AnAction {
    public static final Key<Boolean> SHOW_APPLY_CHANGES_UI = Key.create((String)"android.deploy.ApplyChanges.ShowUI");
    private static final Logger LOG = Logger.getInstance(BaseAction.class);
    @NotNull
    protected final String myName;
    @NotNull
    protected final Icon myIcon;
    @NotNull
    private final SwapInfo.SwapType mySwapType;
    @NotNull
    private final String myDescription;

    public BaseAction(@NotNull String id2, @NotNull String name2, @NotNull String acceleratorName, @NotNull SwapInfo.SwapType swapType, @NotNull Icon icon, @NotNull Shortcut shortcut, @NotNull String description2) {
        super(acceleratorName, description2, icon);
        this.myName = name2;
        this.mySwapType = swapType;
        this.myIcon = icon;
        this.myDescription = description2;
        KeymapManager manager = KeymapManager.getInstance();
        if (manager != null) {
            Shortcut[] uraShortcuts;
            Keymap keymap = manager.getActiveKeymap();
            List<Shortcut> shortcuts = Arrays.asList(keymap.getShortcuts(id2));
            if (shortcuts.isEmpty()) {
                keymap.addShortcut(id2, shortcut);
                shortcuts = Collections.singletonList(shortcut);
            }
            String updateRunningApplicationId = "UpdateRunningApplication";
            for (Shortcut uraShortcut : uraShortcuts = keymap.getShortcuts("UpdateRunningApplication")) {
                if (!shortcuts.contains(uraShortcut)) continue;
                keymap.removeShortcut("UpdateRunningApplication", uraShortcut);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null || !CommonAndroidUtil.getInstance().isAndroidProject(project)) {
            presentation.setVisible(false);
            return;
        }
        DisableMessage disableMessage = BaseAction.getDisableMessage(project);
        if (disableMessage == null) {
            presentation.setVisible(true);
            presentation.setEnabled(true);
            presentation.setText(this.myName);
            presentation.setDescription(this.myDescription);
        } else {
            this.disableAction(presentation, disableMessage);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Executor executor;
        Project project = e.getProject();
        if (project == null) {
            LOG.warn(this.myName + " action performed with no project");
            return;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        AndroidExecutionTarget selectedExecutionTarget = (AndroidExecutionTarget)ExecutionTargetManager.getActiveTarget((Project)project);
        if (settings == null) {
            LOG.warn(this.myName + " action could not locate current run config settings");
            return;
        }
        List<ProcessHandler> runningProcessHandlers = UtilsKt.getProcessHandlersForDevices(settings, project, selectedExecutionTarget.getRunningDevices().stream().toList());
        List<Executor> executors = BaseAction.getRunningExecutorsOfDifferentType(project, runningProcessHandlers);
        Executor executor2 = executor = executors.isEmpty() ? DefaultRunExecutor.getRunExecutorInstance() : executors.get(0);
        if (executor == null) {
            LOG.warn(this.myName + " action could not identify executor of existing running application");
            return;
        }
        ExecutionEnvironmentBuilder builder = null;
        try {
            builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)settings);
        }
        catch (ExecutionException ex) {
            LOG.error(this.myName + " ExecutionException " + ex.getMessage());
            return;
        }
        ExecutionEnvironment env = builder.activeTarget().dataContext(e.getDataContext()).build();
        env.putUserData(SwapInfo.SWAP_INFO_KEY, (Object)new SwapInfo(this.mySwapType));
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    protected void disableAction(@NotNull Presentation presentation, @NotNull DisableMessage disableMessage) {
        if (!presentation.isVisible()) {
            return;
        }
        presentation.setVisible(disableMessage.myDisableMode != DisableMessage.DisableMode.INVISIBLE);
        presentation.setEnabled(false);
        presentation.setText(String.format("%s (disabled: %s)", this.myName, disableMessage.myTooltip));
        presentation.setDescription(String.format("%s is disabled for this device because %s.", this.myName, disableMessage.myDescription));
    }

    @Nullable
    public static DisableMessage getDisableMessage(@NotNull Project project) {
        Executor executor;
        String applicationId2;
        RunnerAndConfigurationSettings configSettings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (configSettings == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "no configuration selected", "there is no configuration selected");
        }
        RunConfiguration selectedRunConfig = configSettings.getConfiguration();
        if (!BaseAction.isApplyChangesRelevant(selectedRunConfig)) {
            return new DisableMessage(DisableMessage.DisableMode.INVISIBLE, "unsupported configuration", "the selected configuration is not supported");
        }
        ApplicationIdProvider applicationIdProvider = ProjectSystemUtil.getProjectSystem(project).getApplicationIdProvider(selectedRunConfig);
        if (applicationIdProvider == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "can't detect applicationId", "can't detect applicationId");
        }
        try {
            applicationId2 = applicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "can't detect applicationId", "can't detect applicationId");
        }
        ExecutionTarget selectedExecutionTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        if (!(selectedExecutionTarget instanceof AndroidExecutionTarget)) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unsupported execution target", "unsupported execution target");
        }
        AndroidExecutionTarget androidExecutionTarget = (AndroidExecutionTarget)selectedExecutionTarget;
        Collection<IDevice> devices2 = androidExecutionTarget.getRunningDevices();
        if (devices2.isEmpty()) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "devices not connected", "the selected devices are not connected");
        }
        if (devices2.stream().anyMatch(d -> Objects.equals(d.getState(), IDevice.DeviceState.UNAUTHORIZED))) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "device not authorized", "the selected device is not authorized");
        }
        if (devices2.stream().anyMatch(d -> !d.arePropertiesSet())) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "device not ready", "the selected device is not ready yet");
        }
        if (devices2.stream().anyMatch(d -> !d.getVersion().isAtLeast(26))) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "incompatible device API level", "its API level is lower than 26");
        }
        if (devices2.stream().allMatch(d -> DeploymentApplicationService.getInstance().findClient((IDevice)d, applicationId2).isEmpty())) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "app not detected", "the app is not yet running or not debuggable");
        }
        if (BaseAction.isExecutorStarting(project, configSettings)) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "building and/or launching", "the selected configuration is currently building and/or launching");
        }
        List<ProcessHandler> runningProcessHandlers = UtilsKt.getProcessHandlersForDevices(configSettings, project, devices2.stream().toList());
        List<Executor> executors = BaseAction.getRunningExecutorsOfDifferentType(project, runningProcessHandlers);
        if (executors.size() > 1) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "more than one executor is running", "more than one type of executor is running configuration");
        }
        Executor executor2 = executor = executors.isEmpty() ? DefaultRunExecutor.getRunExecutorInstance() : executors.get(0);
        if (ProgramRunner.getRunner((String)executor.getId(), (RunProfile)selectedRunConfig) == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "no runner available", "there are no Program Runners available to run the given configuration (perhaps project needs a sync?)");
        }
        return null;
    }

    private static boolean isApplyChangesRelevant(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configBase = (RunConfigurationBase)runConfiguration;
            return (Boolean)configBase.putUserDataIfAbsent(SHOW_APPLY_CHANGES_UI, (Object)false);
        }
        return false;
    }

    private static boolean isExecutorStarting(@NotNull Project project, @NotNull RunnerAndConfigurationSettings settings) {
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            ProgramRunner programRunner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)settings.getConfiguration());
            if (programRunner == null || !ExecutionManager.getInstance((Project)project).isStarting(settings.getUniqueID(), executor.getId(), programRunner.getRunnerId())) continue;
            return true;
        }
        return false;
    }

    protected static List<Executor> getRunningExecutorsOfDifferentType(@NotNull Project project, List<ProcessHandler> processHandlers) {
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance((Project)project);
        List<RunContentDescriptor> runningDescriptors = executionManager.getRunningDescriptors(c -> true).stream().filter(d -> processHandlers.contains(d.getProcessHandler())).toList();
        return runningDescriptors.stream().flatMap(r -> ExecutionManagerImpl.getInstance((Project)project).getExecutors(r).stream()).distinct().toList();
    }

    public static final class DisableMessage {
        @NotNull
        private final DisableMode myDisableMode;
        @NotNull
        private final String myTooltip;
        @NotNull
        private final String myDescription;

        public DisableMessage(@NotNull DisableMode disableMode, @NotNull String tooltip, @NotNull String description2) {
            this.myDisableMode = disableMode;
            this.myTooltip = tooltip;
            this.myDescription = description2;
        }

        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        public static enum DisableMode {
            INVISIBLE,
            DISABLED;

        }
    }
}

