/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.SubTableModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.RowSorter;
import javax.swing.event.RowSorterEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SubTableRowSorter<M>
extends RowSorter<SubTableModel> {
    @NotNull
    private final RowSorter<M> myDelegate;
    @NotNull
    private final SubTableModel myModel;

    SubTableRowSorter(@NotNull RowSorter<M> delegate2, @NotNull SubTableModel model) {
        delegate2.addRowSorterListener(event -> {
            RowSorterEvent.Type type = event.getType();
            switch (type) {
                case SORT_ORDER_CHANGED: {
                    this.fireSortOrderChanged();
                    break;
                }
                case SORTED: {
                    this.fireRowSorterChanged(null);
                    break;
                }
                default: {
                    assert (false) : type;
                    break;
                }
            }
        });
        this.myDelegate = delegate2;
        this.myModel = model;
    }

    @Override
    @NotNull
    public SubTableModel getModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toggleSortOrder(int modelColumnIndex) {
        this.myDelegate.toggleSortOrder(this.myModel.convertColumnIndexToDelegate(modelColumnIndex));
    }

    @Override
    public int convertRowIndexToModel(int viewRowIndex) {
        return this.myDelegate.convertRowIndexToModel(viewRowIndex);
    }

    @Override
    public int convertRowIndexToView(int modelRowIndex) {
        return this.myDelegate.convertRowIndexToView(modelRowIndex);
    }

    @Override
    public void setSortKeys(@Nullable List<? extends RowSorter.SortKey> keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.myDelegate.getSortKeys().stream().filter(key -> this.myModel.contains(key.getColumn())).map(key -> new RowSorter.SortKey(this.myModel.convertColumnIndexToModel(key.getColumn()), key.getSortOrder())).collect(Collectors.toList());
    }

    @Override
    public int getViewRowCount() {
        return this.myDelegate.getViewRowCount();
    }

    @Override
    public int getModelRowCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public void rowsInserted(int startModelRowIndex, int endModelRowIndex) {
    }

    @Override
    public void rowsDeleted(int startModelRowIndex, int endModelRowIndex) {
    }

    @Override
    public void rowsUpdated(int startModelRowIndex, int endModelRowIndex) {
    }

    @Override
    public void rowsUpdated(int startModelRowIndex, int endModelRowIndex, int modelColumnIndex) {
    }
}

