/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceEditorNotificationProvider
implements EditorNotificationProvider {
    private boolean myHide;

    @Nullable
    public Function<FileEditor, InfoPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (this.myHide || !StringResourceEditorProvider.canViewTranslations(project, file)) {
            return null;
        }
        return fileEditor -> {
            InfoPanel panel2 = new InfoPanel((FileEditor)fileEditor);
            panel2.setText("Edit translations for all locales in the translations editor.");
            panel2.createActionLabel("Open editor", () -> StringResourceEditorProvider.openEditor(project, file));
            panel2.createActionLabel("Hide notification", () -> {
                panel2.setVisible(false);
                this.myHide = true;
            });
            return panel2;
        };
    }

    public static class InfoPanel
    extends EditorNotificationPanel {
        public InfoPanel(@NotNull FileEditor fileEditor) {
            super(fileEditor, null, EditorColors.READONLY_BACKGROUND_COLOR, EditorNotificationPanel.Status.Info);
        }

        @NotNull
        public Color getFallbackBackgroundColor() {
            return UIUtil.getPanelBackground();
        }
    }
}

