/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.model.StringResourceRepository;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ResourceLoadingTask
extends Task.Backgroundable {
    @NotNull
    private final StringResourceViewPanel myPanel;
    @NotNull
    private final Supplier<? extends LocalResourceRepository<VirtualFile>> myGetModuleResources;
    @Nullable
    private StringResourceTableModel myStringResourceTableModel;

    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2) {
        this(panel2, () -> StudioResourceRepositoryManager.getModuleResources(panel2.getFacet()));
    }

    @VisibleForTesting
    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2, @NotNull Supplier<? extends LocalResourceRepository<VirtualFile>> getModuleResources) {
        super(panel2.getFacet().getModule().getProject(), "Loading String Resources...");
        this.myPanel = panel2;
        this.myGetModuleResources = getModuleResources;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        LocalResourceRepository<VirtualFile> localResourceRepository = this.myGetModuleResources.get();
        StringResourceRepository repository2 = StringResourceRepository.create(localResourceRepository, this.getProject());
        CountDownLatch latch = new CountDownLatch(1);
        localResourceRepository.invokeAfterPendingUpdatesFinish((Executor)EdtExecutorService.getInstance(), latch::countDown);
        try {
            latch.await();
        }
        catch (Throwable e) {
            this.onThrowable(e);
        }
        this.myStringResourceTableModel = new StringResourceTableModel(repository2, this.myPanel.getFacet().getModule().getProject());
    }

    public void onSuccess() {
        assert (this.myStringResourceTableModel != null);
        this.myPanel.getTable().setModel(this.myStringResourceTableModel);
        this.myPanel.addUpdateListenerToNewStringResourceModel();
        this.myPanel.stopLoading();
    }

    public void onCancel() {
        this.myPanel.stopLoading();
    }
}

