/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestEditor
extends UserDataHolderBase
implements FileEditor {
    private volatile boolean showingStaleManifest;
    private volatile boolean failedToComputeFreshManifest;
    private final AndroidFacet myFacet;
    private JPanel myLazyContainer;
    private ManifestPanel myManifestPanel;
    private final VirtualFile mySelectedFile;
    private boolean mySelected;
    private final PsiTreeChangeListener myPsiChangeListener = new PsiTreeChangeAdapter(){

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }
    };

    public ManifestEditor(@NotNull AndroidFacet facet, @NotNull VirtualFile manifestFile) {
        this.myFacet = facet;
        this.mySelectedFile = manifestFile;
        this.myLazyContainer = new JPanel(new BorderLayout());
    }

    private void psiChange(PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        if (file != null && "AndroidManifest.xml".equals(file.getName())) {
            ApplicationManager.getApplication().invokeLater(this::reload);
        }
    }

    private void reload() {
        if (!this.mySelected) {
            return;
        }
        AsyncSupplier<MergedManifestSnapshot> supplier = MergedManifestManager.getMergedManifestSupplier(this.myFacet.getModule());
        ListenableFuture mergedManifest = supplier.get();
        if (mergedManifest.isDone()) {
            try {
                this.showFreshManifest((MergedManifestSnapshot)mergedManifest.get());
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.getInstance(ManifestEditor.class).warn("Error computing fresh merged manifest for module " + this.myFacet.getModule().getName(), (Throwable)e);
                this.showLoadingError();
            }
            return;
        }
        MergedManifestSnapshot cachedManifest = (MergedManifestSnapshot)supplier.getNow();
        if (cachedManifest != null) {
            this.showStaleManifest(cachedManifest);
        } else {
            this.myManifestPanel.startLoading();
        }
        Futures.addCallback((ListenableFuture)mergedManifest, (FutureCallback)new FutureCallback<MergedManifestSnapshot>(){

            public void onSuccess(MergedManifestSnapshot result2) {
                ManifestEditor.this.showFreshManifest(result2);
            }

            public void onFailure(@Nullable Throwable t) {
                Logger.getInstance(ManifestEditor.class).warn("Error computing fresh merged manifest for module " + ManifestEditor.this.myFacet.getModule().getName(), t);
                ManifestEditor.this.showLoadingError();
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void showStaleManifest(MergedManifestSnapshot manifest) {
        this.showingStaleManifest = true;
        this.myManifestPanel.showManifest(manifest, this.mySelectedFile, false);
        EditorNotifications.getInstance((Project)this.myFacet.getModule().getProject()).updateNotifications(this.mySelectedFile);
    }

    private void showFreshManifest(MergedManifestSnapshot manifest) {
        if (this.showingStaleManifest || this.failedToComputeFreshManifest) {
            this.showingStaleManifest = false;
            this.failedToComputeFreshManifest = false;
            EditorNotifications.getInstance((Project)this.myFacet.getModule().getProject()).updateNotifications(this.mySelectedFile);
        }
        this.myManifestPanel.showManifest(manifest, this.mySelectedFile, true);
    }

    private void showLoadingError() {
        this.failedToComputeFreshManifest = true;
        if (this.showingStaleManifest) {
            EditorNotifications.getInstance((Project)this.myFacet.getModule().getProject()).updateNotifications(this.mySelectedFile);
        } else {
            this.myManifestPanel.showLoadingError();
        }
    }

    public boolean isShowingStaleManifest() {
        return this.showingStaleManifest;
    }

    public boolean failedToComputeFreshManifest() {
        return this.failedToComputeFreshManifest;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myLazyContainer;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.mySelectedFile;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Merged Manifest";
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.mySelected = true;
        Project project = this.myFacet.getModule().getProject();
        if (this.myManifestPanel == null) {
            this.myManifestPanel = new ManifestPanel(this.myFacet, (Disposable)this);
            this.myLazyContainer.add(this.myManifestPanel);
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
                if (result2.isSuccessful()) {
                    this.reload();
                }
            });
        }
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiChangeListener, (Disposable)this);
        this.reload();
    }

    public void deselectNotify() {
        this.mySelected = false;
        Project thisProject = this.myFacet.getModule().getProject();
        PsiManager.getInstance((Project)thisProject).removePsiTreeChangeListener(this.myPsiChangeListener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }
}

