/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.intellij.lang.properties.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;

public class GradleImplicitPropertyUsageProvider
implements ImplicitPropertyUsageProvider {
    private static final Collection<String> AGP_USED_LOCAL_PROPERTIES = Arrays.asList("sdk.dir", "ndk.dir", "android.dir", "cmake.dir", "ndk.symlinkdir");

    public boolean isUsed(Property property2) {
        Project project = property2.getProject();
        if (!(ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem)) {
            return false;
        }
        PsiFile file = property2.getContainingFile();
        boolean caseSensitive = file.getViewProvider().getVirtualFile().isCaseSensitive();
        if (Comparing.equal((String)file.getName(), (String)"gradle-wrapper.properties", (boolean)caseSensitive)) {
            return true;
        }
        if (Comparing.equal((String)file.getName(), (String)"gradle.properties", (boolean)caseSensitive) || Comparing.equal((String)file.getName(), (String)"resources.properties", (boolean)caseSensitive)) {
            return true;
        }
        if (Comparing.equal((String)file.getName(), (String)"local.properties", (boolean)caseSensitive)) {
            String name2 = property2.getName();
            return AGP_USED_LOCAL_PROPERTIES.contains(name2);
        }
        return false;
    }
}

