/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editing.documentation;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.idea.editing.documentation.AndroidJavaDocRenderer;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.utils.DataBindingUtils;
import com.android.utils.Pair;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.reference.SoftReference;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.ProvidedDocumentationPsiElement;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlDocumentationProvider
implements DocumentationProvider {
    private static final Key<java.lang.ref.SoftReference<Map<XmlName, CachedValue<String>>>> ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY = Key.create((String)"ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE");

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof ResourceReferencePsiElement) {
            return ((ResourceReferencePsiElement)element).getResourceReference().getResourceUrl().toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        PomTarget target2;
        if (element instanceof ProvidedDocumentationPsiElement) {
            return ((ProvidedDocumentationPsiElement)element).getDocumentation();
        }
        if (element instanceof ResourceReferencePsiElement) {
            ResourceUrl originalUrl = originalElement != null ? ResourceUrl.parse((String)originalElement.getText()) : null;
            ResourceReference resourceReference = ((ResourceReferencePsiElement)element).getResourceReference();
            if (resourceReference.getResourceType().equals((Object)ResourceType.ATTR) && originalUrl != null) {
                return AndroidXmlDocumentationProvider.generateDoc(originalElement, originalUrl);
            }
            ResourceUrl resourceUrl = resourceReference.getResourceUrl();
            return AndroidXmlDocumentationProvider.generateDoc(originalElement, resourceUrl);
        }
        if (element instanceof ResourceReferenceCompletionElement) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element.getParent(), ((ResourceReferenceCompletionElement)element).myResource);
        }
        if (element instanceof XmlAttributeValue) {
            return AndroidXmlDocumentationProvider.getResourceDocumentation(element, ((XmlAttributeValue)element).getValue());
        }
        if (element instanceof MyDocElement) {
            return ((MyDocElement)element).getDocumentation();
        }
        if (originalElement instanceof XmlToken) {
            String text2;
            String documentation;
            PsiElement prev;
            XmlToken token = (XmlToken)originalElement;
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                PsiElement next = token.getNextSibling();
                if (next instanceof XmlToken) {
                    token = (XmlToken)next;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (prev = token.getPrevSibling()) instanceof XmlToken) {
                token = (XmlToken)prev;
            }
            if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                String documentation2 = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, token.getText());
                if (documentation2 != null) {
                    return documentation2;
                }
            } else if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (documentation = AndroidXmlDocumentationProvider.getResourceDocumentation(originalElement, text2 = token.getText().trim())) != null) {
                return documentation;
            }
        }
        if (element instanceof PomTargetPsiElement && originalElement != null && (target2 = ((PomTargetPsiElement)element).getTarget()) instanceof DomAttributeChildDescription) {
            Key<java.lang.ref.SoftReference<Map<XmlName, CachedValue<String>>>> key = ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY;
            synchronized (key) {
                return AndroidXmlDocumentationProvider.generateDocForXmlAttribute((DomAttributeChildDescription)target2, originalElement);
            }
        }
        return null;
    }

    @Nullable
    private static String getResourceDocumentation(PsiElement element, String value2) {
        ResourceUrl url = ResourceUrl.parse((String)value2);
        if (url != null) {
            return AndroidXmlDocumentationProvider.generateDoc(element, url);
        }
        XmlAttribute attribute2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
        XmlTag tag = null;
        boolean isXmlValue = false;
        if (element instanceof XmlToken && XmlTokenType.XML_DATA_CHARACTERS.equals(((XmlToken)element).getTokenType())) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            attribute2 = tag == null ? null : tag.getAttribute("name");
            isXmlValue = true;
        }
        if (attribute2 == null) {
            return null;
        }
        if ("name".equals(attribute2.getName())) {
            XmlTag parentTag = (tag = tag != null ? tag : attribute2.getParent()).getParentTag();
            if (parentTag == null) {
                return null;
            }
            if ("resources".equals(parentTag.getName())) {
                ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                if (type != null) {
                    return AndroidXmlDocumentationProvider.generateDoc(element, type, value2, false);
                }
            } else if ("style".equals(parentTag.getName())) {
                AttributeDefinition attributeDefinition;
                String targetValue = value2;
                if (isXmlValue && attribute2.getValue() != null) {
                    targetValue = attribute2.getValue();
                }
                if ((attributeDefinition = AndroidXmlDocumentationProvider.getAttributeDefinitionForElement(element, targetValue = StringUtil.trimStart((String)targetValue, (String)"android:"))) == null) {
                    return null;
                }
                return StringUtil.trim((String)(isXmlValue ? attributeDefinition.getValueDescription(value2) : attributeDefinition.getDescription(null)));
            }
        }
        if ("http://schemas.android.com/apk/res/android".equals(attribute2.getNamespace())) {
            AttributeDefinition attributeDefinition = AndroidXmlDocumentationProvider.getAttributeDefinitionForElement(element, attribute2.getLocalName());
            if (attributeDefinition == null) {
                return null;
            }
            return StringUtil.trim((String)attributeDefinition.getValueDescription(value2));
        }
        return null;
    }

    @Nullable
    private static AttributeDefinition getAttributeDefinitionForElement(@NotNull PsiElement element, @NotNull String name2) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)element);
        if (facet == null) {
            return null;
        }
        AttributeDefinitions definitions = AndroidXmlDocumentationProvider.getAttributeDefinitions(ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager());
        if (definitions == null) {
            return null;
        }
        AttributeDefinition attributeDefinition = definitions.getAttrDefByName(name2);
        if (attributeDefinition == null) {
            definitions = AndroidXmlDocumentationProvider.getAttributeDefinitions(ModuleResourceManagers.getInstance(facet).getLocalResourceManager());
            if (definitions == null) {
                return null;
            }
            attributeDefinition = definitions.getAttrDefByName(name2);
        }
        return attributeDefinition;
    }

    @Nullable
    private static AttributeDefinitions getAttributeDefinitions(@Nullable ResourceManager manager) {
        return manager == null ? null : manager.getAttributeDefinitions();
    }

    @Nullable
    private static String generateDocForXmlAttribute(@NotNull DomAttributeChildDescription description2, @NotNull PsiElement originalElement) {
        CachedValue cachedDoc;
        XmlName xmlName = description2.getXmlName();
        HashMap<XmlName, CachedValue> cachedDocsMap = (HashMap<XmlName, CachedValue>)SoftReference.dereference((Reference)((Reference)originalElement.getUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY)));
        if (cachedDocsMap != null && (cachedDoc = (CachedValue)cachedDocsMap.get(xmlName)) != null) {
            return (String)cachedDoc.getValue();
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)originalElement);
        if (facet == null) {
            return null;
        }
        String localName = xmlName.getLocalName();
        String namespace = xmlName.getNamespaceKey();
        if (namespace == null) {
            return null;
        }
        if ("android".equals(namespace)) {
            namespace = "http://schemas.android.com/apk/res/android";
        }
        if (namespace.startsWith("http://schemas.android.com/apk/res/") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
            String finalNamespace = namespace;
            CachedValue cachedValue = CachedValuesManager.getManager((Project)originalElement.getProject()).createCachedValue(() -> {
                Pair<AttributeDefinition, String> pair = AndroidXmlDocumentationProvider.findAttributeDefinition(originalElement, facet, finalNamespace, localName);
                String doc = pair != null ? AndroidXmlDocumentationProvider.generateDocForXmlAttribute((AttributeDefinition)pair.getFirst(), (String)pair.getSecond()) : null;
                return CachedValueProvider.Result.create((Object)doc, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            if (cachedDocsMap == null) {
                cachedDocsMap = new HashMap<XmlName, CachedValue>();
                originalElement.putUserData(ANDROID_ATTRIBUTE_DOCUMENTATION_CACHE_KEY, new java.lang.ref.SoftReference(cachedDocsMap));
            }
            cachedDocsMap.put(xmlName, cachedValue);
            return (String)cachedValue.getValue();
        }
        return null;
    }

    @Nullable
    private static Pair<AttributeDefinition, String> findAttributeDefinition(@NotNull PsiElement originalElement, @NotNull AndroidFacet facet, @NotNull String namespace, @NotNull String localName) {
        if (!originalElement.isValid()) {
            return null;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (parentTag == null) {
            return null;
        }
        DomElement parentDomElement = DomManager.getDomManager((Project)parentTag.getProject()).getDomElement(parentTag);
        if (!(parentDomElement instanceof AndroidDomElement)) {
            return null;
        }
        Ref result2 = Ref.create();
        try {
            AttributeProcessingUtil.processAttributes((AndroidDomElement)parentDomElement, facet, false, (xn, attrDef, parentStyleableName) -> {
                if (xn.getLocalName().equals(localName) && namespace.equals(xn.getNamespaceKey())) {
                    result2.set((Object)Pair.of((Object)attrDef, (Object)parentStyleableName));
                    throw new MyStopException();
                }
                return null;
            });
        }
        catch (MyStopException myStopException) {
            // empty catch block
        }
        Pair pair = (Pair)result2.get();
        if (pair != null) {
            return pair;
        }
        AttributeDefinition attrDef2 = AndroidXmlDocumentationProvider.findAttributeDefinitionGlobally(facet, namespace, localName);
        return attrDef2 != null ? Pair.of((Object)attrDef2, (Object)null) : null;
    }

    @Nullable
    private static AttributeDefinition findAttributeDefinitionGlobally(@NotNull AndroidFacet facet, @NotNull String namespace, @NotNull String localName) {
        AttributeDefinitions attributes;
        ResourceManager resourceManager = "http://schemas.android.com/apk/res/android".equals(namespace) || "http://schemas.android.com/tools".equals(namespace) ? ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager() : (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/") ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager());
        if (resourceManager != null && (attributes = ((ResourceManager)resourceManager).getAttributeDefinitions()) != null) {
            return attributes.getAttrDefByName(localName);
        }
        return null;
    }

    private static String generateDocForXmlAttribute(@NotNull AttributeDefinition definition, @Nullable String parentStyleable) {
        String docValue;
        String[] values;
        StringBuilder builder = new StringBuilder("<html><body>");
        Set<AttributeFormat> formats = definition.getFormats();
        if (!formats.isEmpty()) {
            builder.append("Formats: ");
            ArrayList<String> formatLabels = new ArrayList<String>(formats.size());
            for (AttributeFormat format : formats) {
                formatLabels.add(StringUtil.toLowerCase((String)format.name()));
            }
            Collections.sort(formatLabels);
            int n = formatLabels.size();
            for (int i = 0; i < n; ++i) {
                builder.append((String)formatLabels.get(i));
                if (i >= n - 1) continue;
                builder.append(", ");
            }
        }
        if ((values = definition.getValues()).length > 0) {
            if (builder.length() > 0) {
                builder.append("<br>");
            }
            builder.append("Values: ");
            Object[] sortedValues = new String[values.length];
            System.arraycopy(values, 0, sortedValues, 0, values.length);
            Arrays.sort(sortedValues);
            for (int i = 0; i < sortedValues.length; ++i) {
                builder.append((String)sortedValues[i]);
                if (i >= sortedValues.length - 1) continue;
                builder.append(", ");
            }
        }
        if ((docValue = definition.getDescriptionByParentStyleableName(parentStyleable)) != null && !docValue.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("<br><br>");
            }
            builder.append(docValue);
        }
        builder.append("</body></html>");
        return builder.toString();
    }

    @Nullable
    private static String generateDoc(PsiElement originalElement, ResourceType type, String name2, boolean framework) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module, type, name2, framework);
    }

    @Nullable
    private static String generateDoc(PsiElement originalElement, ResourceUrl url) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        return AndroidJavaDocRenderer.render(module, null, url);
    }

    public PsiElement getDocumentationElementForLookupItem(@NotNull PsiManager psiManager, @NotNull Object object, @NotNull PsiElement element) {
        if (element instanceof XmlToken) {
            element = element.getParent();
        }
        if (!(element instanceof XmlAttributeValue) && !(element instanceof XmlToken) || !(object instanceof String)) {
            return null;
        }
        String value2 = (String)object;
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return null;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent);
        if (domValue == null) {
            return null;
        }
        Converter converter = domValue.getConverter();
        if ((value2.startsWith("@") || value2.startsWith("?")) && !DataBindingUtils.isBindingExpression((String)value2)) {
            return new ResourceReferenceCompletionElement(element, value2);
        }
        if (converter instanceof AttributeValueDocumentationProvider) {
            return new MyDocElement((XmlAttribute)parent, value2);
        }
        return null;
    }

    public static class ResourceReferenceCompletionElement
    extends FakePsiElement {
        final PsiElement myParent;
        final String myResource;

        private ResourceReferenceCompletionElement(@NotNull PsiElement parent, @NotNull String resource) {
            this.myParent = parent;
            this.myResource = resource;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public String getResource() {
            return this.myResource;
        }

        public PsiFile getContainingFile() {
            return null;
        }

        @NotNull
        public Language getLanguage() {
            return XMLLanguage.INSTANCE;
        }
    }

    private static class MyDocElement
    extends FakePsiElement {
        XmlAttribute myParent;
        String myValue;

        private MyDocElement(@NotNull XmlAttribute parent, String value2) {
            this.myParent = parent;
            this.myValue = value2;
        }

        public String getDocumentation() {
            GenericAttributeValue domValue = DomManager.getDomManager((Project)this.myParent.getProject()).getDomElement(this.myParent);
            if (domValue == null) {
                return null;
            }
            Converter converter = domValue.getConverter();
            return ((AttributeValueDocumentationProvider)converter).getDocumentation(this.myValue);
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        @Nullable
        @NonNls
        public String getText() {
            return this.getDocumentation();
        }
    }

    private static class MyStopException
    extends RuntimeException {
        private MyStopException() {
        }
    }
}

