/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.report;

import com.android.tools.idea.actions.SubmitBugReportAction;
import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/report/SystemInfoFileProvider;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticsSummaryFileProvider;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getFiles", "", "Lcom/android/tools/idea/diagnostics/report/FileInfo;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
public final class SystemInfoFileProvider
implements DiagnosticsSummaryFileProvider {
    @NotNull
    public static final SystemInfoFileProvider INSTANCE = new SystemInfoFileProvider();
    @NotNull
    private static final String name = "System Info";

    private SystemInfoFileProvider() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public List<FileInfo> getFiles(@Nullable Project project) {
        String string = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogPath(...)");
        Path dir = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(string);
        Path path = dir.resolve("SystemInfo.log");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        String string2 = SubmitBugReportAction.getDescription(project);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
        Intrinsics.checkNotNull((Object)path);
        Path path2 = Paths.get("SystemInfo.log", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return CollectionsKt.listOf((Object)new FileInfo(path, path2));
    }
}

