/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J8\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J(\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\nH\u0016J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010-\u001a\u00020\nH\u0016J \u0010.\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nH\u0016J \u00100\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nH\u0016J\u0018\u00101\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\nH\u0016J\u0018\u00103\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u00104\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\nH\u0016J \u00105\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0016J(\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020:H\u0016J_\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\n2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0A2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0AH\u0016\u00a2\u0006\u0002\u0010GJ(\u0010H\u001a\u00020\u00052\u0006\u00107\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u001dH\u0016J(\u0010K\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\nH\u0016J\f\u0010O\u001a\u00020\u0004*\u00020\u001dH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/DebugVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "printer", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "visitStringInUTF8", "id", "", "s", "visitLoadClass", "classSerialNumber", "classObjectId", "stackSerialNumber", "classNameStringId", "visitStackFrame", "stackFrameId", "methodNameStringId", "methodSignatureStringId", "sourceFilenameStringId", "lineNumber", "", "visitStackTrace", "stackTraceSerialNumber", "threadSerialNumber", "numberOfFrames", "stackFrameIds", "", "visitAllocSites", "visitHeapSummary", "totalLiveBytes", "totalLiveInstances", "totalBytesAllocated", "totalInstancesAllocated", "visitStartThread", "visitEndThread", "visitHeapDump", "visitHeapDumpEnd", "visitCPUSamples", "visitControlSettings", "visitRootUnknown", "objectId", "visitRootGlobalJNI", "jniGlobalRefId", "visitRootLocalJNI", "frameNumber", "visitRootJavaFrame", "visitRootNativeStack", "visitRootStickyClass", "visitRootThreadBlock", "visitRootMonitorUsed", "visitRootThreadObject", "visitPrimitiveArrayDump", "arrayObjectId", "numberOfElements", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "visitClassDump", "classId", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "visitObjectArrayDump", "arrayClassObjectId", "objects", "visitInstanceDump", "bytes", "Ljava/nio/ByteBuffer;", "visitUnloadClass", "arrayToString", "intellij.android.core"})
public final class DebugVisitor
extends HProfVisitor {
    @NotNull
    private final Function1<String, Unit> printer;

    public DebugVisitor(@NotNull Function1<? super String, Unit> printer) {
        Intrinsics.checkNotNullParameter(printer, (String)"printer");
        this.printer = printer;
    }

    @Override
    public void visitStringInUTF8(long id2, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.printer.invoke((Object)("StringInUTF8: id=" + id2 + " value=" + s));
    }

    @Override
    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        this.printer.invoke((Object)("LoadClass: classSerialNumber=" + classSerialNumber + ", classObjectId=" + classObjectId + ", stackSerialNumber=" + stackSerialNumber + ", classNameStringId=" + classNameStringId));
    }

    @Override
    public void visitStackFrame(long stackFrameId, long methodNameStringId, long methodSignatureStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        this.printer.invoke((Object)("StackFrame: stackFrameId=" + stackFrameId + ", methodNameStringId=" + methodNameStringId + ", methodSignatureStringId=" + methodSignatureStringId + ", sourceFilenameStringId=" + sourceFilenameStringId + ", classSerialNumber=" + classSerialNumber + ", lineNumber=" + lineNumber));
    }

    @Override
    public void visitStackTrace(long stackTraceSerialNumber, long threadSerialNumber, int numberOfFrames, @NotNull long[] stackFrameIds) {
        Intrinsics.checkNotNullParameter((Object)stackFrameIds, (String)"stackFrameIds");
        this.printer.invoke((Object)("StackTrace: stackTraceSerialNumber: " + stackTraceSerialNumber + ", threadSerialNumber: " + threadSerialNumber + ", numberOfFrames: " + numberOfFrames + ", stackFrameIds: " + this.arrayToString(stackFrameIds)));
    }

    @Override
    public void visitAllocSites() {
        this.printer.invoke((Object)"AllocSites");
    }

    @Override
    public void visitHeapSummary(long totalLiveBytes, long totalLiveInstances, long totalBytesAllocated, long totalInstancesAllocated) {
        this.printer.invoke((Object)("HeapSummary: totalLiveBytes: " + totalLiveBytes + ", totalLiveInstances: " + totalLiveInstances + ", totalBytesAllocated: " + totalBytesAllocated + ", totalInstancesAllocated: " + totalInstancesAllocated));
    }

    @Override
    public void visitStartThread() {
        this.printer.invoke((Object)"StartThread");
    }

    @Override
    public void visitEndThread(long threadSerialNumber) {
        this.printer.invoke((Object)"EndThread");
    }

    @Override
    public void visitHeapDump() {
        this.printer.invoke((Object)"HeapDump");
    }

    @Override
    public void visitHeapDumpEnd() {
        this.printer.invoke((Object)"HeapDumpEnd");
    }

    @Override
    public void visitCPUSamples() {
        this.printer.invoke((Object)"CPUSamples");
    }

    @Override
    public void visitControlSettings() {
        this.printer.invoke((Object)"ControlSettings");
    }

    @Override
    public void visitRootUnknown(long objectId) {
        this.printer.invoke((Object)("RootUnknown: objectId=" + objectId));
    }

    @Override
    public void visitRootGlobalJNI(long objectId, long jniGlobalRefId) {
        this.printer.invoke((Object)("RootGlobalJNI: objectId=" + objectId + ", jniGlobalRefId=" + jniGlobalRefId));
    }

    @Override
    public void visitRootLocalJNI(long objectId, long threadSerialNumber, long frameNumber) {
        this.printer.invoke((Object)("RootLocalJNI: objectId=" + objectId + ", threadSerialNumber=" + threadSerialNumber + ", frameNumber=" + frameNumber));
    }

    @Override
    public void visitRootJavaFrame(long objectId, long threadSerialNumber, long frameNumber) {
        this.printer.invoke((Object)("RootJavaFrame: objectId=" + objectId + ", threadSerialNumber=" + threadSerialNumber + ", frameNumber=" + frameNumber));
    }

    @Override
    public void visitRootNativeStack(long objectId, long threadSerialNumber) {
        this.printer.invoke((Object)("RootNativeStack: objectId=" + objectId + ", threadSerialNumber=" + threadSerialNumber));
    }

    @Override
    public void visitRootStickyClass(long objectId) {
        this.printer.invoke((Object)("RootStickyClass: objectId=" + objectId));
    }

    @Override
    public void visitRootThreadBlock(long objectId, long threadSerialNumber) {
        this.printer.invoke((Object)("RootThreadBlock: objectId=" + objectId + ", threadSerialNumber=" + threadSerialNumber));
    }

    @Override
    public void visitRootMonitorUsed(long objectId) {
        this.printer.invoke((Object)("RootMonitorUsed: objectId=" + objectId));
    }

    @Override
    public void visitRootThreadObject(long objectId, long threadSerialNumber, long stackTraceSerialNumber) {
        this.printer.invoke((Object)("RootThreadObject: objectId=" + objectId + ", threadSerialNumber=" + threadSerialNumber + ", stackTraceSerialNumber=" + stackTraceSerialNumber));
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        Intrinsics.checkNotNullParameter((Object)((Object)elementType), (String)"elementType");
        this.printer.invoke((Object)("PrimitiveArrayDump: arrayObjectId=" + arrayObjectId + ", stackTraceSerialNumber=" + stackTraceSerialNumber + ", numberOfElements=" + numberOfElements + ", elementType=" + elementType.name()));
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        this.printer.invoke((Object)("ClassDump: classId=" + classId + ", stackTraceSerialNumber=" + stackTraceSerialNumber + ", superClassId=" + superClassId + ", classloaderClassId=" + classloaderClassId + ", instanceSize=" + instanceSize));
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.printer.invoke((Object)("ObjectArrayDump: arrayObjectId=" + arrayObjectId + ", stackTraceSerialNumber=" + stackTraceSerialNumber + ", arrayClassObjectId=" + arrayClassObjectId + ", objects=id[" + objects.length));
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        this.printer.invoke((Object)("InstanceDump: objectId=" + objectId + ", stackTraceSerialNumber: " + stackTraceSerialNumber + ", classObjectId=" + classObjectId + ",bytes=byte[" + bytes2.limit() + "]"));
    }

    @Override
    public void visitUnloadClass(long classSerialNumber) {
        this.printer.invoke((Object)("UnloadClass: classSerialNumber=" + classSerialNumber));
    }

    private final String arrayToString(long[] $this$arrayToString) {
        StringBuilder stringBuilder;
        StringBuilder $this$arrayToString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$arrayToString_u24lambda_u240.append('[');
        int n = $this$arrayToString.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                $this$arrayToString_u24lambda_u240.append(", ");
            }
            $this$arrayToString_u24lambda_u240.append($this$arrayToString[i]);
        }
        $this$arrayToString_u24lambda_u240.append(']');
        return stringBuilder.toString();
    }
}

