/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.AbstractHProfNavigatorReadBuffer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.CurrentJavaVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import jdk.internal.ref.Cleaner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u001bH\u0016J\b\u0010\u0017\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/HProfReadBufferSlidingWindow;", "Lcom/android/tools/idea/diagnostics/hprof/util/AbstractHProfNavigatorReadBuffer;", "channel", "Ljava/nio/channels/FileChannel;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "<init>", "(Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;)V", "bufferSize", "", "size", "buffer", "Ljava/nio/ByteBuffer;", "bufferOffset", "close", "", "invokeCleaner", "byteBuffer", "position", "newPosition", "remapBuffer", "isEof", "", "get", "bytes", "", "getByteBuffer", "", "", "getShort", "", "getInt", "getLong", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nHProfReadBufferSlidingWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProfReadBufferSlidingWindow.kt\ncom/android/tools/idea/diagnostics/hprof/util/HProfReadBufferSlidingWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class HProfReadBufferSlidingWindow
extends AbstractHProfNavigatorReadBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileChannel channel;
    private final long bufferSize;
    private final long size;
    @NotNull
    private ByteBuffer buffer;
    private long bufferOffset;
    @NotNull
    private static final Logger LOG;

    public HProfReadBufferSlidingWindow(@NotNull FileChannel channel, @NotNull HProfEventBasedParser parser) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(parser);
        this.channel = channel;
        this.bufferSize = 10000000L;
        this.size = this.channel.size();
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferOffset, Math.min(this.bufferSize, this.size));
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
        this.buffer = mappedByteBuffer;
    }

    @Override
    public void close() {
        this.invokeCleaner(this.buffer);
    }

    private final void invokeCleaner(ByteBuffer byteBuffer) {
        block7: {
            try {
                if (CurrentJavaVersion.currentJavaVersion().feature >= 9) {
                    Field theUnsafeField;
                    Object object;
                    Method invokeCleanerMethod;
                    Class<Unsafe> unsafeClass;
                    block6: {
                        unsafeClass = Unsafe.class;
                        Class[] classArray = new Class[]{ByteBuffer.class};
                        invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", classArray);
                        Field[] fieldArray = unsafeClass.getDeclaredFields();
                        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                        for (Object objectArray2 : (Object[])fieldArray) {
                            Field f = (Field)objectArray2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)f.getName(), (Object)"theUnsafe")) continue;
                            object = objectArray2;
                            break block6;
                        }
                        object = null;
                    }
                    Field field2 = theUnsafeField = (Field)object;
                    if (field2 != null) {
                        Field it = field2;
                        boolean bl = false;
                        it.setAccessible(true);
                        Object object2 = it.get(unsafeClass);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
                        Unsafe unsafe = (Unsafe)object2;
                        Object[] objectArray = new Object[]{byteBuffer};
                        invokeCleanerMethod.invoke((Object)unsafe, objectArray);
                    }
                    break block7;
                }
                Object object = byteBuffer instanceof DirectBuffer ? (DirectBuffer)((Object)byteBuffer) : null;
                if (object != null && (object = object.cleaner()) != null) {
                    ((Cleaner)object).clean();
                }
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    @Override
    public void position(long newPosition) {
        if (newPosition >= this.bufferOffset && newPosition <= this.bufferOffset + this.bufferSize) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
        } else {
            this.remapBuffer(newPosition);
        }
    }

    private final void remapBuffer(long newPosition) {
        ByteBuffer oldBuffer = this.buffer;
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, newPosition, Math.min(this.bufferSize, this.size - newPosition));
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
        this.buffer = mappedByteBuffer;
        this.bufferOffset = newPosition;
        this.invokeCleaner(oldBuffer);
    }

    @Override
    public boolean isEof() {
        return this.position() == this.size;
    }

    @Override
    public long position() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    @Override
    public void get(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        if (bytes2.length <= this.buffer.remaining()) {
            this.buffer.get(bytes2);
        } else {
            int remaining = bytes2.length;
            int offset = 0;
            while (remaining > 0) {
                this.remapBuffer(this.position());
                int bytesToFetch = Math.min(remaining, (int)this.bufferSize);
                this.buffer.get(bytes2, offset, bytesToFetch);
                remaining -= bytesToFetch;
                offset += bytesToFetch;
            }
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(int size) {
        boolean useSlice = false;
        if (size < this.buffer.remaining()) {
            useSlice = true;
        } else if ((long)size < this.bufferSize) {
            this.remapBuffer(this.position());
            useSlice = true;
        }
        if (useSlice) {
            ByteBuffer slicedBuffer = this.buffer.slice();
            slicedBuffer.limit(size);
            this.skip(size);
            ByteBuffer byteBuffer = slicedBuffer.asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
            return byteBuffer;
        }
        byte[] bytes2 = new byte[size];
        this.get(bytes2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes2);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    @Override
    public byte get() {
        if (this.buffer.remaining() < 1) {
            this.remapBuffer(this.position());
        }
        return this.buffer.get();
    }

    @Override
    public short getShort() {
        if (this.buffer.remaining() < 2) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getShort();
    }

    @Override
    public int getInt() {
        if (this.buffer.remaining() < 4) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getInt();
    }

    @Override
    public long getLong() {
        if (this.buffer.remaining() < 8) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getLong();
    }

    static {
        Logger logger = Logger.getInstance(HProfReadBufferSlidingWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/HProfReadBufferSlidingWindow$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

