/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/FileBackedHashMap;", "", "buffer", "Ljava/nio/ByteBuffer;", "keySize", "", "valueSize", "<init>", "(Ljava/nio/ByteBuffer;II)V", "bucketCount", "bucketSize", "filledBuckets", "get", "key", "", "readKey", "getBucketIndex", "put", "containsKey", "", "Companion", "intellij.android.core"})
public final class FileBackedHashMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    private final int keySize;
    private final int valueSize;
    private final int bucketCount;
    private final int bucketSize;
    private int filledBuckets;
    private static final double FILL_RATIO = 1.33;

    public FileBackedHashMap(@NotNull ByteBuffer buffer, int keySize, int valueSize) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.bucketSize = this.keySize + this.valueSize;
        int fileSize = this.buffer.remaining();
        boolean bl2 = bl = fileSize % this.bucketSize == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.bucketCount = fileSize / this.bucketSize;
    }

    @Nullable
    public final ByteBuffer get(long key) {
        if (key == 0L) {
            return null;
        }
        int hashcode = this.getBucketIndex(key);
        this.buffer.position(hashcode * this.bucketSize);
        for (int inspectedBuckets = 0; inspectedBuckets < this.bucketCount; ++inspectedBuckets) {
            long inspectedKey = this.readKey();
            if (inspectedKey == key) {
                return this.buffer;
            }
            if (inspectedKey == 0L) {
                return null;
            }
            ByteBuffer byteBuffer = this.buffer.remaining() <= this.valueSize ? this.buffer.position(0) : this.buffer.position(this.buffer.position() + this.valueSize);
        }
        return null;
    }

    private final long readKey() {
        return this.keySize == 8 ? this.buffer.getLong() : (long)this.buffer.getInt();
    }

    private final int getBucketIndex(long key) {
        return (Long.hashCode(key) & Integer.MAX_VALUE) % this.bucketCount;
    }

    @NotNull
    public final ByteBuffer put(long key) {
        this.buffer.position(this.getBucketIndex(key) * this.bucketSize);
        for (int inspectedBuckets = 0; inspectedBuckets < this.bucketCount; ++inspectedBuckets) {
            long inspectedKey = this.readKey();
            if (inspectedKey == key || inspectedKey == 0L) {
                ByteBuffer byteBuffer = this.keySize == 4 ? this.buffer.putInt(this.buffer.position() - this.keySize, (int)key) : this.buffer.putLong(this.buffer.position() - this.keySize, key);
                if (inspectedKey == 0L) {
                    int n = this.filledBuckets;
                    this.filledBuckets = n + 1;
                }
                return this.buffer;
            }
            ByteBuffer byteBuffer = this.buffer.remaining() <= this.valueSize ? this.buffer.position(0) : this.buffer.position(this.buffer.position() + this.valueSize);
        }
        throw new RuntimeException("HashMap is full.");
    }

    public final boolean containsKey(long key) {
        if (key == 0L) {
            return true;
        }
        return this.get(key) != null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/FileBackedHashMap$Companion;", "", "<init>", "()V", "FILL_RATIO", "", "getFileSize", "", "size", "keySize", "", "valueSize", "isSupported", "", "createEmpty", "Lcom/android/tools/idea/diagnostics/hprof/util/FileBackedHashMap;", "channel", "Ljava/nio/channels/FileChannel;", "createEmptyFile", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final long getFileSize(long size, int keySize, int valueSize) {
            return (long)((double)size * 1.33) * (long)(keySize + valueSize);
        }

        public final boolean isSupported(long size, int keySize, int valueSize) {
            return this.getFileSize(size, keySize, valueSize) < Integer.MAX_VALUE;
        }

        @NotNull
        public final FileBackedHashMap createEmpty(@NotNull FileChannel channel, long size, int keySize, int valueSize) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            if (keySize != 4 && keySize != 8) {
                throw new IllegalArgumentException("keySize must be 4 or 8.");
            }
            if (valueSize < 0) {
                throw new IllegalArgumentException("valueSize must be positive.");
            }
            if (!this.isSupported(size, keySize, valueSize)) {
                throw new IllegalArgumentException("Size too large");
            }
            long fileSize = this.getFileSize(size, keySize, valueSize);
            boolean bl2 = bl = fileSize <= Integer.MAX_VALUE;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.createEmptyFile(channel, fileSize);
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, channel.size());
            Intrinsics.checkNotNull((Object)buffer);
            return new FileBackedHashMap(buffer, keySize, valueSize);
        }

        public final void createEmptyFile(@NotNull FileChannel channel, long size) {
            long toWrite;
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            int bufferSize = 60000;
            ByteBuffer emptyBuf = ByteBuffer.allocateDirect(bufferSize);
            for (long remaining = size; remaining > 0L; remaining -= toWrite) {
                boolean bl;
                Comparable comparable;
                toWrite = Math.min((long)emptyBuf.remaining(), remaining);
                if (toWrite == (long)emptyBuf.remaining()) {
                    channel.write(emptyBuf);
                    comparable = emptyBuf.rewind();
                    continue;
                }
                boolean bl2 = bl = toWrite <= (long)bufferSize;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                emptyBuf.limit((int)toWrite);
                comparable = Integer.valueOf(channel.write(emptyBuf));
            }
            channel.position(0L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

