/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.navigator;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "", "description", "", "javaFrame", "", "<init>", "(Ljava/lang/String;Z)V", "getDescription", "()Ljava/lang/String;", "getJavaFrame", "()Z", "Companion", "intellij.android.core"})
public final class RootReason {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    private final boolean javaFrame;
    @NotNull
    private static final RootReason rootUnknown = new RootReason("Unknown", false, 2, null);
    @NotNull
    private static final RootReason rootGlobalJNI = new RootReason("Global JNI", false, 2, null);
    @NotNull
    private static final RootReason rootLocalJNI = new RootReason("Local JNI", false, 2, null);
    @NotNull
    private static final RootReason rootNativeStack = new RootReason("Native stack", false, 2, null);
    @NotNull
    private static final RootReason rootStickyClass = new RootReason("Sticky class", false, 2, null);
    @NotNull
    private static final RootReason rootThreadBlock = new RootReason("Thread block", false, 2, null);
    @NotNull
    private static final RootReason rootThreadObject = new RootReason("Thread object", false, 2, null);
    @NotNull
    private static final RootReason rootMonitorUsed = new RootReason("Monitor used", false, 2, null);

    private RootReason(String description2, boolean javaFrame) {
        this.description = description2;
        this.javaFrame = javaFrame;
    }

    /* synthetic */ RootReason(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final boolean getJavaFrame() {
        return this.javaFrame;
    }

    public /* synthetic */ RootReason(String description2, boolean javaFrame, DefaultConstructorMarker $constructor_marker) {
        this(description2, javaFrame);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason$Companion;", "", "<init>", "()V", "createConstantReferenceReason", "Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "constantNumber", "", "createStaticFieldReferenceReason", "staticFieldName", "", "createClassDefinitionReason", "createJavaFrameReason", "frameDescription", "rootUnknown", "getRootUnknown", "()Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "rootGlobalJNI", "getRootGlobalJNI", "rootLocalJNI", "getRootLocalJNI", "rootNativeStack", "getRootNativeStack", "rootStickyClass", "getRootStickyClass", "rootThreadBlock", "getRootThreadBlock", "rootThreadObject", "getRootThreadObject", "rootMonitorUsed", "getRootMonitorUsed", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RootReason createConstantReferenceReason(@NotNull ClassDefinition classDefinition, int constantNumber) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            return new RootReason("Class constant: " + classDefinition.getName() + ".#" + constantNumber, false, 2, null);
        }

        @NotNull
        public final RootReason createStaticFieldReferenceReason(@NotNull ClassDefinition classDefinition, @NotNull String staticFieldName) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            Intrinsics.checkNotNullParameter((Object)staticFieldName, (String)"staticFieldName");
            return new RootReason("Static field: " + classDefinition.getName() + "." + staticFieldName, false, 2, null);
        }

        @NotNull
        public final RootReason createClassDefinitionReason(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            return new RootReason("Class definition: " + classDefinition.getName(), false, 2, null);
        }

        @NotNull
        public final RootReason createJavaFrameReason(@NotNull String frameDescription) {
            Intrinsics.checkNotNullParameter((Object)frameDescription, (String)"frameDescription");
            return new RootReason("Java Frame: " + frameDescription, true, null);
        }

        @NotNull
        public final RootReason getRootUnknown() {
            return rootUnknown;
        }

        @NotNull
        public final RootReason getRootGlobalJNI() {
            return rootGlobalJNI;
        }

        @NotNull
        public final RootReason getRootLocalJNI() {
            return rootLocalJNI;
        }

        @NotNull
        public final RootReason getRootNativeStack() {
            return rootNativeStack;
        }

        @NotNull
        public final RootReason getRootStickyClass() {
            return rootStickyClass;
        }

        @NotNull
        public final RootReason getRootThreadBlock() {
            return rootThreadBlock;
        }

        @NotNull
        public final RootReason getRootThreadObject() {
            return rootThreadObject;
        }

        @NotNull
        public final RootReason getRootMonitorUsed() {
            return rootMonitorUsed;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

