/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.histogram;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.visitors.HistogramVisitor;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "", "entries", "", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "instanceCount", "", "<init>", "(Ljava/util/List;J)V", "getEntries", "()Ljava/util/List;", "getInstanceCount", "()J", "getTotals", "Lkotlin/Pair;", "bytesCount", "getBytesCount", "prepareReport", "", "name", "topClassCount", "", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Histogram.kt\ncom/android/tools/idea/diagnostics/hprof/histogram/Histogram\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1869#2,2:149\n1869#2,2:151\n1068#2:153\n*S KotlinDebug\n*F\n+ 1 Histogram.kt\ncom/android/tools/idea/diagnostics/hprof/histogram/Histogram\n*L\n33#1:149,2\n48#1:151,2\n56#1:153\n*E\n"})
public final class Histogram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<HistogramEntry> entries;
    private final long instanceCount;
    private final long bytesCount;

    public Histogram(@NotNull List<HistogramEntry> entries2, long instanceCount) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.entries = entries2;
        this.instanceCount = instanceCount;
        this.bytesCount = ((Number)this.getTotals().getSecond()).longValue();
    }

    @NotNull
    public final List<HistogramEntry> getEntries() {
        return this.entries;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    private final Pair<Long, Long> getTotals() {
        long totalInstances = 0L;
        long totalBytes = 0L;
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistogramEntry it = (HistogramEntry)element$iv;
            boolean bl = false;
            totalBytes += it.getTotalBytes();
            totalInstances += it.getTotalInstances();
        }
        return new Pair((Object)totalInstances, (Object)totalBytes);
    }

    public final long getBytesCount() {
        return this.bytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String prepareReport(@NotNull String name2, int topClassCount) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        StringBuilder $this$prepareReport_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$prepareReport_u24lambda_u240.append("Histogram. Top " + topClassCount + " by instance count:").append('\n');
        Function1 appendToResult = arg_0 -> Histogram.prepareReport$lambda$0$0($this$prepareReport_u24lambda_u240, arg_0);
        int counter = 0;
        counter = 1;
        Closeable closeable = new TruncatingPrintBuffer(topClassCount, 0, (Function1<? super String, ? extends Object>)appendToResult);
        Throwable throwable = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry entry = (HistogramEntry)element$iv;
                boolean bl3 = false;
                buffer.println(Histogram.Companion.formatEntryLine(counter, entry));
                ++counter;
            }
            buffer = Unit.INSTANCE;
        }
        catch (Throwable bl2) {
            throwable = bl2;
            throw bl2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        $this$prepareReport_u24lambda_u240.append(Histogram.Companion.getSummaryLine(this, name2)).append('\n');
        $this$prepareReport_u24lambda_u240.append('\n');
        $this$prepareReport_u24lambda_u240.append("Top 10 by bytes count:").append('\n');
        Iterable $this$sortedByDescending$iv = this.entries;
        boolean $i$f$sortedByDescending = false;
        List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
            }
        });
        int n = Math.min(10, this.entries.size());
        for (int i = 0; i < n; ++i) {
            HistogramEntry entry = (HistogramEntry)entriesByBytes.get(i);
            $this$prepareReport_u24lambda_u240.append(Histogram.Companion.formatEntryLine(i + 1, entry)).append('\n');
        }
        return stringBuilder.toString();
    }

    private static final Unit prepareReport$lambda$0$0(StringBuilder $this_buildString, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $this_buildString.append(s).append('\n');
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\"\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "prepareMergedHistogramReport", "", "mainHistogram", "mainHistogramName", "secondaryHistogram", "secondaryHistogramName", "options", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$HistogramOptions;", "getSummaryLine", "histogram", "histogramName", "formatEntryLineMerged", "counter", "", "entry", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "entry2", "formatEntryLine", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Histogram.kt\ncom/android/tools/idea/diagnostics/hprof/histogram/Histogram$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1869#2,2:149\n1869#2,2:151\n1068#2:153\n*S KotlinDebug\n*F\n+ 1 Histogram.kt\ncom/android/tools/idea/diagnostics/hprof/histogram/Histogram$Companion\n*L\n74#1:149,2\n86#1:151,2\n102#1:153\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Histogram create(@NotNull HProfEventBasedParser parser, @NotNull ClassStore classStore) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
            HistogramVisitor histogramVisitor = new HistogramVisitor(classStore);
            parser.accept(histogramVisitor, "histogram");
            return histogramVisitor.createHistogram();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String prepareMergedHistogramReport(@NotNull Histogram mainHistogram, @NotNull String mainHistogramName, @NotNull Histogram secondaryHistogram, @NotNull String secondaryHistogramName, @NotNull AnalysisConfig.HistogramOptions options) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)mainHistogram, (String)"mainHistogram");
            Intrinsics.checkNotNullParameter((Object)mainHistogramName, (String)"mainHistogramName");
            Intrinsics.checkNotNullParameter((Object)secondaryHistogram, (String)"secondaryHistogram");
            Intrinsics.checkNotNullParameter((Object)secondaryHistogramName, (String)"secondaryHistogramName");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            StringBuilder $this$prepareMergedHistogramReport_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            HashMap mapClassNameToEntrySecondary = new HashMap();
            Iterable $this$forEach$iv = secondaryHistogram.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry it = (HistogramEntry)element$iv;
                boolean bl2 = false;
                ((Map)mapClassNameToEntrySecondary).put(it.getClassDefinition().getName(), it);
            }
            String summary = Companion.getSummaryLine(mainHistogram, mainHistogramName) + "\n" + Companion.getSummaryLine(secondaryHistogram, secondaryHistogramName);
            if (options.getIncludeByCount()) {
                Object element$iv;
                $this$prepareMergedHistogramReport_u24lambda_u240.append("Histogram. Top " + options.getClassByCountLimit() + " by instance count [All-objects] [Only-strong-ref]:").append('\n');
                int counter = 0;
                counter = 1;
                Closeable closeable = new TruncatingPrintBuffer(options.getClassByCountLimit(), 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareMergedHistogramReport_u24lambda_u240){

                    public final StringBuilder invoke(String p0) {
                        return ((StringBuilder)this.receiver).append(p0).append('\n');
                    }
                }));
                element$iv = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv2 = mainHistogram.getEntries();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        HistogramEntry entry = (HistogramEntry)element$iv2;
                        boolean bl4 = false;
                        HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                        buffer.println(Companion.formatEntryLineMerged(counter, entry, entry2));
                        ++counter;
                    }
                    buffer = Unit.INSTANCE;
                }
                catch (Throwable bl3) {
                    element$iv = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, element$iv);
                }
                $this$prepareMergedHistogramReport_u24lambda_u240.append(summary).append('\n');
            }
            if (options.getIncludeBySize() && options.getIncludeByCount()) {
                $this$prepareMergedHistogramReport_u24lambda_u240.append('\n');
            }
            if (options.getIncludeBySize()) {
                int classCountInByBytesSection = Math.min(mainHistogram.getEntries().size(), options.getClassBySizeLimit());
                $this$prepareMergedHistogramReport_u24lambda_u240.append("Top " + classCountInByBytesSection + " by size:").append('\n');
                Iterable $this$sortedByDescending$iv = mainHistogram.getEntries();
                boolean $i$f$sortedByDescending = false;
                List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistogramEntry it = (HistogramEntry)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTotalBytes());
                        it = (HistogramEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
                    }
                });
                for (int i = 0; i < classCountInByBytesSection; ++i) {
                    HistogramEntry entry = (HistogramEntry)entriesByBytes.get(i);
                    HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                    $this$prepareMergedHistogramReport_u24lambda_u240.append(Companion.formatEntryLineMerged(i + 1, entry, entry2)).append('\n');
                }
                if (!options.getIncludeByCount()) {
                    $this$prepareMergedHistogramReport_u24lambda_u240.append(summary).append('\n');
                }
            }
            return stringBuilder.toString();
        }

        private final String getSummaryLine(Histogram histogram, String histogramName) {
            Pair pair = histogram.getTotals();
            long totalInstances = ((Number)pair.component1()).longValue();
            long totalBytes = ((Number)pair.component2()).longValue();
            Locale locale = Locale.getDefault();
            String string = "Total - %10s: %s %s %d classes (Total instances: %d)";
            Object[] objectArray = new Object[]{histogramName, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(totalInstances), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(totalBytes), histogram.getEntries().size(), histogram.getInstanceCount()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private final String formatEntryLineMerged(int counter, HistogramEntry entry, HistogramEntry entry2) {
            Locale locale = Locale.getDefault();
            String string = "%5d: [%s/%s] [%s/%s] %s";
            Object[] objectArray = new Object[6];
            objectArray[0] = counter;
            objectArray[1] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances());
            objectArray[2] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes());
            HistogramEntry histogramEntry = entry2;
            objectArray[3] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(histogramEntry != null ? histogramEntry.getTotalInstances() : 0L);
            HistogramEntry histogramEntry2 = entry2;
            objectArray[4] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(histogramEntry2 != null ? histogramEntry2.getTotalBytes() : 0L);
            objectArray[5] = entry.getClassDefinition().getPrettyName();
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private final String formatEntryLine(int counter, HistogramEntry entry) {
            Locale locale = Locale.getDefault();
            String string = "%5d: [%s/%s] %s";
            Object[] objectArray = new Object[]{counter, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances()), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes()), entry.getClassDefinition().getPrettyName()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

