/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.GCRootPathsTree;
import com.android.tools.idea.diagnostics.hprof.analysis.RefIndexUtil;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree;", "", "sizeThreshold", "", "depthLimit", "", "<init>", "(JI)V", "getSizeThreshold", "()J", "getDepthLimit", "()I", "roots", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node;", "merge", "", "node", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "convertToSummary", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "edge", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "depth", "printTree", "context", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sizeAndCountString", "", "size", "count", "StackEntry", "Node", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSummaryTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,113:1\n1068#2:114\n1878#2,3:115\n382#3,7:118\n*S KotlinDebug\n*F\n+ 1 SummaryTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree\n*L\n47#1:114\n47#1:115,3\n30#1:118,7\n*E\n"})
public final class SummaryTree {
    private final long sizeThreshold;
    private final int depthLimit;
    @NotNull
    private final Int2ObjectOpenHashMap<Node> roots;

    public SummaryTree(long sizeThreshold, int depthLimit) {
        this.sizeThreshold = sizeThreshold;
        this.depthLimit = depthLimit;
        this.roots = new Int2ObjectOpenHashMap();
    }

    public final long getSizeThreshold() {
        return this.sizeThreshold;
    }

    public final int getDepthLimit() {
        return this.depthLimit;
    }

    public final void merge(@NotNull GCRootPathsTree.RootNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.getEdges().forEach((arg_0, arg_1) -> SummaryTree.merge$lambda$1((arg_0, arg_1) -> SummaryTree.merge$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
    }

    private final Node convertToSummary(GCRootPathsTree.RegularNode node, GCRootPathsTree.Edge edge, int depth) {
        Node n = new Node(edge, node.getTotalSizeInBytes(), node.getInstances().size());
        if (node.getEdges() == null || depth >= this.depthLimit) {
            return n;
        }
        HashMap<GCRootPathsTree.Edge, GCRootPathsTree.RegularNode> hashMap = node.getEdges();
        Intrinsics.checkNotNull(hashMap);
        for (Map.Entry e : ((Map)hashMap).entrySet()) {
            if (((GCRootPathsTree.RegularNode)e.getValue()).getTotalSizeInBytes() <= this.sizeThreshold) continue;
            Map map2 = n.getEdges();
            Object k = e.getKey();
            Object v = e.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            GCRootPathsTree.RegularNode regularNode = (GCRootPathsTree.RegularNode)v;
            Object k2 = e.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
            Node node2 = this.convertToSummary(regularNode, (GCRootPathsTree.Edge)k2, depth + 1);
            map2.put(k, node2);
        }
        return n;
    }

    public final void printTree(@NotNull AnalysisContext context, @NotNull StringBuilder out) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Iterable $this$sortedByDescending$iv = MapsKt.toList((Map)((Map)this.roots));
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(((Node)pair.getSecond()).getSubtreeSize());
                pair = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((Node)pair.getSecond()).getSubtreeSize()));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int i = n;
            boolean bl = false;
            Integer id2 = (Integer)pair.component1();
            Node node = (Node)pair.component2();
            out.append("Root " + (i + 1) + ":").append('\n');
            Object object = context.getNavigator().getRootReasonForObjectId(id2.intValue());
            if (object == null || (object = ((RootReason)object).getDescription()) == null) {
                object = "<Couldn't find root description>";
            }
            Object rootReason = object;
            out.append(this.sizeAndCountString(node.getSubtreeSize(), node.getInstanceCount()) + "   ROOT: " + (String)rootReason).append('\n');
            node.print(context, out);
        }
    }

    private final String sizeAndCountString(long size, int count) {
        String subgraphSizeString = StringsKt.padStart$default((String)HeapReportUtils.INSTANCE.toShortStringAsSize(size), (int)6, (char)'\u0000', (int)2, null);
        String instanceCountString = StringsKt.padStart$default((String)String.valueOf(count), (int)10, (char)'\u0000', (int)2, null);
        return subgraphSizeString + " " + instanceCountString;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit merge$lambda$0(SummaryTree this$0, Integer id2, Pair pair) {
        GCRootPathsTree.RegularNode oldNode = (GCRootPathsTree.RegularNode)pair.component1();
        GCRootPathsTree.Edge edge = (GCRootPathsTree.Edge)pair.component2();
        if (oldNode.getTotalSizeInBytes() >= this$0.sizeThreshold) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = (Map)this$0.roots;
            Integer key$iv = id2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Node answer$iv = this$0.new Node(edge, oldNode.getTotalSizeInBytes(), oldNode.getInstances().size());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Node)object).merge(oldNode, 0);
        }
        return Unit.INSTANCE;
    }

    private static final void merge$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u001a\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060#j\u0002`$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R5\u0010\u0014\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0000R\u00020\u00160\u0015j\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0000R\u00020\u0016`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node;", "", "incomingEdge", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "subtreeSize", "", "instanceCount", "", "<init>", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;JI)V", "getIncomingEdge", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getSubtreeSize", "()J", "setSubtreeSize", "(J)V", "getInstanceCount", "()I", "setInstanceCount", "(I)V", "edges", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree;", "Lkotlin/collections/HashMap;", "getEdges", "()Ljava/util/HashMap;", "merge", "", "node", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "depth", "print", "context", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nSummaryTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1056#2:114\n1878#2,3:115\n*S KotlinDebug\n*F\n+ 1 SummaryTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node\n*L\n102#1:114\n102#1:115,3\n*E\n"})
    public final class Node {
        @NotNull
        private final GCRootPathsTree.Edge incomingEdge;
        private long subtreeSize;
        private int instanceCount;
        @NotNull
        private final HashMap<GCRootPathsTree.Edge, Node> edges;

        public Node(GCRootPathsTree.Edge incomingEdge, long subtreeSize, int instanceCount) {
            Intrinsics.checkNotNullParameter((Object)incomingEdge, (String)"incomingEdge");
            this.incomingEdge = incomingEdge;
            this.subtreeSize = subtreeSize;
            this.instanceCount = instanceCount;
            this.edges = new HashMap();
        }

        @NotNull
        public final GCRootPathsTree.Edge getIncomingEdge() {
            return this.incomingEdge;
        }

        public final long getSubtreeSize() {
            return this.subtreeSize;
        }

        public final void setSubtreeSize(long l) {
            this.subtreeSize = l;
        }

        public final int getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(int n) {
            this.instanceCount = n;
        }

        @NotNull
        public final HashMap<GCRootPathsTree.Edge, Node> getEdges() {
            return this.edges;
        }

        public final void merge(@NotNull GCRootPathsTree.RegularNode node, int depth) {
            List och;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getTotalSizeInBytes() < SummaryTree.this.getSizeThreshold()) {
                return;
            }
            this.subtreeSize = RangesKt.coerceAtLeast((long)this.subtreeSize, (long)node.getTotalSizeInBytes());
            this.instanceCount = RangesKt.coerceAtLeast((int)this.instanceCount, (int)node.getInstances().size());
            if (depth >= SummaryTree.this.getDepthLimit()) {
                return;
            }
            HashMap<GCRootPathsTree.Edge, GCRootPathsTree.RegularNode> hashMap = node.getEdges();
            List list2 = hashMap != null && (hashMap = hashMap.entrySet()) != null ? CollectionsKt.toMutableList((Collection)((Collection)((Object)hashMap))) : (och = null);
            if (och == null) {
                return;
            }
            block0: for (Map.Entry e : ((Map)this.edges).entrySet()) {
                for (Map.Entry oe : och) {
                    if (!Intrinsics.areEqual(e.getKey(), oe.getKey())) continue;
                    Node node2 = (Node)e.getValue();
                    Object v = oe.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    node2.merge((GCRootPathsTree.RegularNode)v, depth + 1);
                    och.remove(oe);
                    continue block0;
                }
            }
            for (Map.Entry oe : och) {
                if (((GCRootPathsTree.RegularNode)oe.getValue()).getTotalSizeInBytes() <= SummaryTree.this.getSizeThreshold()) continue;
                Map map2 = this.edges;
                Object k = oe.getKey();
                Object v = oe.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                GCRootPathsTree.RegularNode regularNode = (GCRootPathsTree.RegularNode)v;
                Object k2 = oe.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
                Node node3 = SummaryTree.this.convertToSummary(regularNode, (GCRootPathsTree.Edge)k2, depth + 1);
                map2.put(k, node3);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void print(@NotNull AnalysisContext context, @NotNull StringBuilder out) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
            stack.add(new StackEntry(this, null, "", ""));
            while (!((Collection)stack).isEmpty()) {
                void $this$forEachIndexed$iv;
                StackEntry stackEntry = (StackEntry)stack.pop();
                Node node = stackEntry.component1();
                ClassDefinition parentClass = stackEntry.component2();
                String indent = stackEntry.component3();
                String nextIndent = stackEntry.component4();
                GCRootPathsTree.Edge edge = node.incomingEdge;
                String fieldNameString = RefIndexUtil.INSTANCE.getFieldDescription(Byte.toUnsignedInt(edge.getRefIndex()), parentClass, context.getClassStore());
                String text2 = edge.getClassDefinition().getPrettyName();
                String disposedString = edge.getDisposed() ? " (disposed)" : "";
                out.append(SummaryTree.this.sizeAndCountString(node.subtreeSize, node.instanceCount) + "   " + indent + fieldNameString + ": " + text2 + disposedString).append('\n');
                if (node.edges.size() == 1) {
                    Collection<Node> collection2 = node.edges.values();
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
                    Object object = CollectionsKt.first((Iterable)collection2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                    stack.push(new StackEntry((Node)object, edge.getClassDefinition(), nextIndent, nextIndent));
                    continue;
                }
                Set<Map.Entry<GCRootPathsTree.Edge, Node>> set2 = node.edges.entrySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
                Iterable $this$sortedBy$iv = set2;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry e = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(((Node)e.getValue()).getSubtreeSize());
                        e = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((Node)e.getValue()).getSubtreeSize()));
                    }
                });
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Map.Entry entry = (Map.Entry)item$iv;
                    int index = n;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    Object v = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                    Node childNode = (Node)v;
                    if (index == 0) {
                        stack.push(new StackEntry(childNode, edge.getClassDefinition(), nextIndent + "\\-", nextIndent + "  "));
                        continue;
                    }
                    stack.push(new StackEntry(childNode, edge.getClassDefinition(), nextIndent + "+-", nextIndent + "| "));
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\u0013\u001a\u00060\u0003R\u00020\u0004H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$StackEntry;", "", "node", "Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "indent", "", "nextIndent", "<init>", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;Ljava/lang/String;Ljava/lang/String;)V", "getNode", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/SummaryTree$Node;", "getClassDefinition", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    private static final class StackEntry {
        @NotNull
        private final Node node;
        @Nullable
        private final ClassDefinition classDefinition;
        @NotNull
        private final String indent;
        @NotNull
        private final String nextIndent;

        public StackEntry(@NotNull Node node, @Nullable ClassDefinition classDefinition, @NotNull String indent, @NotNull String nextIndent) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            Intrinsics.checkNotNullParameter((Object)nextIndent, (String)"nextIndent");
            this.node = node;
            this.classDefinition = classDefinition;
            this.indent = indent;
            this.nextIndent = nextIndent;
        }

        @NotNull
        public final Node getNode() {
            return this.node;
        }

        @Nullable
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        @NotNull
        public final String getIndent() {
            return this.indent;
        }

        @NotNull
        public final String getNextIndent() {
            return this.nextIndent;
        }

        @NotNull
        public final Node component1() {
            return this.node;
        }

        @Nullable
        public final ClassDefinition component2() {
            return this.classDefinition;
        }

        @NotNull
        public final String component3() {
            return this.indent;
        }

        @NotNull
        public final String component4() {
            return this.nextIndent;
        }

        @NotNull
        public final StackEntry copy(@NotNull Node node, @Nullable ClassDefinition classDefinition, @NotNull String indent, @NotNull String nextIndent) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            Intrinsics.checkNotNullParameter((Object)nextIndent, (String)"nextIndent");
            return new StackEntry(node, classDefinition, indent, nextIndent);
        }

        public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, Node node, ClassDefinition classDefinition, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                node = stackEntry.node;
            }
            if ((n & 2) != 0) {
                classDefinition = stackEntry.classDefinition;
            }
            if ((n & 4) != 0) {
                string = stackEntry.indent;
            }
            if ((n & 8) != 0) {
                string2 = stackEntry.nextIndent;
            }
            return stackEntry.copy(node, classDefinition, string, string2);
        }

        @NotNull
        public String toString() {
            return "StackEntry(node=" + this.node + ", classDefinition=" + this.classDefinition + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
        }

        public int hashCode() {
            int result2 = this.node.hashCode();
            result2 = result2 * 31 + (this.classDefinition == null ? 0 : this.classDefinition.hashCode());
            result2 = result2 * 31 + this.indent.hashCode();
            result2 = result2 * 31 + this.nextIndent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StackEntry)) {
                return false;
            }
            StackEntry stackEntry = (StackEntry)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)stackEntry.classDefinition)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent);
        }
    }
}

