/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.action;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.hprof.action.ShowReportDialog;
import com.android.tools.idea.diagnostics.hprof.action.SystemTempFilenameSupplier;
import com.android.tools.idea.diagnostics.hprof.analysis.HProfAnalysis;
import com.android.tools.idea.diagnostics.report.AnalyzedHeapReport;
import com.android.tools.idea.diagnostics.report.HeapReport;
import com.android.tools.idea.diagnostics.report.UnanalyzedHeapReport;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.HeapReportEvent;
import com.intellij.diagnostic.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable;", "Ljava/lang/Runnable;", "report", "Lcom/android/tools/idea/diagnostics/report/UnanalyzedHeapReport;", "deleteAfterAnalysis", "", "<init>", "(Lcom/android/tools/idea/diagnostics/report/UnanalyzedHeapReport;Z)V", "getReport", "()Lcom/android/tools/idea/diagnostics/report/UnanalyzedHeapReport;", "run", "", "Companion", "AnalysisTask", "ReviewReportAction", "intellij.android.core"})
public final class AnalysisRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnanalyzedHeapReport report;
    private final boolean deleteAfterAnalysis;
    @NotNull
    private static final Logger LOG;

    public AnalysisRunnable(@NotNull UnanalyzedHeapReport report, boolean deleteAfterAnalysis) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        this.report = report;
        this.deleteAfterAnalysis = deleteAfterAnalysis;
    }

    @NotNull
    public final UnanalyzedHeapReport getReport() {
        return this.report;
    }

    @Override
    public void run() {
        new AnalysisTask().queue();
    }

    static {
        Logger logger = Logger.getInstance(AnalysisRunnable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable$AnalysisTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "<init>", "(Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable;)V", "onThrowable", "", "error", "", "deleteHprofFileAsync", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.core"})
    public final class AnalysisTask
    extends Task.Backgroundable {
        public AnalysisTask() {
            super(null, AndroidBundle.message("heap.dump.analysis.task.title", new Object[0]), false);
        }

        public void onThrowable(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            LOG.error(error);
            Companion.updateNextCheckTimeIfNeeded(AnalysisRunnable.this.getReport());
            String string = AndroidBundle.message("heap.dump.analysis.exception", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, NotificationType.INFORMATION);
            notification.notify(null);
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.ERROR_DURING_ANALYSIS).build());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHeapReportEvent(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
        }

        private final void deleteHprofFileAsync() {
            CompletableFuture.runAsync(() -> AnalysisTask.deleteHprofFileAsync$lambda$0(AnalysisRunnable.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            Object channel;
            Object object;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.ANALYSIS_STARTED).build());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHeapReportEvent(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            indicator.setIndeterminate(false);
            indicator.setText("Analyze Heap");
            indicator.setFraction(0.0);
            Set openOptions = null;
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                object = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE};
                openOptions = SetsKt.setOf((Object[])object);
            } else {
                openOptions = SetsKt.setOf((Object)StandardOpenOption.READ);
            }
            Closeable closeable = FileChannel.open(AnalysisRunnable.this.getReport().getHprofPath(), openOptions, new FileAttribute[0]);
            Throwable throwable = null;
            try {
                channel = (FileChannel)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)channel);
                channel = new HProfAnalysis((FileChannel)channel, new SystemTempFilenameSupplier()).analyze(indicator);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = channel;
            String reportString = ((HProfAnalysis.AnalysisResult)object).component1();
            String summary = ((HProfAnalysis.AnalysisResult)object).component2();
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
            AnalyzedHeapReport analyzedReport = new AnalyzedHeapReport(reportString, summary, AnalysisRunnable.this.getReport().getHeapProperties(), AnalysisRunnable.this.getReport().getProperties());
            Path heapReportDir = Paths.get(PathManager.getLogPath(), new String[0]).resolve("heapReports");
            heapReportDir.toFile().mkdirs();
            String datetime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            Path heapReportFile = heapReportDir.resolve(Paths.get("heapReport" + datetime + ".txt", new String[0]));
            File file = heapReportFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.writeText$default((File)file, (String)reportString, null, (int)2, null);
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.ANALYSIS_FINISHED).build());
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setHeapReportEvent(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
            String string = AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = AndroidBundle.message("heap.dump.analysis.notification.ready.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, string2, NotificationType.INFORMATION);
            notification.setImportant(true);
            notification.addAction((AnAction)new ReviewReportAction(analyzedReport));
            notification.notify(null);
        }

        private static final void deleteHprofFileAsync$lambda$0(AnalysisRunnable this$0) {
            Files.deleteIfExists(this$0.getReport().getHprofPath());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "updateNextCheckTimeIfNeeded", "", "report", "Lcom/android/tools/idea/diagnostics/report/HeapReport;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateNextCheckTimeIfNeeded(HeapReport report) {
            if (!report.getHeapProperties().getReason().isUserInvoked()) {
                long nextCheckMs = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(7L);
                PropertiesComponent.getInstance().setValue("heap.dump.snapshot.next.check.timestamp", String.valueOf(nextCheckMs));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable$ReviewReportAction;", "Lcom/intellij/notification/NotificationAction;", "report", "Lcom/android/tools/idea/diagnostics/report/AnalyzedHeapReport;", "<init>", "(Lcom/android/tools/idea/diagnostics/report/AnalyzedHeapReport;)V", "reportShown", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "uploadReport", "intellij.android.core"})
    public static final class ReviewReportAction
    extends NotificationAction {
        @NotNull
        private final AnalyzedHeapReport report;
        private boolean reportShown;

        public ReviewReportAction(@NotNull AnalyzedHeapReport report) {
            Intrinsics.checkNotNullParameter((Object)report, (String)"report");
            super(AndroidBundle.message("heap.dump.analysis.notification.action.title", new Object[0]));
            this.report = report;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            if (this.reportShown) {
                return;
            }
            this.reportShown = true;
            UIUtil.invokeLaterIfNeeded(() -> ReviewReportAction.actionPerformed$lambda$0(notification, this));
        }

        private final void uploadReport() {
            StudioCrashReporter.getInstance().submit(this.report.asCrashReport(), true).whenCompleteAsync(ReviewReportAction::uploadReport$lambda$0, (Executor)PooledThreadExecutor.INSTANCE);
        }

        private static final void actionPerformed$lambda$0(Notification $notification, ReviewReportAction this$0) {
            $notification.expire();
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.REVIEW_DIALOG_SHOWN).build());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHeapReportEvent(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            ShowReportDialog reportDialog = new ShowReportDialog(this$0.report);
            boolean userAgreedToSendReport = reportDialog.showAndGet();
            Companion.updateNextCheckTimeIfNeeded(this$0.report);
            if (userAgreedToSendReport) {
                AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.REVIEW_ACCEPTED).build());
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setHeapReportEvent(...)");
                UsageTracker.log((AndroidStudioEvent.Builder)builder2);
                this$0.uploadReport();
                AndroidStudioEvent.Builder builder3 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.REPORT_UPLOADED).build());
                Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"setHeapReportEvent(...)");
                UsageTracker.log((AndroidStudioEvent.Builder)builder3);
            } else {
                AndroidStudioEvent.Builder builder4 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.REVIEW_DECLINED).build());
                Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"setHeapReportEvent(...)");
                UsageTracker.log((AndroidStudioEvent.Builder)builder4);
            }
        }

        private static final void uploadReport$lambda$0(String string, Throwable throwable) {
            if (throwable == null) {
                String string2 = AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String string3 = AndroidBundle.message("heap.dump.analysis.notification.submitted.content", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string2, string3, NotificationType.INFORMATION).setImportant(false).notify(null);
            } else {
                LOG.error(throwable);
                AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.HEAP_REPORT_EVENT).setHeapReportEvent(HeapReportEvent.newBuilder().setStatus(HeapReportEvent.Status.REPORT_UPLOAD_FAILED).build());
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHeapReportEvent(...)");
                UsageTracker.log((AndroidStudioEvent.Builder)builder);
                String string4 = AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                String string5 = AndroidBundle.message("heap.dump.analysis.notification.submit.error.content", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string4, string5, NotificationType.ERROR).setImportant(false).notify(null);
            }
        }
    }
}

