/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.ExceptionDataCollection;
import com.android.tools.idea.diagnostics.crash.UploadFields;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.extensions.PluginId;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioExceptionReport
extends BaseStudioReport {
    public static final String KEY_EXCEPTION_INFO = "exception_info";
    @NotNull
    private final String exceptionInfo;
    private final boolean userReported;
    @Nullable
    private final String fullStack;
    @NotNull
    private final Map<String, String> logs;
    @Nullable
    private final PluginId pluginId;

    private StudioExceptionReport(@Nullable String version2, @NotNull String exceptionInfo, boolean userReported, @Nullable String fullStack, @NotNull Map<String, String> logs, @Nullable PluginId pluginId, @Nullable Map<String, String> productData) {
        super(version2, productData, "Exception");
        this.exceptionInfo = exceptionInfo;
        this.userReported = userReported;
        this.fullStack = fullStack;
        this.logs = logs;
        this.pluginId = pluginId;
    }

    @Override
    protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        if (this.isKotlinOnStack()) {
            builder.addTextBody("kotlinVersion", this.getKotlinPluginVersionDescription());
        }
        try {
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)this.pluginId);
            if (plugin != null) {
                String name3 = plugin.getName();
                String version2 = plugin.getVersion();
                builder.addTextBody("plugin.name", name3);
                builder.addTextBody("plugin.version", version2);
            }
        }
        catch (Throwable ignored) {
            builder.addTextBody("plugin.name", "exceptionWhileReadingNameVersion");
        }
        builder.addTextBody("userReported", this.userReported ? "1" : "0");
        builder.addTextBody(KEY_EXCEPTION_INFO, this.exceptionInfo);
        if (this.fullStack != null) {
            builder.addTextBody("fullStack", this.fullStack);
        }
        this.logs.forEach((name2, logContent) -> {
            String filename = "log_" + name2;
            builder.addBinaryBody("log_" + name2, logContent.getBytes(StandardCharsets.UTF_8), ContentType.TEXT_PLAIN, filename + ".log");
        });
    }

    private boolean isKotlinOnStack() {
        return this.exceptionInfo.contains("\tat org.jetbrains.kotlin");
    }

    @VisibleForTesting
    @NotNull
    protected String getKotlinPluginVersionDescription() {
        try {
            IdeaPluginDescriptor[] pluginDescriptors = PluginManagerCore.getPlugins();
            return Arrays.stream(pluginDescriptors).filter(d -> d.getPluginId() != null && d.getPluginId().getIdString().equals("org.jetbrains.kotlin") && d.isEnabled()).findFirst().map(d -> d.getVersion()).orElse("pluginNotLoaded");
        }
        catch (Exception ignored) {
            return "exceptionWhenReadingVersion";
        }
    }

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable throwable) {
        int depth = 0;
        Throwable rootCause = throwable;
        while (depth++ != 1000 && rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    @NotNull
    public static String getDescription(@NotNull Throwable t) {
        return ExceptionDataCollection.getInstance().getDescription(t, true, false);
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioExceptionReport, Builder> {
        private String exceptionInfo;
        private boolean userReported;
        private PluginId pluginId;
        private Map<String, String> logs;
        private String fullStack;

        protected Builder getThis() {
            return this;
        }

        @NotNull
        public Builder setThrowable(@NotNull Throwable throwable, boolean userReported, boolean includeLogs) {
            Throwable cause = StudioExceptionReport.getRootCause(throwable);
            ExceptionDataCollection service = ExceptionDataCollection.getInstance();
            UploadFields uploadFields = service.getExceptionUploadFields(throwable, userReported, includeLogs);
            this.exceptionInfo = uploadFields.getDescription();
            this.userReported = userReported;
            this.logs = uploadFields.getLogs();
            this.pluginId = PluginUtil.getInstance().findPluginId(cause);
            return this;
        }

        public StudioExceptionReport build() {
            return new StudioExceptionReport(this.getVersion(), this.exceptionInfo, this.userReported, this.fullStack, this.logs, this.pluginId, this.getProductData());
        }
    }
}

