/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.commit;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.commit.GitMetricsStore;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CommitMetricsEvent;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J/\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker;", "", "trackedPath", "", "intervalMinutes", "", "<init>", "(Ljava/lang/String;J)V", "trackingJob", "Ljava/util/concurrent/ScheduledFuture;", "runProcessWithTimeout", "command", "", "startTracking", "", "stopTracking", "trackCommits", "doTrackCommits", "", "recordCommits", "commits", "Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitInfo;", "getUserGitInfo", "getNewCommits", "userName", "lastCommitTimestamp", "commitType", "Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;", "(Ljava/lang/String;Ljava/lang/Long;Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;)Ljava/util/List;", "Companion", "CommitType", "CommitInfo", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nGitCommitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitTracker.kt\ncom/android/tools/idea/diagnostics/commit/GitCommitTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1563#2:229\n1634#2,3:230\n1869#2,2:233\n1011#2,2:235\n*S KotlinDebug\n*F\n+ 1 GitCommitTracker.kt\ncom/android/tools/idea/diagnostics/commit/GitCommitTracker\n*L\n151#1:229\n151#1:230,3\n206#1:233,2\n214#1:235,2\n*E\n"})
public final class GitCommitTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String trackedPath;
    private final long intervalMinutes;
    @Nullable
    private ScheduledFuture<?> trackingJob;
    @NotNull
    private static final Logger LOG;
    private static final long INITIAL_DELAY_MINUTES = 1L;
    private static final long INTERVAL_IN_MINUTES = 30L;
    private static final long COMMAND_TIMEOUT_SECONDS = 5L;

    public GitCommitTracker(@NotNull String trackedPath, long intervalMinutes) {
        Intrinsics.checkNotNullParameter((Object)trackedPath, (String)"trackedPath");
        this.trackedPath = trackedPath;
        this.intervalMinutes = intervalMinutes;
    }

    public /* synthetic */ GitCommitTracker(String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 30L;
        }
        this(string, l);
    }

    private final String runProcessWithTimeout(List<String> command) {
        long timeoutSeconds = 5L;
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(new File(this.trackedPath));
        Process process2 = processBuilder.start();
        StringBuilder output = new StringBuilder();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> GitCommitTracker.runProcessWithTimeout$lambda$0(process2, output));
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"executeOnPooledThread(...)");
        Future outputReaderFuture = future2;
        boolean success = true;
        try {
            if (!process2.waitFor(timeoutSeconds, TimeUnit.SECONDS)) {
                LOG.warn("Process " + processBuilder.command().get(0) + " did not complete in allocated " + timeoutSeconds + "s");
                process2.destroy();
                success = false;
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("Process " + processBuilder.command().get(0) + " interrupted");
            success = false;
        }
        if (!success) {
            return null;
        }
        outputReaderFuture.get();
        if (process2.exitValue() != 0) {
            return null;
        }
        return output.toString();
    }

    public final void startTracking() {
        LOG.info("Started commit tracking in directory " + this.trackedPath);
        this.trackingJob = JobScheduler.getScheduler().scheduleWithFixedDelay(this::trackCommits, 1L, this.intervalMinutes, TimeUnit.MINUTES);
    }

    public final void stopTracking() {
        block0: {
            LOG.info("Stopped commit tracking in directory " + this.trackedPath);
            ScheduledFuture<?> scheduledFuture = this.trackingJob;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    public final void trackCommits() {
        boolean success = this.doTrackCommits();
        if (!success) {
            this.stopTracking();
        }
    }

    private final boolean doTrackCommits() {
        try {
            String string = this.getUserGitInfo();
            if (string == null) {
                return false;
            }
            String userName = string;
            GitMetricsStore commitTimestampStore = GitMetricsStore.Companion.getInstance();
            List<CommitInfo> localCommits = this.getNewCommits(userName, commitTimestampStore.getLastLocalCommitTimestamp(), CommitType.LOCAL);
            List<CommitInfo> remoteCommits = this.getNewCommits(userName, commitTimestampStore.getLastRemoteCommitTimestamp(), CommitType.REMOTE);
            Collection collection2 = localCommits;
            if (!(collection2 == null || collection2.isEmpty())) {
                this.recordCommits(localCommits);
                CommitInfo commitInfo = (CommitInfo)CollectionsKt.lastOrNull(localCommits);
                commitTimestampStore.setLastLocalCommitTimestamp(commitInfo != null ? Long.valueOf(commitInfo.getCommitTimestamp()) : null);
            }
            if (!((collection2 = (Collection)remoteCommits) == null || collection2.isEmpty())) {
                this.recordCommits(remoteCommits);
                CommitInfo commitInfo = (CommitInfo)CollectionsKt.lastOrNull(remoteCommits);
                commitTimestampStore.setLastRemoteCommitTimestamp(commitInfo != null ? Long.valueOf(commitInfo.getCommitTimestamp()) : null);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void recordCommits(List<CommitInfo> commits) {
        Collection<CommitMetricsEvent.CommitInfo> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = commits;
        CommitMetricsEvent.Builder builder = CommitMetricsEvent.newBuilder();
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.COMMIT_METRICS_EVENT);
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void commit;
            CommitInfo commitInfo = (CommitInfo)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CommitMetricsEvent.CommitInfo.newBuilder().setCommitType(commit.getType().metricsCommitType()).setCommitTimestamp(commit.getCommitTimestamp()).setAuthorTimestamp(commit.getAuthorTimestamp()).setIsFirstCommit(commit.getFirst()).build());
        }
        collection2 = (List)destination$iv$iv;
        AndroidStudioEvent.Builder builder3 = builder2.setCommitMetricsEvent(builder.addAllCommitInfo((Iterable)collection2));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"setCommitMetricsEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder3);
    }

    private final String getUserGitInfo() {
        try {
            Object[] objectArray = new String[]{"git", "config", "user.email"};
            List command = CollectionsKt.listOf((Object[])objectArray);
            String string = this.runProcessWithTimeout(command);
            if (string == null) {
                return null;
            }
            String output = string;
            String userName = ((Object)StringsKt.trim((CharSequence)output)).toString();
            if (((CharSequence)userName).length() > 0) {
                return userName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.warn("Unable to retrieve Git user information");
        return null;
    }

    private final List<CommitInfo> getNewCommits(String userName, Long lastCommitTimestamp, CommitType commitType) {
        List list2;
        try {
            String branchFilter = null;
            switch (WhenMappings.$EnumSwitchMapping$0[commitType.ordinal()]) {
                case 1: {
                    branchFilter = "--branches";
                    break;
                }
                case 2: {
                    Object[] objectArray = new String[]{"git", "rev-parse", "--abbrev-ref", "--symbolic-full-name", "@{u}"};
                    List gitCommand = CollectionsKt.listOf((Object[])objectArray);
                    String string = this.runProcessWithTimeout(gitCommand);
                    if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                        return null;
                    }
                    branchFilter = string;
                    if (!StringsKt.startsWith$default((String)branchFilter, (String)"-", (boolean)false, (int)2, null) && !(((CharSequence)branchFilter).length() == 0)) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
            Object[] objectArray = new String[]{"git", "log", branchFilter, "--author=" + userName, "--pretty=%at %ct"};
            List gitCommand = CollectionsKt.mutableListOf((Object[])objectArray);
            if (lastCommitTimestamp != null) {
                objectArray = new String[]{"--since=" + (lastCommitTimestamp + 1L), "-n", "10"};
                v1 = gitCommand.addAll(CollectionsKt.listOf((Object[])objectArray));
            } else {
                objectArray = new String[]{"-n", "1"};
                v1 = gitCommand.addAll(CollectionsKt.listOf((Object[])objectArray));
            }
            String string = this.runProcessWithTimeout(gitCommand);
            if (string == null) {
                return null;
            }
            String output = string;
            List commits = new ArrayList();
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)output);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)line))) continue;
                char[] cArray = new char[]{' '};
                List outputFields = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                long authorTimestamp = Long.parseLong((String)outputFields.get(0));
                long commitTimestamp = Long.parseLong((String)outputFields.get(1));
                commits.add(new CommitInfo(authorTimestamp, commitTimestamp, commitType, false));
            }
            List $this$sortBy$iv = commits;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CommitInfo it = (CommitInfo)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getCommitTimestamp());
                        it = (CommitInfo)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCommitTimestamp()));
                    }
                });
            }
            if (!((Collection)commits).isEmpty() && lastCommitTimestamp == null) {
                commits.set(0, CommitInfo.copy$default((CommitInfo)commits.get(0), 0L, 0L, null, true, 7, null));
            }
            list2 = CollectionsKt.toList((Iterable)commits);
        }
        catch (Exception e) {
            LOG.warn("Error: Unable to retrieve Git log.");
            list2 = null;
        }
        return list2;
    }

    private static final void runProcessWithTimeout$lambda$0(Process $process, StringBuilder $output) {
        try {
            InputStreamReader reader2 = new InputStreamReader($process.getInputStream());
            $output.append(TextStreamsKt.readText((Reader)reader2));
        }
        catch (Exception e) {
            LOG.error("Error reading process output", (Throwable)e);
        }
    }

    static {
        Logger logger = Logger.getInstance(GitCommitTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitInfo;", "", "authorTimestamp", "", "commitTimestamp", "type", "Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;", "first", "", "<init>", "(JJLcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;Z)V", "getAuthorTimestamp", "()J", "getCommitTimestamp", "getType", "()Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;", "getFirst", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class CommitInfo {
        private final long authorTimestamp;
        private final long commitTimestamp;
        @NotNull
        private final CommitType type;
        private final boolean first;

        public CommitInfo(long authorTimestamp, long commitTimestamp, @NotNull CommitType type, boolean first) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.authorTimestamp = authorTimestamp;
            this.commitTimestamp = commitTimestamp;
            this.type = type;
            this.first = first;
        }

        public final long getAuthorTimestamp() {
            return this.authorTimestamp;
        }

        public final long getCommitTimestamp() {
            return this.commitTimestamp;
        }

        @NotNull
        public final CommitType getType() {
            return this.type;
        }

        public final boolean getFirst() {
            return this.first;
        }

        public final long component1() {
            return this.authorTimestamp;
        }

        public final long component2() {
            return this.commitTimestamp;
        }

        @NotNull
        public final CommitType component3() {
            return this.type;
        }

        public final boolean component4() {
            return this.first;
        }

        @NotNull
        public final CommitInfo copy(long authorTimestamp, long commitTimestamp, @NotNull CommitType type, boolean first) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new CommitInfo(authorTimestamp, commitTimestamp, type, first);
        }

        public static /* synthetic */ CommitInfo copy$default(CommitInfo commitInfo, long l, long l2, CommitType commitType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                l = commitInfo.authorTimestamp;
            }
            if ((n & 2) != 0) {
                l2 = commitInfo.commitTimestamp;
            }
            if ((n & 4) != 0) {
                commitType = commitInfo.type;
            }
            if ((n & 8) != 0) {
                bl = commitInfo.first;
            }
            return commitInfo.copy(l, l2, commitType, bl);
        }

        @NotNull
        public String toString() {
            return "CommitInfo(authorTimestamp=" + this.authorTimestamp + ", commitTimestamp=" + this.commitTimestamp + ", type=" + this.type + ", first=" + this.first + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.authorTimestamp);
            result2 = result2 * 31 + Long.hashCode(this.commitTimestamp);
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.first);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitInfo)) {
                return false;
            }
            CommitInfo commitInfo = (CommitInfo)other;
            if (this.authorTimestamp != commitInfo.authorTimestamp) {
                return false;
            }
            if (this.commitTimestamp != commitInfo.commitTimestamp) {
                return false;
            }
            if (this.type != commitInfo.type) {
                return false;
            }
            return this.first == commitInfo.first;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H&j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;", "", "<init>", "(Ljava/lang/String;I)V", "LOCAL", "REMOTE", "metricsCommitType", "Lcom/google/wireless/android/sdk/stats/CommitMetricsEvent$CommitType;", "intellij.android.core"})
    public static final abstract class CommitType
    extends Enum<CommitType> {
        public static final /* enum */ CommitType LOCAL = new LOCAL("LOCAL", 0);
        public static final /* enum */ CommitType REMOTE = new REMOTE("REMOTE", 1);
        private static final /* synthetic */ CommitType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CommitType() {
        }

        @NotNull
        public abstract CommitMetricsEvent.CommitType metricsCommitType();

        public static CommitType[] values() {
            return (CommitType[])$VALUES.clone();
        }

        public static CommitType valueOf(String value2) {
            return Enum.valueOf(CommitType.class, value2);
        }

        @NotNull
        public static EnumEntries<CommitType> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ CommitType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = commitTypeArray = new CommitType[]{CommitType.LOCAL, CommitType.REMOTE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/android/tools/idea/diagnostics/commit/GitCommitTracker.CommitType.LOCAL", "Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;", "metricsCommitType", "Lcom/google/wireless/android/sdk/stats/CommitMetricsEvent$CommitType;", "intellij.android.core"})
        static final class LOCAL
        extends CommitType {
            /*
             * WARNING - void declaration
             */
            LOCAL() {
                void var1_1;
            }

            @Override
            @NotNull
            public CommitMetricsEvent.CommitType metricsCommitType() {
                return CommitMetricsEvent.CommitType.LOCAL;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"com/android/tools/idea/diagnostics/commit/GitCommitTracker.CommitType.REMOTE", "Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$CommitType;", "metricsCommitType", "Lcom/google/wireless/android/sdk/stats/CommitMetricsEvent$CommitType;", "intellij.android.core"})
        static final class REMOTE
        extends CommitType {
            /*
             * WARNING - void declaration
             */
            REMOTE() {
                void var1_1;
            }

            @Override
            @NotNull
            public CommitMetricsEvent.CommitType metricsCommitType() {
                return CommitMetricsEvent.CommitType.REMOTE;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/commit/GitCommitTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INITIAL_DELAY_MINUTES", "", "INTERVAL_IN_MINUTES", "COMMAND_TIMEOUT_SECONDS", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommitType.values().length];
            try {
                nArray[CommitType.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommitType.REMOTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

