/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StudioReportDatabase {
    private final Object myDbLock = new Object();
    private final Path myDb;

    public StudioReportDatabase(@NotNull File databaseFile) {
        this(databaseFile.toPath());
    }

    public StudioReportDatabase(@NotNull Path databasePath) {
        this.myDb = databasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DiagnosticReport> reapReports() {
        ImmutableList result2;
        Object object = this.myDbLock;
        synchronized (object) {
            try {
                result2 = this.getReports();
            }
            catch (Exception e) {
                result2 = ImmutableList.of();
            }
            try {
                Files.write(this.myDb, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                result2 = ImmutableList.of();
            }
        }
        return result2;
    }

    @NotNull
    public List<DiagnosticReport> getReports() throws IOException {
        Object object = this.myDbLock;
        synchronized (object) {
            ArrayList<DiagnosticReport> arrayList;
            if (!Files.exists(this.myDb, new LinkOption[0]) || Files.size(this.myDb) == 0L) {
                return ImmutableList.of();
            }
            try (InputStreamReader reader2 = new InputStreamReader((InputStream)new FileInputStream(this.myDb.toFile()), StandardCharsets.UTF_8);){
                arrayList = DiagnosticReport.Companion.readDiagnosticReports(reader2);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendReport(DiagnosticReport report) throws IOException {
        try (StringWriter sw = new StringWriter();){
            report.serializeReport(sw);
            String content2 = sw.toString() + "\n";
            Object object = this.myDbLock;
            synchronized (object) {
                Files.write(this.myDb, content2.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
        }
    }
}

