/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.StudioCrashDetails;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class StudioCrashDetection {
    private static final String RECORD_FILE_KEY = "studio.record.file";
    private static final String PLATFORM_PREFIX = "AndroidStudio";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static ArrayList<StudioCrashDetails> ourCrashes;

    private StudioCrashDetection() {
    }

    public static void start() {
        block8: {
            if (System.getProperty(RECORD_FILE_KEY) != null) {
                throw new AssertionError((Object)"StudioCrashDetection.start called more than once");
            }
            try {
                File f = new File(PathManager.getTempPath(), String.format("%s.%s", PLATFORM_PREFIX, UUID.randomUUID()));
                if (!f.createNewFile()) break block8;
                System.setProperty(RECORD_FILE_KEY, f.getAbsolutePath());
                try (FileWriter fw = new FileWriter(f);){
                    fw.write(ApplicationInfo.getInstance().getStrictVersion());
                    fw.write(LINE_SEPARATOR);
                    fw.write(System.getProperty("java.runtime.version"));
                    fw.write(LINE_SEPARATOR);
                    fw.write(String.valueOf(ManagementFactory.getRuntimeMXBean().getStartTime()));
                    fw.write(LINE_SEPARATOR);
                    fw.write(String.valueOf(StudioCrashDetection.getMyPID()));
                    fw.write(LINE_SEPARATOR);
                    fw.write(UsageTracker.getSessionId());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static long getMyPID() {
        String pidAndMachineName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = pidAndMachineName.split("@");
        long pid = -1L;
        if (split.length == 2) {
            try {
                pid = Long.parseLong(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pid;
    }

    public static void stop() {
        String recordFileName = System.getProperty(RECORD_FILE_KEY);
        if (recordFileName != null) {
            try {
                Files.deleteIfExists(Paths.get(recordFileName, new String[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.clearProperty(RECORD_FILE_KEY);
        }
    }

    public static List<StudioCrashDetails> reapCrashDescriptions() {
        if (ourCrashes != null) {
            return ourCrashes;
        }
        File[] previousRecords = new File(PathManager.getTempPath()).listFiles(new FileFilter(){
            final String recordFile = System.getProperty("studio.record.file");

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(StudioCrashDetection.PLATFORM_PREFIX) && !pathname.getAbsolutePath().equals(this.recordFile);
            }
        });
        ourCrashes = new ArrayList();
        if (previousRecords != null) {
            for (File record : previousRecords) {
                StudioCrashDetails crash;
                try {
                    crash = StudioCrashDetails.loadFromRecordFile(record);
                }
                catch (IOException ignored) {
                    crash = StudioCrashDetails.UNKNOWN;
                }
                try {
                    if (!Files.deleteIfExists(record.toPath())) continue;
                    ourCrashes.add(crash);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return ourCrashes;
    }
}

