/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.ui;

import com.android.tools.idea.device.explorer.files.DeviceExplorerModelListener;
import com.android.tools.idea.device.explorer.files.DeviceExplorerViewListener;
import com.android.tools.idea.device.explorer.files.DeviceExplorerViewProgressListener;
import com.android.tools.idea.device.explorer.files.DeviceFileEntryNode;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.android.tools.idea.device.explorer.files.ui.ComponentPopupMenu;
import com.android.tools.idea.device.explorer.files.ui.DeviceExplorerPanel;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerActionListener;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerViewImpl;
import com.android.tools.idea.device.explorer.files.ui.menu.item.CopyPathMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.DeleteNodesMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.MenuContext;
import com.android.tools.idea.device.explorer.files.ui.menu.item.NewDirectoryMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.NewFileMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.OpenMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.PackageFilterMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.SaveAsMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.SynchronizeNodesMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.UploadFilesMenuItem;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import icons.StudioIllustrations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006*\u0004JMRU\u0018\u00002\u00020\u0001:\u0002`aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020\u001eH\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\b\u00100\u001a\u00020\u001eH\u0016J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020,H\u0016J\b\u00103\u001a\u00020\u001eH\u0016J\u0010\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020%H\u0016J\u0010\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u001eH\u0016J\u0010\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u0007H\u0016J\b\u0010<\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020%H\u0016J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020%H\u0016J\b\u0010A\u001a\u00020BH\u0007J\n\u0010C\u001a\u0004\u0018\u00010DH\u0007J\b\u0010E\u001a\u00020\u0012H\u0007J\b\u0010F\u001a\u00020\u0010H\u0007J\u0018\u0010G\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010H\u001a\u00020\u001eH\u0002J\r\u0010I\u001a\u00020JH\u0002\u00a2\u0006\u0002\u0010KJ\u0015\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010PJ\u0015\u0010Q\u001a\u00020R2\u0006\u0010N\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010SJ\u0015\u0010T\u001a\u00020U2\u0006\u0010N\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010VJ\b\u0010W\u001a\u00020\u001eH\u0002J\b\u0010X\u001a\u00020\u001eH\u0002J\u0016\u0010Y\u001a\u00020\u001e2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0002J\u0010\u0010]\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010^\u001a\u00020\u001eH\u0002J\b\u0010_\u001a\u00020\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl;", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerView;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerModel;", "toolWindowID", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerModel;Ljava/lang/String;)V", "listeners", "", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerViewListener;", "progressListeners", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerViewProgressListener;", "panel", "Lcom/android/tools/idea/device/explorer/files/ui/DeviceExplorerPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "treePopupMenu", "Lcom/android/tools/idea/device/explorer/files/ui/ComponentPopupMenu;", "treeLoadingCount", "", "fileExplorerActionListener", "Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$DeviceFileExplorerActionListenerImpl;", "packageFilterMenuItem", "Lcom/android/tools/idea/device/explorer/files/ui/menu/item/PackageFilterMenuItem;", "getComponent", "Ljavax/swing/JComponent;", "addListener", "", "listener", "removeListener", "addProgressListener", "removeProgressListener", "setup", "packageFilterActive", "", "reportError", "message", "t", "", "reportErrorRelatedToNode", "node", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "reportMessageRelatedToNode", "showNoDeviceScreen", "startTreeBusyIndicator", "stopTreeBusyIndicator", "expandNode", "treeNode", "startProgress", "setProgressIndeterminate", "indeterminate", "setProgressValue", "fraction", "", "setProgressWarningColor", "setProgressText", "text", "stopProgress", "setPackageFilterSelection", "isSelected", "enablePackageFilter", "shouldEnable", "getFileTree", "Ljavax/swing/JTree;", "getFileTreeActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getLoadingPanel", "getDeviceExplorerPanel", "reportMessage", "setupPanel", "getTreeWillExpandListener", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTreeWillExpandListener$1", "()Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTreeWillExpandListener$1;", "getMouseListener", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getMouseListener$1", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "(Lcom/intellij/ui/treeStructure/Tree;)Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getMouseListener$1;", "getKeyListener", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getKeyListener$1", "(Lcom/intellij/ui/treeStructure/Tree;)Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getKeyListener$1;", "getTransferHandler", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTransferHandler$1", "(Lcom/intellij/ui/treeStructure/Tree;)Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTransferHandler$1;", "createTreePopupMenu", "createToolBar", "openSelectedNodes", "paths", "", "Ljavax/swing/tree/TreePath;", "expandTreeNode", "incrementTreeLoading", "decrementTreeLoading", "ModelListener", "DeviceFileExplorerActionListenerImpl", "intellij.android.device-explorer-files"})
public final class DeviceFileExplorerViewImpl
implements DeviceFileExplorerView {
    @NotNull
    private final String toolWindowID;
    @NotNull
    private final List<DeviceExplorerViewListener> listeners;
    @NotNull
    private final List<DeviceExplorerViewProgressListener> progressListeners;
    @NotNull
    private final DeviceExplorerPanel panel;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @Nullable
    private ComponentPopupMenu treePopupMenu;
    private int treeLoadingCount;
    @NotNull
    private DeviceFileExplorerActionListenerImpl fileExplorerActionListener;
    @NotNull
    private final PackageFilterMenuItem packageFilterMenuItem;

    public DeviceFileExplorerViewImpl(@NotNull Project project, @NotNull DeviceFileExplorerModel model, @NotNull String toolWindowID) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)toolWindowID, (String)"toolWindowID");
        this.toolWindowID = toolWindowID;
        this.listeners = new ArrayList();
        this.progressListeners = new ArrayList();
        this.panel = new DeviceExplorerPanel();
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project, 0, 4, null);
        this.fileExplorerActionListener = new DeviceFileExplorerActionListenerImpl();
        this.packageFilterMenuItem = new PackageFilterMenuItem(this.fileExplorerActionListener);
        model.addListener(new ModelListener());
        this.panel.setCancelActionListener(arg_0 -> DeviceFileExplorerViewImpl._init_$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.loadingPanel;
    }

    @Override
    public void addListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void addProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.progressListeners.add(listener2);
    }

    @Override
    public void removeProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.progressListeners.remove(listener2);
    }

    @Override
    public void setup(boolean packageFilterActive) {
        this.setupPanel();
        this.packageFilterMenuItem.setActionSelected(packageFilterActive);
    }

    @Override
    public void reportError(@NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String messageToReport = t.getMessage() != null ? message + ": " + t.getMessage() : message;
        this.panel.showErrorMessageLayer(messageToReport);
    }

    @Override
    public void reportErrorRelatedToNode(@NotNull DeviceFileEntryNode node, @NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.reportError(message, t, this.toolWindowID);
    }

    @Override
    public void reportMessageRelatedToNode(@NotNull DeviceFileEntryNode node, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.reportMessage(message, this.toolWindowID);
    }

    @Override
    public void showNoDeviceScreen() {
        this.panel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", StudioIllustrations.Common.DEVICES_LINEUP);
    }

    @Override
    public void startTreeBusyIndicator() {
        this.incrementTreeLoading();
    }

    @Override
    public void stopTreeBusyIndicator() {
        this.decrementTreeLoading();
    }

    @Override
    public void expandNode(@NotNull DeviceFileEntryNode treeNode) {
        Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
        this.panel.getTree().expandPath(new TreePath(treeNode.getPath()));
    }

    @Override
    public void startProgress() {
        this.panel.getProgressPanel().start();
    }

    @Override
    public void setProgressIndeterminate(boolean indeterminate) {
        this.panel.getProgressPanel().setIndeterminate(indeterminate);
    }

    @Override
    public void setProgressValue(double fraction) {
        this.panel.getProgressPanel().setProgress(fraction);
    }

    @Override
    public void setProgressWarningColor() {
        this.panel.getProgressPanel().setWarningStatusColor();
    }

    @Override
    public void setProgressText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.panel.getProgressPanel().setText(text2);
    }

    @Override
    public void stopProgress() {
        this.panel.getProgressPanel().stop();
    }

    @Override
    public void setPackageFilterSelection(boolean isSelected) {
        this.packageFilterMenuItem.setActionSelected(isSelected);
    }

    @Override
    public void enablePackageFilter(boolean shouldEnable) {
        this.packageFilterMenuItem.setShouldBeEnabled(shouldEnable);
    }

    @TestOnly
    @NotNull
    public final JTree getFileTree() {
        Tree tree = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
        return (JTree)tree;
    }

    @TestOnly
    @Nullable
    public final ActionGroup getFileTreeActionGroup() {
        ComponentPopupMenu componentPopupMenu = this.treePopupMenu;
        return componentPopupMenu != null ? componentPopupMenu.getActionGroup() : null;
    }

    @TestOnly
    @NotNull
    public final JBLoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    @TestOnly
    @NotNull
    public final DeviceExplorerPanel getDeviceExplorerPanel() {
        return this.panel;
    }

    private final void reportMessage(String message, String toolWindowID) {
        Notification notification = new Notification(toolWindowID, toolWindowID, message, NotificationType.INFORMATION);
        ApplicationManager.getApplication().invokeLater(() -> DeviceFileExplorerViewImpl.reportMessage$lambda$0(notification));
    }

    private final void reportError(String message, Throwable t, String toolWindowID) {
        if (t instanceof CancellationException) {
            return;
        }
        String messageToReport = t.getMessage() != null ? message + ": " + t.getMessage() : message;
        Notification notification = new Notification(toolWindowID, toolWindowID, messageToReport, NotificationType.WARNING);
        ApplicationManager.getApplication().invokeLater(() -> DeviceFileExplorerViewImpl.reportError$lambda$0(notification));
    }

    private final void setupPanel() {
        JPanel jPanel = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getComponent(...)");
        this.loadingPanel.add((Component)jPanel, (Object)"Center");
        Tree tree = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
        Tree tree2 = tree;
        tree2.addTreeWillExpandListener((TreeWillExpandListener)this.getTreeWillExpandListener());
        tree2.addMouseListener((MouseListener)this.getMouseListener(tree2));
        tree2.addKeyListener((KeyListener)this.getKeyListener(tree2));
        tree2.setTransferHandler((TransferHandler)this.getTransferHandler(tree2));
        tree2.setDragEnabled(!GraphicsEnvironment.isHeadless());
        this.createTreePopupMenu();
        this.createToolBar();
    }

    private final getTreeWillExpandListener.1 getTreeWillExpandListener() {
        return new TreeWillExpandListener(this){
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                block0: {
                    DeviceFileEntryNode node;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    DeviceFileEntryNode deviceFileEntryNode = node = DeviceFileEntryNode.fromNode(event.getPath().getLastPathComponent());
                    if (deviceFileEntryNode == null) break block0;
                    DeviceFileEntryNode deviceFileEntryNode2 = deviceFileEntryNode;
                    DeviceFileExplorerViewImpl deviceFileExplorerViewImpl = this.this$0;
                    DeviceFileEntryNode it = deviceFileEntryNode2;
                    boolean bl = false;
                    DeviceFileExplorerViewImpl.access$expandTreeNode(deviceFileExplorerViewImpl, it);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        };
    }

    private final getMouseListener.1 getMouseListener(Tree tree) {
        return new MouseAdapter(tree, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    int selRow = this.$tree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = this.$tree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1 && selPath != null) {
                        DeviceFileExplorerViewImpl.access$openSelectedNodes(this.this$0, CollectionsKt.listOf((Object)selPath));
                    }
                }
            }
        };
    }

    private final getKeyListener.1 getKeyListener(Tree tree) {
        return new KeyAdapter(tree, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                TreePath[] paths;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (10 == e.getKeyCode() && (paths = this.$tree.getSelectionPaths()) != null) {
                    TreePath[] treePathArray = paths;
                    DeviceFileExplorerViewImpl.access$openSelectedNodes(this.this$0, CollectionsKt.listOf((Object[])Arrays.copyOf(treePathArray, treePathArray.length)));
                }
            }
        };
    }

    private final getTransferHandler.1 getTransferHandler(Tree tree) {
        return new TransferHandler(tree, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public boolean importData(TransferHandler.TransferSupport support) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)support, (String)"support");
                Transferable t = support.getTransferable();
                List list2 = FileCopyPasteUtil.getFiles((Transferable)t);
                if (list2 == null) {
                    return false;
                }
                List files2 = list2;
                Point point = support.getDropLocation().getDropPoint();
                TreePath treePath = this.$tree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (treePath == null) {
                    return false;
                }
                TreePath treePath2 = treePath;
                DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(treePath2.getLastPathComponent());
                if (node != null && (node.getEntry().isDirectory() || node.isSymbolicLinkToDirectory())) {
                    DeviceFileExplorerViewImpl.access$getListeners$p(this.this$0).forEach(arg_0 -> getTransferHandler.1.importData$lambda$0(node, files2, arg_0));
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
                return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])transferFlavors);
            }

            private static final void importData$lambda$0(DeviceFileEntryNode $node, List $files, DeviceExplorerViewListener it) {
                it.uploadFilesInvoked($node, $files);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void createTreePopupMenu() {
        void $this$createTreePopupMenu_u24lambda_u240;
        ComponentPopupMenu componentPopupMenu;
        ComponentPopupMenu componentPopupMenu2 = componentPopupMenu = new ComponentPopupMenu((JComponent)this.panel.getTree());
        DeviceFileExplorerViewImpl deviceFileExplorerViewImpl = this;
        boolean bl = false;
        ComponentPopupMenu fileMenu = $this$createTreePopupMenu_u24lambda_u240.addPopup("New");
        fileMenu.addItem(new NewFileMenuItem(this.fileExplorerActionListener));
        fileMenu.addItem(new NewDirectoryMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addSeparator();
        $this$createTreePopupMenu_u24lambda_u240.addItem(new OpenMenuItem(this.fileExplorerActionListener));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new SaveAsMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new UploadFilesMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new DeleteNodesMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addSeparator();
        $this$createTreePopupMenu_u24lambda_u240.addItem(new SynchronizeNodesMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new CopyPathMenuItem(this.fileExplorerActionListener));
        $this$createTreePopupMenu_u24lambda_u240.install();
        deviceFileExplorerViewImpl.treePopupMenu = componentPopupMenu;
    }

    private final void createToolBar() {
        DefaultActionGroup defaultActionGroup;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup $this$createToolBar_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$createToolBar_u24lambda_u240.add(new NewDirectoryMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u240.add(new SaveAsMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u240.add(new UploadFilesMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u240.add(new DeleteNodesMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u240.add(new SynchronizeNodesMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        if (((Boolean)StudioFlags.DEVICE_EXPLORER_PROCESSES_PACKAGE_FILTER.get()).booleanValue()) {
            $this$createToolBar_u24lambda_u240.add(this.packageFilterMenuItem.getAction());
        }
        DefaultActionGroup actionGroup2 = defaultActionGroup;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Device File Explorer Toolbar", (ActionGroup)actionGroup2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this.panel.getTree());
        this.panel.getToolbarPanel().add((Component)actionToolbar2.getComponent(), "West");
    }

    private final void openSelectedNodes(List<? extends TreePath> paths) {
        List nodes = paths.stream().map(arg_0 -> DeviceFileExplorerViewImpl.openSelectedNodes$lambda$1(DeviceFileExplorerViewImpl::openSelectedNodes$lambda$0, arg_0)).filter(arg_0 -> DeviceFileExplorerViewImpl.openSelectedNodes$lambda$3(DeviceFileExplorerViewImpl::openSelectedNodes$lambda$2, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNull(nodes);
        this.fileExplorerActionListener.openNodes(nodes);
    }

    private final void expandTreeNode(DeviceFileEntryNode node) {
        this.listeners.forEach(arg_0 -> DeviceFileExplorerViewImpl.expandTreeNode$lambda$0(node, arg_0));
    }

    private final void incrementTreeLoading() {
        if (this.treeLoadingCount == 0) {
            this.panel.getTree().setPaintBusy(true);
        }
        int n = this.treeLoadingCount;
        this.treeLoadingCount = n + 1;
    }

    private final void decrementTreeLoading() {
        int n = this.treeLoadingCount;
        this.treeLoadingCount = n + -1;
        if (this.treeLoadingCount == 0) {
            this.panel.getTree().setPaintBusy(false);
        }
    }

    private static final void _init_$lambda$0(DeviceFileExplorerViewImpl this$0, ActionEvent actionEvent) {
        this$0.progressListeners.forEach(DeviceFileExplorerViewImpl::lambda$0$0);
    }

    private static final void lambda$0$0(DeviceExplorerViewProgressListener it) {
        it.cancellationRequested();
    }

    private static final void reportMessage$lambda$0(Notification $notification) {
        Notifications.Bus.notify((Notification)$notification);
    }

    private static final void reportError$lambda$0(Notification $notification) {
        Notifications.Bus.notify((Notification)$notification);
    }

    private static final DeviceFileEntryNode openSelectedNodes$lambda$0(TreePath x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return DeviceFileEntryNode.fromNode(x.getLastPathComponent());
    }

    private static final DeviceFileEntryNode openSelectedNodes$lambda$1(Function1 $tmp0, Object p0) {
        return (DeviceFileEntryNode)$tmp0.invoke(p0);
    }

    private static final boolean openSelectedNodes$lambda$2(DeviceFileEntryNode obj) {
        return Objects.nonNull(obj);
    }

    private static final boolean openSelectedNodes$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void expandTreeNode$lambda$0(DeviceFileEntryNode $node, DeviceExplorerViewListener it) {
        it.treeNodeExpanding($node);
    }

    public static final /* synthetic */ void access$openSelectedNodes(DeviceFileExplorerViewImpl $this, List paths) {
        $this.openSelectedNodes(paths);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$DeviceFileExplorerActionListenerImpl;", "Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerActionListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl;)V", "selectedNodes", "", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "getSelectedNodes", "()Ljava/util/List;", "copyNodePaths", "", "nodes", "openNodes", "saveNodesAs", "deleteNodes", "synchronizeNodes", "newFile", "node", "newDirectory", "uploadFile", "setPackageFilter", "isActive", "", "intellij.android.device-explorer-files"})
    private final class DeviceFileExplorerActionListenerImpl
    implements DeviceFileExplorerActionListener {
        @Override
        @Nullable
        public List<DeviceFileEntryNode> getSelectedNodes() {
            TreePath[] paths = DeviceFileExplorerViewImpl.this.panel.getTree().getSelectionPaths();
            if (paths != null) {
                TreePath[] it = paths;
                boolean bl = false;
                List<DeviceFileEntryNode> nodes = Arrays.stream(paths).map(arg_0 -> DeviceFileExplorerActionListenerImpl._get_selectedNodes_$lambda$0$1(DeviceFileExplorerActionListenerImpl::_get_selectedNodes_$lambda$0$0, arg_0)).filter(arg_0 -> DeviceFileExplorerActionListenerImpl._get_selectedNodes_$lambda$0$3(DeviceFileExplorerActionListenerImpl::_get_selectedNodes_$lambda$0$2, arg_0)).collect(Collectors.toList());
                return nodes.isEmpty() ? null : nodes;
            }
            return null;
        }

        @Override
        public void copyNodePaths(@NotNull List<? extends DeviceFileEntryNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.copyNodePaths$lambda$0(nodes, arg_0));
        }

        @Override
        public void openNodes(@NotNull List<? extends DeviceFileEntryNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.openNodes$lambda$0(nodes, arg_0));
        }

        @Override
        public void saveNodesAs(@NotNull List<? extends DeviceFileEntryNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.saveNodesAs$lambda$0(nodes, arg_0));
        }

        @Override
        public void deleteNodes(@NotNull List<? extends DeviceFileEntryNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.deleteNodes$lambda$0(nodes, arg_0));
        }

        @Override
        public void synchronizeNodes() {
            DeviceFileExplorerViewImpl.this.listeners.forEach(DeviceFileExplorerActionListenerImpl::synchronizeNodes$lambda$0);
        }

        @Override
        public void newFile(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.newFile$lambda$0(node, arg_0));
        }

        @Override
        public void newDirectory(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.newDirectory$lambda$0(node, arg_0));
        }

        @Override
        public void uploadFile(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.uploadFile$lambda$0(node, arg_0));
        }

        @Override
        public void setPackageFilter(boolean isActive) {
            DeviceFileExplorerViewImpl.this.listeners.forEach(arg_0 -> DeviceFileExplorerActionListenerImpl.setPackageFilter$lambda$0(isActive, arg_0));
        }

        private static final DeviceFileEntryNode _get_selectedNodes_$lambda$0$0(TreePath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return DeviceFileEntryNode.fromNode(path.getLastPathComponent());
        }

        private static final DeviceFileEntryNode _get_selectedNodes_$lambda$0$1(Function1 $tmp0, Object p0) {
            return (DeviceFileEntryNode)$tmp0.invoke(p0);
        }

        private static final boolean _get_selectedNodes_$lambda$0$2(DeviceFileEntryNode obj) {
            return Objects.nonNull(obj);
        }

        private static final boolean _get_selectedNodes_$lambda$0$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void copyNodePaths$lambda$0(List $nodes, DeviceExplorerViewListener it) {
            it.copyNodePathsInvoked($nodes);
        }

        private static final void openNodes$lambda$0(List $nodes, DeviceExplorerViewListener it) {
            it.openNodesInEditorInvoked($nodes);
        }

        private static final void saveNodesAs$lambda$0(List $nodes, DeviceExplorerViewListener it) {
            it.saveNodesAsInvoked($nodes);
        }

        private static final void deleteNodes$lambda$0(List $nodes, DeviceExplorerViewListener it) {
            it.deleteNodesInvoked($nodes);
        }

        private static final void synchronizeNodes$lambda$0(DeviceExplorerViewListener it) {
            it.synchronizeNodesInvoked();
        }

        private static final void newFile$lambda$0(DeviceFileEntryNode $node, DeviceExplorerViewListener it) {
            it.newFileInvoked($node);
        }

        private static final void newDirectory$lambda$0(DeviceFileEntryNode $node, DeviceExplorerViewListener it) {
            it.newDirectoryInvoked($node);
        }

        private static final void uploadFile$lambda$0(DeviceFileEntryNode $node, DeviceExplorerViewListener it) {
            it.uploadFilesInvoked($node);
        }

        private static final void setPackageFilter$lambda$0(boolean $isActive, DeviceExplorerViewListener it) {
            it.togglePackageFilterInvoked($isActive);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$ModelListener;", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerModelListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl;)V", "treeModelChanged", "", "newTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "newTreeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "setRootFolder", "model", "treeSelectionModel", "intellij.android.device-explorer-files"})
    private final class ModelListener
    implements DeviceExplorerModelListener {
        @Override
        public void treeModelChanged(@Nullable DefaultTreeModel newTreeModel, @Nullable DefaultTreeSelectionModel newTreeSelectionModel) {
            this.setRootFolder(newTreeModel, newTreeSelectionModel);
        }

        public final void setRootFolder(@Nullable DefaultTreeModel model, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
            Tree tree = DeviceFileExplorerViewImpl.this.panel.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
            Tree tree2 = tree;
            tree2.setModel((TreeModel)model);
            tree2.setSelectionModel((TreeSelectionModel)treeSelectionModel);
            if (model != null) {
                DeviceFileExplorerViewImpl.this.panel.showTree();
                DeviceFileEntryNode rootNode = DeviceFileEntryNode.fromNode(model.getRoot());
                if (rootNode != null) {
                    DeviceFileExplorerViewImpl.this.expandTreeNode(rootNode);
                }
            }
        }
    }
}

