/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files;

import com.android.tools.idea.device.explorer.files.DeviceExplorerViewProgressListener;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LongRunningOperationTracker
implements Disposable {
    @Nullable
    private DeviceFileExplorerView myView;
    private final boolean myBackgroundable;
    @NotNull
    private final DeviceExplorerViewProgressListener myProgressListener = () -> {
        this.myIsCancelled = true;
    };
    private boolean myIsCancelled;
    private long myStartNanoTime;

    public LongRunningOperationTracker(@NotNull DeviceFileExplorerView view, boolean backgroundable) {
        this.myView = view;
        this.myBackgroundable = backgroundable;
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    protected boolean isBackgroundable() {
        return this.myBackgroundable;
    }

    public long getDurationMillis() {
        return (System.nanoTime() - this.myStartNanoTime) / 1000000L;
    }

    public void start() {
        if (this.myView == null) {
            throw new UnsupportedOperationException("A background operation cannot be started again");
        }
        this.myView.addProgressListener(this.myProgressListener);
        this.myView.startProgress();
        this.myStartNanoTime = System.nanoTime();
        this.myIsCancelled = false;
    }

    public void stop() {
        if (this.myView != null) {
            this.myView.removeProgressListener(this.myProgressListener);
            this.myView.stopProgress();
        }
    }

    public void moveToBackground() {
        if (!this.myBackgroundable) {
            throw new UnsupportedOperationException("This operation is not backgroundable");
        }
        if (this.myView == null) {
            throw new IllegalStateException("This operation is already in background");
        }
        this.myView.removeProgressListener(this.myProgressListener);
        this.myView.stopProgress();
        this.myView.stopTreeBusyIndicator();
        this.myView = null;
    }

    public boolean isInForeground() {
        return this.myView != null;
    }

    public void dispose() {
        this.stop();
    }

    public void setIndeterminate(boolean indeterminate) {
        if (this.myView != null) {
            this.myView.setProgressIndeterminate(indeterminate);
        }
    }

    public void setProgress(double fraction) {
        if (this.myView != null) {
            this.myView.setProgressValue(fraction);
        }
    }

    public void setStatusText(@NotNull String text2) {
        if (this.myView != null) {
            this.myView.setProgressText(text2);
        }
    }

    public void setWarningColor() {
        if (this.myView != null) {
            this.myView.setProgressWarningColor();
        }
    }
}

