/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.AndroidXConstants;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.inspections.ResourceTypeCompletionContributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResolveHelper {
    @Nullable
    public static PsiAnnotation getAnnotationForLocal(@NotNull PsiElement context, @NotNull String name2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiVariable variable = facade.getResolveHelper().resolveReferencedVariable(name2, context);
        if (variable != null) {
            return AndroidResolveHelper.getAnnotationForVariable(variable, 0);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation getAnnotationForVariable(@NotNull PsiVariable variable, int depth) {
        PsiReferenceExpression reference;
        PsiAnnotation annotation;
        PsiMethodCallExpression callExpression;
        PsiElement resolved;
        PsiAnnotation annotation2;
        if (depth > 10) {
            return null;
        }
        if ((variable instanceof PsiParameter || variable instanceof PsiLocalVariable) && (annotation2 = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)variable)) != null) {
            return annotation2;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (initializer instanceof PsiMethodCallExpression ? (resolved = (callExpression = (PsiMethodCallExpression)initializer).getMethodExpression().resolve()) instanceof PsiMethod && (annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)((PsiMethod)resolved))) != null : initializer instanceof PsiReferenceExpression && ((resolved = (reference = (PsiReferenceExpression)initializer).resolve()) instanceof PsiField ? (annotation = AndroidResolveHelper.getAnnotationForField((PsiField)resolved)) != null : resolved instanceof PsiVariable && (annotation = AndroidResolveHelper.getAnnotationForVariable((PsiVariable)resolved, depth + 1)) != null))) {
            return annotation;
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class, (boolean)true);
        if (method2 == null) {
            return null;
        }
        Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)method2, PsiAssignmentExpression.class);
        for (PsiAssignmentExpression assignment : assignments) {
            PsiReferenceExpression ref;
            PsiAnnotation annotation3;
            PsiMethodCallExpression callExpression2;
            PsiElement r;
            PsiExpression rhs;
            PsiReferenceExpression reference2;
            PsiElement resolved2;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression) || (resolved2 = (reference2 = (PsiReferenceExpression)lhs).resolve()) != variable || !((rhs = assignment.getRExpression()) instanceof PsiMethodCallExpression ? (r = (callExpression2 = (PsiMethodCallExpression)rhs).getMethodExpression().resolve()) instanceof PsiMethod && (annotation3 = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)((PsiMethod)r))) != null : rhs instanceof PsiReferenceExpression && ((r = (ref = (PsiReferenceExpression)rhs).resolve()) instanceof PsiField ? (annotation3 = AndroidResolveHelper.getAnnotationForField((PsiField)r)) != null : r instanceof PsiVariable && (annotation3 = AndroidResolveHelper.getAnnotationForVariable((PsiVariable)r, depth + 1)) != null))) continue;
            return annotation3;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getAnnotationForField(@NotNull PsiElement context, @NotNull String className, @NotNull String fieldName) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className, AndroidResolveHelper.getSearchScope(context));
        if (psiClass == null) {
            return null;
        }
        PsiField field2 = psiClass.findFieldByName(fieldName, true);
        if (field2 != null) {
            return AndroidResolveHelper.getAnnotationForField(field2);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation getAnnotationForField(PsiField field2) {
        PsiMethod getter;
        PsiAnnotation annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)field2);
        if (annotation == null && (getter = PropertyUtilBase.findGetterForField((PsiField)field2)) != null) {
            return AndroidResolveHelper.getAnnotation((PsiModifierListOwner)getter);
        }
        return annotation;
    }

    @NotNull
    private static GlobalSearchScope getSearchScope(@NotNull PsiElement context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null) {
            return module.getModuleWithDependenciesAndLibrariesScope(false);
        }
        return GlobalSearchScope.projectScope((Project)context.getProject());
    }

    @Nullable
    private static PsiAnnotation getAnnotation(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return null;
        }
        Project project = owner.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope searchScope = AndroidResolveHelper.getSearchScope((PsiElement)owner);
        for (PsiAnnotation a : ResourceTypeCompletionContributor.getAllAnnotations(owner)) {
            String qualifiedName = a.getQualifiedName();
            if (qualifiedName == null || qualifiedName.startsWith("java")) continue;
            if (qualifiedName.endsWith("Res") || ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName) || ResourceEvaluator.PX_ANNOTATION.isEquals(qualifiedName) || AndroidXConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName)) {
                return a;
            }
            PsiClass annotationClass = psiFacade.findClass(qualifiedName, searchScope);
            PsiAnnotation annotation = AndroidResolveHelper.getAnnotation((PsiModifierListOwner)annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static IntDefResolution resolveIntDef(@NotNull PsiAnnotation annotation) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiAnnotationMemberValue intValues = annotation.findAttributeValue("value");
        PsiAnnotationMemberValue[] allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
        HashMap valuesMap = Maps.newHashMap();
        for (PsiAnnotationMemberValue value2 : allowedValues) {
            if (!(value2 instanceof PsiReference)) {
                return IntDefResolution.createError();
            }
            PsiElement resolved = ((PsiReference)value2).resolve();
            if (!(resolved instanceof PsiNamedElement)) {
                return IntDefResolution.createError();
            }
            if (!(resolved instanceof PsiField)) {
                return IntDefResolution.createError();
            }
            Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiField)resolved).getInitializer(), null, (boolean)false);
            if (!(v instanceof Integer)) {
                return IntDefResolution.createError();
            }
            valuesMap.put((Integer)v, ((PsiNamedElement)resolved).getName());
        }
        PsiAnnotationMemberValue orValue = annotation.findAttributeValue("flag");
        boolean canBeOred = orValue instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue());
        return new IntDefResolution(canBeOred, valuesMap);
    }

    public static class IntDefResolution {
        @Nullable
        public final Map<Integer, String> valuesMap;
        public final boolean canBeOred;

        public IntDefResolution(boolean canBeOred, @Nullable Map<Integer, String> valuesMap) {
            this.canBeOred = canBeOred;
            this.valuesMap = valuesMap;
        }

        public static IntDefResolution createError() {
            return new IntDefResolution(false, null);
        }
    }

    public static class ResolveResult {
        @NotNull
        public final String label;
        @Nullable
        public final Icon icon;

        public ResolveResult(@NotNull String label2, @Nullable Icon icon) {
            this.label = label2;
            this.icon = icon;
        }
    }
}

