/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.dagger.index.psiwrappers;

import com.android.tools.idea.dagger.index.psiwrappers.DaggerAnnotation;
import com.android.tools.idea.dagger.index.psiwrappers.ImportHelperBase;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/dagger/index/psiwrappers/JavaImportHelper;", "Lcom/android/tools/idea/dagger/index/psiwrappers/ImportHelperBase;", "psiJavaFile", "Lcom/intellij/psi/PsiJavaFile;", "<init>", "(Lcom/intellij/psi/PsiJavaFile;)V", "buildPossibleAnnotationText", "", "", "annotation", "Lcom/android/tools/idea/dagger/index/psiwrappers/DaggerAnnotation;", "isSimpleNameAllowed", "", "containerName", "Lorg/jetbrains/kotlin/name/FqName;", "desiredSimpleName", "Lorg/jetbrains/kotlin/name/Name;", "intellij.android.dagger"})
public final class JavaImportHelper
extends ImportHelperBase {
    @NotNull
    private final PsiJavaFile psiJavaFile;

    public JavaImportHelper(@NotNull PsiJavaFile psiJavaFile) {
        Intrinsics.checkNotNullParameter((Object)psiJavaFile, (String)"psiJavaFile");
        this.psiJavaFile = psiJavaFile;
    }

    @Override
    @NotNull
    protected Set<String> buildPossibleAnnotationText(@NotNull DaggerAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)((Object)annotation), (String)"annotation");
        Object[] objectArray = new String[]{annotation.getFqNameString()};
        Set result2 = SetsKt.mutableSetOf((Object[])objectArray);
        if (Intrinsics.areEqual((Object)annotation.getClassId().getPackageFqName().asString(), (Object)this.psiJavaFile.getPackageName())) {
            result2.add(annotation.getClassId().getRelativeClassName().asString());
        }
        FqName importFqName = annotation.getClassId().getPackageFqName();
        List relativeNameSequence = annotation.getClassId().getRelativeClassName().pathSegments();
        Iterator iterator2 = ((Iterable)relativeNameSequence).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Name name2 = (Name)iterator2.next();
            if (this.isSimpleNameAllowed(importFqName, name2)) {
                result2.add(CollectionsKt.joinToString$default((Iterable)relativeNameSequence.subList(i, relativeNameSequence.size()), (CharSequence)".", null, null, (int)0, null, JavaImportHelper::buildPossibleAnnotationText$lambda$0, (int)30, null));
            }
            importFqName = importFqName.child(name2);
        }
        return result2;
    }

    private final boolean isSimpleNameAllowed(FqName containerName, Name desiredSimpleName) {
        PsiImportStatement importStatement;
        PsiImportList psiImportList = this.psiJavaFile.getImportList();
        if (psiImportList == null) {
            return false;
        }
        PsiImportList importList = psiImportList;
        String containerNameString = containerName.asString();
        String string = desiredSimpleName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String simpleNameString = string;
        PsiImportStatement psiImportStatement = importList.findSingleClassImportStatement(containerNameString + "." + simpleNameString);
        if (psiImportStatement == null) {
            psiImportStatement = importList.findOnDemandImportStatement(containerNameString);
        }
        return (importStatement = psiImportStatement) != null;
    }

    private static final CharSequence buildPossibleAnnotationText$lambda$0(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }
}

