/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.dagger;

import com.android.tools.idea.dagger.DaggerRelatedItemLineMarkerProvider;
import com.android.tools.idea.dagger.concepts.DaggerElement;
import com.android.tools.idea.dagger.concepts.DaggerElementKt;
import com.android.tools.idea.dagger.localization.DaggerBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/dagger/GoToRelatedDaggerItemsAction;", "Lcom/intellij/openapi/editor/actionSystem/EditorAction;", "<init>", "()V", "Handler", "intellij.android.dagger"})
public final class GoToRelatedDaggerItemsAction
extends EditorAction {
    public GoToRelatedDaggerItemsAction() {
        super((EditorActionHandler)new Handler());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/dagger/GoToRelatedDaggerItemsAction$Handler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "()V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "getGotoItems", "", "Lcom/android/tools/idea/dagger/DaggerRelatedItemLineMarkerProvider$GotoItemWithAnalytics;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.dagger"})
    private static final class Handler
    extends EditorActionHandler {
        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Caret caret2 = editor.getCaretModel().getCurrentCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"getCurrentCaret(...)");
            List<DaggerRelatedItemLineMarkerProvider.GotoItemWithAnalytics> gotoItems = this.getGotoItems(caret2, project2);
            switch (gotoItems.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    ((DaggerRelatedItemLineMarkerProvider.GotoItemWithAnalytics)((Object)CollectionsKt.first(gotoItems))).navigate();
                    break;
                }
                default: {
                    NavigationUtil.getRelatedItemsPopup(gotoItems, (String)DaggerBundle.INSTANCE.message("dagger.related.items.popup.title", new String[0])).showInBestPositionFor(editor);
                }
            }
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            return true;
        }

        private final List<DaggerRelatedItemLineMarkerProvider.GotoItemWithAnalytics> getGotoItems(Caret $this$getGotoItems, Project project) {
            DaggerElement daggerElement;
            PsiElement psiElement;
            PsiElement psiElement2;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile($this$getGotoItems.getEditor().getDocument());
            List<DaggerRelatedItemLineMarkerProvider.GotoItemWithAnalytics> list2 = psiFile != null && (psiElement2 = psiFile.findElementAt($this$getGotoItems.getOffset())) != null && (psiElement = psiElement2.getParent()) != null && (daggerElement = DaggerElementKt.getDaggerElement(psiElement)) != null ? DaggerRelatedItemLineMarkerProvider.Companion.getGotoItems$intellij_android_dagger(daggerElement) : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }
    }
}

