/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.configurations.DeviceState;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.res.ResourceRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/configurations/ConfigurationForFile;", "Lcom/android/tools/configurations/Configuration;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/android/tools/idea/configurations/ConfigurationManager;", "editedConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/configurations/ConfigurationManager;Lcom/android/ide/common/resources/configuration/FolderConfiguration;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "calculateActivity", "", "computeBestDevice", "Lcom/android/sdklib/devices/Device;", "save", "", "clone", "getSettings", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nConfigurationForFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationForFile.kt\ncom/android/tools/idea/configurations/ConfigurationForFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class ConfigurationForFile
extends Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile file;
    @Nullable
    private PsiFile psiFile;

    public ConfigurationForFile(@NotNull VirtualFile file, @NotNull ConfigurationManager manager, @NotNull FolderConfiguration editedConfig) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)editedConfig, (String)"editedConfig");
        super(manager, editedConfig);
        this.file = file;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @Nullable
    protected String calculateActivity() {
        return (String)ApplicationManager.getApplication().runReadAction(() -> ConfigurationForFile.calculateActivity$lambda$0(this));
    }

    @Override
    @Nullable
    protected Device computeBestDevice() {
        for (Device device2 : this.mySettings.getRecentDevices()) {
            FolderConfiguration currentConfig;
            State selectedState;
            String string = this.getStateName();
            if (string == null) {
                string = device2.getDefaultState().getName();
            }
            String finalStateName = string;
            Intrinsics.checkNotNull((Object)DeviceState.getDeviceState(device2, finalStateName));
            Intrinsics.checkNotNullExpressionValue((Object)this.getSettings().getModule(), (String)"getModule(...)");
            if (Configuration.getFolderConfig(this.mySettings.getConfigModule(), selectedState, this.getLocale(), this.getTarget()) == null || !this.myEditedConfig.isMatchFor(currentConfig) || this.mySettings.getConfigModule().getResourceRepositoryManager() == null) continue;
            ResourceFolderType folderType = ResourceFilesUtil.getFolderType(this.file);
            if (folderType != null) {
                List<VirtualFile> matches;
                ResourceRepositoryManager repositoryManager;
                if (ResourceFolderType.VALUES == folderType) {
                    Module module;
                    LocalResourceManager resourceManager = LocalResourceManager.getInstance(module);
                    if (resourceManager == null) continue;
                    for (PsiFile resourceFile : resourceManager.findResourceFiles(ResourceNamespace.TODO(), ResourceFolderType.VALUES)) {
                        FolderConfiguration folderConfiguration;
                        PsiDirectory parent;
                        if (!Intrinsics.areEqual((Object)this.file, (Object)resourceFile.getVirtualFile()) || (parent = AndroidPsiUtils.getPsiDirectorySafely((PsiFile)resourceFile)) == null || !currentConfig.isMatchFor(folderConfiguration = FolderConfiguration.getConfigForFolder((String)parent.getName()))) continue;
                        return device2;
                    }
                    continue;
                }
                List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                Intrinsics.checkNotNull((Object)types);
                if (!(!((Collection)types).isEmpty())) continue;
                ResourceType type = (ResourceType)types.get(0);
                ResourceRepository resources = repositoryManager.getAppResources();
                Intrinsics.checkNotNullExpressionValue(ConfigurationMatcher.getMatchingFiles(resources, this.file, ResourceNamespace.TODO(), type, currentConfig), (String)"getMatchingFiles(...)");
                if (!matches.contains(this.file)) continue;
                return device2;
            }
            if (Intrinsics.areEqual((Object)"Kotlin", (Object)this.file.getFileType().getName())) {
                return device2;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)this.getSettings().getProject().getProjectFile())) continue;
            return device2;
        }
        return super.computeBestDevice();
    }

    @Override
    public void save() {
        ConfigurationFileState fileState = new ConfigurationFileState();
        fileState.saveState(this);
        this.getSettings().getStateManager().setConfigurationState(this.file, fileState);
    }

    @Override
    @NotNull
    public ConfigurationForFile clone() {
        ConfigurationForFile configurationForFile;
        ConfigurationManager configurationManager = this.getSettings();
        FolderConfiguration folderConfiguration = FolderConfiguration.copyOf((FolderConfiguration)this.getEditedConfig());
        Intrinsics.checkNotNullExpressionValue((Object)folderConfiguration, (String)"copyOf(...)");
        ConfigurationForFile it = configurationForFile = new ConfigurationForFile(this.file, configurationManager, folderConfiguration);
        boolean bl = false;
        it.copyFrom(this);
        return configurationForFile;
    }

    @Override
    @NotNull
    public ConfigurationManager getSettings() {
        ConfigurationSettings configurationSettings = this.mySettings;
        Intrinsics.checkNotNull((Object)configurationSettings, (String)"null cannot be cast to non-null type com.android.tools.idea.configurations.ConfigurationManager");
        return (ConfigurationManager)configurationSettings;
    }

    private static final String calculateActivity$lambda$0(ConfigurationForFile this$0) {
        PsiFile psiFile;
        XmlFile psiXmlFile;
        XmlFile xmlFile;
        if (this$0.psiFile == null) {
            this$0.psiFile = PsiManager.getInstance((Project)this$0.getSettings().getProject()).findFile(this$0.file);
        }
        return (xmlFile = (psiXmlFile = (psiFile = this$0.psiFile) instanceof XmlFile ? (XmlFile)psiFile : null)) != null && (xmlFile = xmlFile.getRootTag()) != null && (xmlFile = xmlFile.getAttribute("context", "http://schemas.android.com/tools")) != null ? xmlFile.getValue() : null;
    }

    @JvmStatic
    @NotNull
    public static final ConfigurationForFile create(@NotNull ConfigurationManager manager, @NotNull VirtualFile file, @Nullable ConfigurationFileState fileState, @NotNull FolderConfiguration editedConfig) {
        return Companion.create(manager, file, fileState, editedConfig);
    }

    @JvmStatic
    @NotNull
    public static final ConfigurationForFile create(@NotNull ConfigurationForFile base, @NotNull VirtualFile file) {
        return Companion.create(base, file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/configurations/ConfigurationForFile$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/idea/configurations/ConfigurationForFile;", "manager", "Lcom/android/tools/idea/configurations/ConfigurationManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileState", "Lcom/android/tools/idea/configurations/ConfigurationFileState;", "editedConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "base", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ConfigurationForFile create(@NotNull ConfigurationManager manager, @NotNull VirtualFile file, @Nullable ConfigurationFileState fileState, @NotNull FolderConfiguration editedConfig) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editedConfig, (String)"editedConfig");
            ConfigurationForFile configuration2 = new ConfigurationForFile(file, manager, editedConfig);
            configuration2.startBulkEditing();
            ConfigurationFileState configurationFileState = fileState;
            if (configurationFileState != null) {
                configurationFileState.loadState(configuration2);
            }
            configuration2.finishBulkEditing();
            return configuration2;
        }

        @JvmStatic
        @NotNull
        public final ConfigurationForFile create(@NotNull ConfigurationForFile base, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ConfigurationManager configurationManager = base.getSettings();
            FolderConfiguration folderConfiguration = FolderConfiguration.copyOf((FolderConfiguration)base.getEditedConfig());
            Intrinsics.checkNotNullExpressionValue((Object)folderConfiguration, (String)"copyOf(...)");
            ConfigurationForFile configuration2 = new ConfigurationForFile(file, configurationManager, folderConfiguration);
            configuration2.copyFrom(base);
            configuration2.getEditedConfig().set(FolderConfiguration.getConfigForFolder((String)file.getParent().getName()));
            ConfigurationMatcher matcher = new ConfigurationMatcher(configuration2, file);
            matcher.adaptConfigSelection(true);
            return configuration2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

