/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.google.common.base.Strings;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="config")
public class ConfigurationFileState {
    @Nullable
    private String myDeviceState;
    @Nullable
    private String myDockMode;
    @Nullable
    private String myNightMode;
    @Nullable
    private String myTheme;

    @Tag(value="state")
    @Nullable
    public String getDeviceState() {
        return this.myDeviceState;
    }

    public void setDeviceState(@Nullable String deviceState2) {
        this.myDeviceState = deviceState2;
    }

    @Tag(value="dock")
    @Nullable
    public String getDockMode() {
        return this.myDockMode;
    }

    public void setDockMode(@Nullable String dockMode) {
        this.myDockMode = dockMode;
    }

    @Tag(value="night")
    @Nullable
    public String getNightMode() {
        return this.myNightMode;
    }

    public void setNightMode(@Nullable String nightMode) {
        this.myNightMode = nightMode;
    }

    @Tag(value="theme")
    @Nullable
    public String getTheme() {
        return this.myTheme;
    }

    public void setTheme(@Nullable String theme) {
        this.myTheme = theme;
    }

    public void saveState(@NotNull Configuration configuration2) {
        State deviceState2;
        Device device2 = configuration2.getDevice();
        this.myDeviceState = null;
        if (device2 != null && (deviceState2 = configuration2.getDeviceState()) != null && deviceState2 != device2.getDefaultState()) {
            this.myDeviceState = deviceState2.getName();
        }
        UiMode dockMode = configuration2.getUiMode();
        this.myDockMode = Strings.emptyToNull((String)dockMode.getResourceValue());
        NightMode nightMode = configuration2.getNightMode();
        this.myNightMode = nightMode != NightMode.NOTNIGHT ? nightMode.getResourceValue() : null;
        this.myTheme = Strings.emptyToNull((String)configuration2.getTheme());
    }

    public void loadState(@NotNull Configuration configuration2) {
        NightMode nightMode;
        UiMode dockMode;
        configuration2.startBulkEditing();
        configuration2.setDeviceStateName(this.myDeviceState);
        if (this.myDockMode != null && (dockMode = UiMode.getEnum((String)this.myDockMode)) != null) {
            configuration2.setUiMode(dockMode);
        }
        if (this.myNightMode != null && (nightMode = NightMode.getEnum((String)this.myNightMode)) != null) {
            configuration2.setNightMode(nightMode);
        }
        if (this.myTheme != null) {
            configuration2.setTheme(this.myTheme);
        }
        configuration2.finishBulkEditing();
    }
}

