/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J#\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\u0010\u0011R$\u0010\u0004\u001a\u0018\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/codenavigation/TraceSignatureConverter;", "", "<init>", "()V", "primitiveTypes", "", "Lcom/intellij/psi/PsiPrimitiveType;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "convertToString", "psiType", "Lcom/intellij/psi/PsiType;", "getTraceSignature", "returnType", "parameterTypes", "", "(Lcom/intellij/psi/PsiType;[Lcom/intellij/psi/PsiType;)Ljava/lang/String;", "codenavigation"})
public final class TraceSignatureConverter {
    @NotNull
    public static final TraceSignatureConverter INSTANCE = new TraceSignatureConverter();
    @NotNull
    private static final Map<PsiPrimitiveType, String> primitiveTypes;

    private TraceSignatureConverter() {
    }

    @VisibleForTesting
    @NotNull
    public final String convertToString(@NotNull PsiType psiType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        PsiType type = TypeConversionUtil.erasure((PsiType)psiType);
        if (type instanceof PsiArrayType) {
            PsiType psiType2 = ((PsiArrayType)type).getComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getComponentType(...)");
            object = "[" + this.convertToString(psiType2);
        } else if (type instanceof PsiPrimitiveType) {
            object = primitiveTypes.getOrDefault(type, "");
        } else if (type instanceof PsiClassType) {
            String string = ((PsiClassType)type).getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            object = "L" + StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null) + ";";
        } else {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getTraceSignature(@Nullable PsiType returnType, @NotNull PsiType[] parameterTypes) {
        Intrinsics.checkNotNullParameter((Object)parameterTypes, (String)"parameterTypes");
        return returnType == null ? "(" + ArraysKt.joinToString$default((Object[])parameterTypes, (CharSequence)"", null, null, (int)0, null, TraceSignatureConverter::getTraceSignature$lambda$0, (int)30, null) + ")" : "(" + ArraysKt.joinToString$default((Object[])parameterTypes, (CharSequence)"", null, null, (int)0, null, TraceSignatureConverter::getTraceSignature$lambda$1, (int)30, null) + ")" + this.convertToString(returnType);
    }

    private static final CharSequence getTraceSignature$lambda$0(PsiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.convertToString(it);
    }

    private static final CharSequence getTraceSignature$lambda$1(PsiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.convertToString(it);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PsiTypes.byteType(), (Object)"B"), TuplesKt.to((Object)PsiTypes.charType(), (Object)"C"), TuplesKt.to((Object)PsiTypes.doubleType(), (Object)"D"), TuplesKt.to((Object)PsiTypes.floatType(), (Object)"F"), TuplesKt.to((Object)PsiTypes.intType(), (Object)"I"), TuplesKt.to((Object)PsiTypes.longType(), (Object)"J"), TuplesKt.to((Object)PsiTypes.shortType(), (Object)"S"), TuplesKt.to((Object)PsiTypes.booleanType(), (Object)"Z"), TuplesKt.to((Object)PsiTypes.voidType(), (Object)"V")};
        primitiveTypes = MapsKt.mapOf((Pair[])pairArray);
    }
}

