/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DeviceProfileTags {
    private static final List<IdDisplay> ALL_DEVICE_TAGS = ImmutableList.of((Object)SystemImageTags.DEFAULT_TAG, (Object)SystemImageTags.WEAR_TAG, (Object)SystemImageTags.DESKTOP_TAG, (Object)SystemImageTags.ANDROID_TV_TAG, (Object)SystemImageTags.GOOGLE_TV_TAG, (Object)SystemImageTags.AUTOMOTIVE_TAG, (Object)SystemImageTags.AUTOMOTIVE_DISTANT_DISPLAY_TAG, (Object)SystemImageTags.XR_HEADSET_TAG, (Object)SystemImageTags.AI_GLASSES_TAG);

    public static List<IdDisplay> availableDeviceTags() {
        return ALL_DEVICE_TAGS.stream().filter(tag -> !((Boolean)StudioFlags.AI_GLASSES_DEVICE_SUPPORT_ENABLED.get() == false && tag == SystemImageTags.AI_GLASSES_TAG || (Boolean)StudioFlags.XR_DEVICE_SUPPORT_ENABLED.get() == false && tag == SystemImageTags.XR_HEADSET_TAG)).toList();
    }

    public static IdDisplay canonicalizeTag(@Nullable String tagId) {
        if (tagId != null) {
            if (tagId.equals(SystemImageTags.AUTOMOTIVE_PLAY_STORE_TAG.getId())) {
                return SystemImageTags.AUTOMOTIVE_TAG;
            }
            if (tagId.equals(SystemImageTags.DEPRECATED_AI_GLASSES_TAG.getId())) {
                return SystemImageTags.AI_GLASSES_TAG;
            }
            for (IdDisplay tag : ALL_DEVICE_TAGS) {
                if (!tag.getId().equals(tagId)) continue;
                return tag;
            }
        }
        return SystemImageTags.DEFAULT_TAG;
    }
}

