/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.avdmanager.SkinUtils;
import com.android.tools.idea.observable.core.ObservableBool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class CustomSkinValidator
implements Validator<Optional<Path>> {
    @NotNull
    private final ObservableBool mySelectedSkinLargeEnough;
    @NotNull
    private final ObservableBool myEnableDeviceFrame;

    private CustomSkinValidator(@NotNull Builder builder) {
        this.mySelectedSkinLargeEnough = builder.mySelectedSkinLargeEnough;
        this.myEnableDeviceFrame = builder.myEnableDeviceFrame;
    }

    @NotNull
    public Validator.Result validate(@NotNull @NotNull Optional<@NotNull Path> optionalCustomSkin) {
        if (!((Boolean)this.myEnableDeviceFrame.get()).booleanValue()) {
            return Validator.Result.OK;
        }
        if (optionalCustomSkin.isEmpty()) {
            return Validator.Result.OK;
        }
        Path customSkin = optionalCustomSkin.get();
        if (customSkin.equals(SkinUtils.noSkin())) {
            return Validator.Result.OK;
        }
        if (!((Boolean)this.mySelectedSkinLargeEnough.get()).booleanValue()) {
            return new Validator.Result(Validator.Severity.WARNING, "The selected skin is not large enough to view the entire screen.");
        }
        Path layout = customSkin.resolve("layout");
        if (!Files.isRegularFile(layout, new LinkOption[0]) && !Files.isRegularFile(layout = customSkin.resolve("default").resolve("layout"), new LinkOption[0])) {
            return new Validator.Result(Validator.Severity.ERROR, "The skin directory does not point to a valid skin.");
        }
        return Validator.Result.OK;
    }

    static final class Builder {
        private ObservableBool mySelectedSkinLargeEnough;
        @NotNull
        private ObservableBool myEnableDeviceFrame = ObservableBool.TRUE;

        Builder() {
        }

        @NotNull
        Builder setSelectedSkinLargeEnough(@NotNull ObservableBool selectedSkinLargeEnough) {
            this.mySelectedSkinLargeEnough = selectedSkinLargeEnough;
            return this;
        }

        @NotNull
        Builder setEnableDeviceFrame(@NotNull ObservableBool enableDeviceFrame) {
            this.myEnableDeviceFrame = enableDeviceFrame;
            return this;
        }

        @NotNull
        CustomSkinValidator build() {
            return new CustomSkinValidator(this);
        }
    }
}

