/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.resources.Navigation;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.adtui.TooltipLabel;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.avdmanager.skincombobox.SkinCollector;
import com.android.tools.idea.avdmanager.skincombobox.SkinComboBox;
import com.android.tools.idea.avdmanager.ui.AvdDeviceData;
import com.android.tools.idea.avdmanager.ui.ConfigureDeviceModel;
import com.android.tools.idea.avdmanager.ui.CustomSkinValidator;
import com.android.tools.idea.avdmanager.ui.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.ui.DeviceProfileTags;
import com.android.tools.idea.avdmanager.ui.SkinComboBoxProperty;
import com.android.tools.idea.avdmanager.ui.StorageField;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.adapters.StringToDoubleAdapterProperty;
import com.android.tools.idea.observable.adapters.StringToIntAdapterProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.deprecated.StudioWizardStepPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class ConfigureDeviceOptionsStep
extends ModelWizardStep<ConfigureDeviceModel> {
    private static final String DEFAULT_DEVICE_TYPE_LABEL = "Phone/Tablet";
    private static final String CREATE_SKIN_HELP_LINK = "http://developer.android.com/tools/devices/managing-avds.html#skins";
    private JPanel myRootPanel;
    private DeviceDefinitionPreview myDeviceDefinitionPreview;
    private JCheckBox myHasBackFacingCamera;
    private JCheckBox myHasFrontFacingCamera;
    private JCheckBox myHasAccelerometer;
    private JCheckBox myHasGyroscope;
    private JCheckBox myHasGps;
    private JCheckBox myHasProximitySensor;
    private JCheckBox mySupportsLandscape;
    private JCheckBox mySupportsPortrait;
    private JCheckBox myHasHardwareKeyboard;
    private JCheckBox myHasHardwareButtons;
    private JTextField myDeviceName;
    private JTextField myScreenResolutionWidth;
    private JTextField myScreenResolutionHeight;
    @NotNull
    private SkinComboBox myCustomSkinPath;
    private BrowserLink myHardwareSkinHelpLabel;
    private ComboBox<IdDisplay> myDeviceTypeComboBox;
    private JTextField myDiagonalScreenSize;
    private StorageField myRamField;
    private JComboBox<Navigation> myNavigationControlsCombo;
    private TooltipLabel myHelpAndErrorLabel;
    private JCheckBox myIsScreenRound;
    private JBScrollPane myScrollPane;
    private StringToDoubleAdapterProperty myDiagonalScreenSizeAdapter;
    private StringToIntAdapterProperty myScreenResWidthAdapter;
    private StringToIntAdapterProperty myScreenResHeightAdapter;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings = new BindingsManager();
    private final ListenerManager myListeners = new ListenerManager();

    public ConfigureDeviceOptionsStep(@NotNull ConfigureDeviceModel model) {
        super(model, "Configure Hardware Profile");
        this.setupUI();
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, "Configure this hardware profile");
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        this.myDeviceTypeComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(new ArrayList<IdDisplay>(DeviceProfileTags.availableDeviceTags())));
        this.myDeviceTypeComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DEFAULT_DEVICE_TYPE_LABEL, value2 -> SystemImageTags.DEFAULT_TAG.equals(value2) ? DEFAULT_DEVICE_TYPE_LABEL : value2.getDisplay()));
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myHelpAndErrorLabel.setBackground(JBColor.background());
        this.myHelpAndErrorLabel.setForeground(JBColor.foreground());
        this.myHelpAndErrorLabel.setBorder(BorderFactory.createEmptyBorder(15, 15, 10, 10));
        this.myDiagonalScreenSizeAdapter = new StringToDoubleAdapterProperty(new TextProperty(this.myDiagonalScreenSize), 1, 2);
        this.myScreenResWidthAdapter = new StringToIntAdapterProperty(new TextProperty(this.myScreenResolutionWidth));
        this.myScreenResHeightAdapter = new StringToIntAdapterProperty(new TextProperty(this.myScreenResolutionHeight));
        this.attachBindingsAndValidators();
    }

    @Override
    protected void onEntering() {
        AvdDeviceData deviceModel = ((ConfigureDeviceModel)this.getModel()).getDeviceData();
        this.myDiagonalScreenSizeAdapter.set(deviceModel.diagonalScreenSize());
        this.myScreenResWidthAdapter.set(deviceModel.screenResolutionWidth());
        this.myScreenResHeightAdapter.set(deviceModel.screenResolutionHeight());
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    private void isScreenRoundChanged(boolean isRound) {
        this.myScreenResolutionHeight.setEnabled(!isRound);
        if (isRound) {
            this.myScreenResHeightAdapter.set((Integer)this.myScreenResWidthAdapter.get());
            this.myListeners.listen(this.myScreenResWidthAdapter, width -> this.myScreenResHeightAdapter.set(width));
        } else {
            this.myListeners.release(this.myScreenResWidthAdapter);
        }
    }

    private void attachBindingsAndValidators() {
        AvdDeviceData device2 = ((ConfigureDeviceModel)this.getModel()).getDeviceData();
        this.myBindings.bindTwoWay(new TextProperty(this.myDeviceName), device2.name());
        this.myBindings.bind(device2.diagonalScreenSize(), this.myDiagonalScreenSizeAdapter);
        this.myBindings.bind(device2.screenResolutionWidth(), this.myScreenResWidthAdapter);
        this.myBindings.bind(device2.screenResolutionHeight(), this.myScreenResHeightAdapter);
        this.myBindings.bindTwoWay(this.myRamField.storage(), device2.ramStorage());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasHardwareButtons), device2.hasHardwareButtons());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasHardwareKeyboard), device2.hasHardwareKeyboard());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myNavigationControlsCombo), device2.navigation());
        this.myBindings.bindTwoWay(new SelectedProperty(this.mySupportsLandscape), device2.supportsLandscape());
        this.myBindings.bindTwoWay(new SelectedProperty(this.mySupportsPortrait), device2.supportsPortrait());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasBackFacingCamera), device2.hasBackCamera());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasFrontFacingCamera), device2.hasFrontCamera());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasAccelerometer), device2.hasAccelerometer());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasGyroscope), device2.hasGyroscope());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasGps), device2.hasGps());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myHasProximitySensor), device2.hasProximitySensor());
        this.myBindings.bindTwoWay(new SkinComboBoxProperty(this.myCustomSkinPath), device2.customSkinFile());
        SelectedProperty isScreenRound = new SelectedProperty(this.myIsScreenRound);
        this.myBindings.bindTwoWay(isScreenRound, device2.isScreenRound());
        this.myListeners.listen(isScreenRound, this::isScreenRoundChanged);
        SelectedItemProperty selectedDeviceType = new SelectedItemProperty((JComboBox)this.myDeviceTypeComboBox);
        this.myBindings.bindTwoWay(selectedDeviceType, device2.deviceType());
        this.myListeners.listen(selectedDeviceType, idDisplayOptional -> {
            if (idDisplayOptional.isPresent()) {
                List<IdDisplay> deviceTag = Collections.singletonList((IdDisplay)idDisplayOptional.get());
                boolean isWear = SystemImageTags.isWearImage(deviceTag);
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isWear().set(isWear);
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isAutomotive().set(SystemImageTags.isAutomotiveImage(deviceTag));
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isTv().set(SystemImageTags.isTvImage(deviceTag));
                ((ConfigureDeviceModel)this.getModel()).getDeviceData().isDesktop().set(SystemImageTags.isDesktopImage(deviceTag));
                this.myIsScreenRound.setEnabled(isWear);
                boolean isRound = (Boolean)((ConfigureDeviceModel)this.getModel()).getDeviceData().isScreenRound().get();
                this.myIsScreenRound.setSelected(isRound);
                this.isScreenRoundChanged(isWear && isRound);
            }
        });
        this.myValidatorPanel.registerTest((ObservableValue)device2.name().trim().isEmpty().not(), "Please write a name for the new device.");
        this.myValidatorPanel.registerTest((ObservableValue)this.myDiagonalScreenSizeAdapter.inSync().and(device2.diagonalScreenSize().isEqualTo(this.myDiagonalScreenSizeAdapter)), "Please enter a non-zero positive floating point value for the screen size.");
        this.myValidatorPanel.registerTest((ObservableValue)this.myScreenResWidthAdapter.inSync().and(device2.screenResolutionWidth().isEqualTo(this.myScreenResWidthAdapter)), "Please enter a valid value for the screen width.");
        this.myValidatorPanel.registerTest((ObservableValue)this.myScreenResHeightAdapter.inSync().and(device2.screenResolutionHeight().isEqualTo(this.myScreenResHeightAdapter)), "Please enter a valid value for the screen height.");
        this.myValidatorPanel.registerValidator(device2.ramStorage(), value2 -> value2.getSize() > 0L ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, "Please specify a non-zero amount of RAM."), new ObservableValue[0]);
        this.myValidatorPanel.registerTest((ObservableValue)device2.screenDpi().isGreaterThan(0.0), "The given resolution and screen size specified have a DPI that is too low.");
        this.myValidatorPanel.registerTest((ObservableValue)device2.supportsLandscape().or(device2.supportsPortrait()), "A device must support at least one orientation (Portrait or Landscape).");
        ObservableBool selectedSkinLargeEnough = device2.compatibleSkinSize();
        CustomSkinValidator validator = new CustomSkinValidator.Builder().setSelectedSkinLargeEnough(selectedSkinLargeEnough).build();
        this.myValidatorPanel.registerValidator(device2.customSkinFile(), (Validator)validator, new ObservableValue[]{selectedSkinLargeEnough});
    }

    private void createUIComponents() {
        this.myNavigationControlsCombo = new ComboBox((ComboBoxModel)new EnumComboBoxModel(Navigation.class));
        this.myNavigationControlsCombo.setRenderer((ListCellRenderer<Navigation>)SimpleListCellRenderer.create((String)"", Navigation::getShortDisplayValue));
        this.myHardwareSkinHelpLabel = new BrowserLink("How do I create a custom hardware skin?", CREATE_SKIN_HELP_LINK);
        this.createDefaultSkinComboBox();
        this.myDeviceDefinitionPreview = new DeviceDefinitionPreview(((ConfigureDeviceModel)this.getModel()).getDeviceData());
    }

    private void createDefaultSkinComboBox() {
        this.myCustomSkinPath = new SkinComboBox(null, SkinCollector::getFilenamesAndCollect);
        JBDimension size = new JBDimension(170, 30);
        this.myCustomSkinPath.setMinimumSize((Dimension)size);
        this.myCustomSkinPath.setPreferredSize((Dimension)size);
        this.myCustomSkinPath.load();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0));
        this.myRootPanel.setMaximumSize(new Dimension(1280, 768));
        this.myRootPanel.add((Component)this.myDeviceDefinitionPreview, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(360, -1), null, 0, false));
        this.myScrollPane = new JBScrollPane();
        this.myRootPanel.add((Component)this.myScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(28, 2, new Insets(5, 5, 5, 5), -1, 5));
        this.myScrollPane.setViewportView((Component)panel1);
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Screen");
        panel1.add((Component)jBLabel1, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Memory");
        panel1.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Cameras");
        panel1.add((Component)jBLabel3, new GridConstraints(17, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Sensors");
        panel1.add((Component)jBLabel4, new GridConstraints(20, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myHasBackFacingCamera = new JCheckBox();
        this.myHasBackFacingCamera.setSelected(true);
        this.myHasBackFacingCamera.setText("Back-facing camera");
        this.myHasBackFacingCamera.setToolTipText("<html>Enables back-facing camera support in emulator</html>");
        panel1.add((Component)this.myHasBackFacingCamera, new GridConstraints(17, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHasFrontFacingCamera = new JCheckBox();
        this.myHasFrontFacingCamera.setSelected(true);
        this.myHasFrontFacingCamera.setText("Front-facing camera");
        this.myHasFrontFacingCamera.setToolTipText("<html>Enables front-facing camera support in emulator</html>");
        panel1.add((Component)this.myHasFrontFacingCamera, new GridConstraints(18, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHasAccelerometer = new JCheckBox();
        this.myHasAccelerometer.setSelected(true);
        this.myHasAccelerometer.setText("Accelerometer");
        this.myHasAccelerometer.setToolTipText("<html>Enables accelerometer support in emulator.</html>");
        panel1.add((Component)this.myHasAccelerometer, new GridConstraints(20, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHasGyroscope = new JCheckBox();
        this.myHasGyroscope.setSelected(true);
        this.myHasGyroscope.setText("Gyroscope");
        this.myHasGyroscope.setToolTipText("<html>Enables gyroscope support in emulator.</html>");
        panel1.add((Component)this.myHasGyroscope, new GridConstraints(21, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHasGps = new JCheckBox();
        this.myHasGps.setSelected(true);
        this.myHasGps.setText("GPS");
        this.myHasGps.setToolTipText("<html>Enables GPS (global positioning support) support in emulator.</html>");
        panel1.add((Component)this.myHasGps, new GridConstraints(22, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHasProximitySensor = new JCheckBox();
        this.myHasProximitySensor.setSelected(true);
        this.myHasProximitySensor.setText("Proximity Sensor");
        this.myHasProximitySensor.setToolTipText("<html>Enables proximity sensor support in emulator</html>");
        panel1.add((Component)this.myHasProximitySensor, new GridConstraints(23, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.mySupportsLandscape = new JCheckBox();
        this.mySupportsLandscape.setSelected(true);
        this.mySupportsLandscape.setText("Landscape");
        this.mySupportsLandscape.setToolTipText("<html>Enables the landscape device screen state in emulator</html>");
        panel1.add((Component)this.mySupportsLandscape, new GridConstraints(15, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.mySupportsPortrait = new JCheckBox();
        this.mySupportsPortrait.setSelected(true);
        this.mySupportsPortrait.setText("Portrait");
        this.mySupportsPortrait.setToolTipText("<html>Enables the portrait device screen state in emulator.</html>");
        panel1.add((Component)this.mySupportsPortrait, new GridConstraints(14, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("<html>Supported<br>device states</html>");
        panel1.add((Component)jBLabel5, new GridConstraints(14, 0, 2, 1, 9, 0, 0, 0, null, null, null, 0, false));
        this.myHasHardwareKeyboard = new JCheckBox();
        this.myHasHardwareKeyboard.setSelected(true);
        this.myHasHardwareKeyboard.setText("Has Hardware Keyboard");
        this.myHasHardwareKeyboard.setToolTipText("<html>Enables hardware keyboard  support in Android Virtual Device.</html>");
        panel1.add((Component)this.myHasHardwareKeyboard, new GridConstraints(11, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHasHardwareButtons = new JCheckBox();
        this.myHasHardwareButtons.setSelected(true);
        this.myHasHardwareButtons.setText("Has Hardware Buttons (Back/Home/Menu)");
        this.myHasHardwareButtons.setToolTipText("<html>Enables hardware navigation button support in Android Virtual Device</html>");
        panel1.add((Component)this.myHasHardwareButtons, new GridConstraints(10, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Input");
        panel1.add((Component)jBLabel6, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDeviceName = new JTextField();
        this.myDeviceName.setToolTipText("<html>Name of the Device Profile</html>");
        panel1.add((Component)this.myDeviceName, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Device Name");
        panel1.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(5, 1, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Resolution:");
        panel2.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.myScreenResolutionWidth = new JTextField();
        this.myScreenResolutionWidth.setColumns(5);
        this.myScreenResolutionWidth.setToolTipText("<html>The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.  Width in pixels </html>");
        panel2.add((Component)this.myScreenResolutionWidth, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("x");
        panel2.add((Component)jBLabel9, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.myScreenResolutionHeight = new JTextField();
        this.myScreenResolutionHeight.setColumns(5);
        this.myScreenResolutionHeight.setToolTipText("<html>The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.  Height in pixels </html>");
        panel2.add((Component)this.myScreenResolutionHeight, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("px");
        panel2.add((Component)jBLabel10, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(24, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 15), new Dimension(-1, 15), null, 0, false));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Default Skin");
        panel1.add((Component)jBLabel11, new GridConstraints(26, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCustomSkinPath.setToolTipText("<html>Path to a directory containing a custom skin</html>");
        panel1.add((Component)((Object)this.myCustomSkinPath), new GridConstraints(26, 1, 1, 1, 0, 1, 4, 0, null, null, null, 0, false));
        panel1.add((Component)this.myHardwareSkinHelpLabel, new GridConstraints(27, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("Device Type");
        panel1.add((Component)jBLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDeviceTypeComboBox = new ComboBox();
        panel1.add((Component)this.myDeviceTypeComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel3, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setText("inch");
        panel3.add((Component)jBLabel13, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.myDiagonalScreenSize = new JTextField();
        this.myDiagonalScreenSize.setColumns(10);
        this.myDiagonalScreenSize.setToolTipText("<html>Actual Android Virtual Device size of the screen, measured as the screen's diagonal</html>");
        panel3.add((Component)this.myDiagonalScreenSize, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setText("Screen size:");
        panel3.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel4, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel15 = new JBLabel();
        jBLabel15.setText("RAM:");
        panel4.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myRamField = new StorageField();
        this.myRamField.setToolTipText("<html>The amount of physical RAM on the device.</html>");
        panel4.add((Component)this.myRamField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 1, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel5, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel16 = new JBLabel();
        jBLabel16.setText("Navigation Style:");
        panel5.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myNavigationControlsCombo.setToolTipText("<html>No Navigation - No navigational controls  <br>Directional Pad - Enables direction pad support in emulator <br>Trackball - Enables trackball support in emulator <br>Wheel - Enables wheel support in emulator</html>");
        panel5.add(this.myNavigationControlsCombo, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null, 0, false));
        JSeparator separator1 = new JSeparator();
        panel1.add((Component)separator1, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator2 = new JSeparator();
        panel1.add((Component)separator2, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator3 = new JSeparator();
        panel1.add((Component)separator3, new GridConstraints(7, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator4 = new JSeparator();
        panel1.add((Component)separator4, new GridConstraints(9, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator5 = new JSeparator();
        panel1.add((Component)separator5, new GridConstraints(13, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator6 = new JSeparator();
        panel1.add((Component)separator6, new GridConstraints(16, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator7 = new JSeparator();
        panel1.add((Component)separator7, new GridConstraints(19, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        JSeparator separator8 = new JSeparator();
        panel1.add((Component)separator8, new GridConstraints(25, 0, 1, 2, 0, 1, 0, 5, null, null, null, 0, false));
        this.myIsScreenRound = new JCheckBox();
        this.myIsScreenRound.setEnabled(false);
        this.myIsScreenRound.setSelected(true);
        this.myIsScreenRound.setText("Round");
        this.myIsScreenRound.setToolTipText("<html>Useful for wear devices with screens that can be round</html>");
        panel1.add((Component)this.myIsScreenRound, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myHelpAndErrorLabel = new TooltipLabel();
        this.myHelpAndErrorLabel.setOpaque(true);
        this.myHelpAndErrorLabel.setVerticalTextPosition(1);
        this.myRootPanel.add((Component)this.myHelpAndErrorLabel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, new Dimension(-1, 100), new Dimension(360, 100), null, 0, false));
        jBLabel7.setLabelFor((Component)this.myDeviceName);
        jBLabel8.setLabelFor((Component)this.myScreenResolutionWidth);
        jBLabel9.setLabelFor((Component)this.myScreenResolutionHeight);
        jBLabel14.setLabelFor((Component)this.myDiagonalScreenSize);
        jBLabel16.setLabelFor(this.myNavigationControlsCombo);
    }
}

