/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.State;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.ui.AvdDeviceData;
import com.android.tools.idea.avdmanager.ui.AvdHardwareData;
import com.android.tools.idea.avdmanager.ui.DeviceUiAction;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureDeviceModel
extends WizardModel {
    private final DeviceUiAction.DeviceProvider myProvider;
    private final BindingsManager myBindings = new BindingsManager();
    private final Device.Builder myBuilder = new Device.Builder();
    private final AvdDeviceData myDeviceData;

    public ConfigureDeviceModel(@NotNull DeviceUiAction.DeviceProvider provider) {
        this(provider, null, false);
    }

    public ConfigureDeviceModel(@NotNull DeviceUiAction.DeviceProvider provider, @Nullable Device device2, boolean cloneDevice) {
        this.myProvider = provider;
        this.myDeviceData = new AvdDeviceData(device2, null);
        if (cloneDevice) {
            if (device2 == null) {
                throw new IllegalArgumentException("Can't clone a device without specifying a device.");
            }
            this.myDeviceData.prepareForClone(String.format("%s (Edited)", device2.getDisplayName()));
        }
        if (device2 != null) {
            this.initBootProperties(device2);
        }
    }

    @Nullable
    private static State createState(ScreenOrientation orientation, Hardware hardware, boolean hasHardwareKeyboard) {
        State state2 = null;
        Object name2 = "";
        Object description2 = "";
        if (orientation == ScreenOrientation.LANDSCAPE) {
            name2 = "Landscape";
            description2 = "The device in landscape orientation";
            state2 = new State();
        } else if (orientation == ScreenOrientation.PORTRAIT) {
            name2 = "Portrait";
            description2 = "The device in portrait orientation";
            state2 = new State();
        }
        if (state2 != null) {
            if (hasHardwareKeyboard) {
                name2 = (String)name2 + " with keyboard";
                description2 = (String)description2 + " with a keyboard open";
                state2.setKeyState(KeyboardState.EXPOSED);
            } else if (hardware.getKeyboard() != null && hardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                state2.setKeyState(KeyboardState.SOFT);
            } else {
                state2.setKeyState(KeyboardState.HIDDEN);
            }
            state2.setName((String)name2);
            state2.setHardware(hardware);
            state2.setOrientation(orientation);
            state2.setDescription((String)description2);
            state2.setNavState(hardware.getNav().equals((Object)Navigation.NONAV) ? NavigationState.HIDDEN : NavigationState.EXPOSED);
        }
        return state2;
    }

    @Nullable
    public Project getProject() {
        return this.myProvider.getProject();
    }

    public AvdDeviceData getDeviceData() {
        return this.myDeviceData;
    }

    private void initBootProperties(@NotNull Device device2) {
        for (Map.Entry entry : device2.getBootProps().entrySet()) {
            this.myBuilder.addBootProp((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    protected void handleFinished() {
        DeviceManagerConnection connection2 = DeviceManagerConnection.getDefaultDeviceManagerConnection();
        String uniqueId2 = connection2.getUniqueId((String)this.myDeviceData.name().get());
        Device device2 = this.buildDevice(uniqueId2);
        connection2.createOrEditDevice(device2);
        this.myProvider.refreshDevices();
        this.myProvider.setDevice(device2);
    }

    @NotNull
    private Device buildDevice(String uniqueId2) {
        String deviceName = (String)this.myDeviceData.name().get();
        String deviceId = (String)this.myDeviceData.deviceId().get();
        if (deviceId.isEmpty()) {
            deviceId = uniqueId2;
        }
        this.myBuilder.setName(deviceName);
        this.myBuilder.setId(deviceId);
        this.myBuilder.addSoftware(this.myDeviceData.software().getValue());
        this.myBuilder.setManufacturer((String)this.myDeviceData.manufacturer().get());
        IdDisplay tag = this.myDeviceData.deviceType().getValueOrNull();
        this.myBuilder.setTagId(SystemImageTags.DEFAULT_TAG.equals((Object)tag) || tag == null ? null : tag.getId());
        List<State> states = this.generateStates(new AvdHardwareData(this.myDeviceData).buildHardware());
        this.myBuilder.addAllState(states);
        return this.myBuilder.build();
    }

    private List<State> generateStates(Hardware hardware) {
        ArrayList states = Lists.newArrayListWithExpectedSize((int)4);
        if (((Boolean)this.myDeviceData.supportsPortrait().get()).booleanValue()) {
            states.add(ConfigureDeviceModel.createState(ScreenOrientation.PORTRAIT, hardware, false));
        }
        if (((Boolean)this.myDeviceData.supportsLandscape().get()).booleanValue()) {
            states.add(ConfigureDeviceModel.createState(ScreenOrientation.LANDSCAPE, hardware, false));
        }
        if (((Boolean)this.myDeviceData.hasHardwareKeyboard().get()).booleanValue()) {
            if (((Boolean)this.myDeviceData.supportsPortrait().get()).booleanValue()) {
                states.add(ConfigureDeviceModel.createState(ScreenOrientation.PORTRAIT, hardware, true));
            }
            if (((Boolean)this.myDeviceData.supportsLandscape().get()).booleanValue()) {
                states.add(ConfigureDeviceModel.createState(ScreenOrientation.LANDSCAPE, hardware, true));
            }
        }
        ((State)states.get(0)).setDefaultState(true);
        return states;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }
}

