/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.devices.Device;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

enum Category {
    PHONE("Phone", "pixel_fold", definition -> !definition.getIsDeprecated() && Device.isPhone((Device)definition)),
    TABLET("Tablet", "pixel_tablet", definition -> !definition.getIsDeprecated() && Device.isTablet((Device)definition)),
    WEAR_OS("Wear OS", "wearos_large_round", definition -> !definition.getIsDeprecated() && Device.isWear((Device)definition)),
    DESKTOP("Desktop", "desktop_medium", definition -> !definition.getIsDeprecated() && Device.isDesktop((Device)definition)),
    TV("TV", "tv_1080p", definition -> !definition.getIsDeprecated() && Device.isTv((Device)definition)),
    AUTOMOTIVE("Automotive", "automotive_1024p_landscape", definition -> !definition.getIsDeprecated() && Device.isAutomotive((Device)definition)),
    XR("XR", "xr_headset_device", definition -> Device.isXr((Device)definition)),
    LEGACY("Legacy", "Nexus S", Device::getIsDeprecated);

    @NotNull
    private final String myName;
    @NotNull
    private final String myDefaultDefinitionId;
    @NotNull
    private final Predicate<Device> myPredicate;

    private Category(@NotNull String name2, String defaultDefinitionId, Predicate<Device> predicate) {
        this.myName = name2;
        this.myDefaultDefinitionId = defaultDefinitionId;
        this.myPredicate = predicate;
    }

    @NotNull
    final String getDefaultDefinitionId() {
        return this.myDefaultDefinitionId;
    }

    @NotNull
    static Category valueOfDefinition(@NotNull Device definition) {
        return Arrays.stream(Category.values()).filter(category -> category.myPredicate.test(definition)).findFirst().orElse(PHONE);
    }

    @NotNull
    public String toString() {
        return this.myName;
    }
}

