/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.emulatorcommand;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.BootMode;
import com.android.sdklib.internal.avd.QuickBoot;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilderKt;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.execution.configurations.GeneralCommandLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010&\u001a\u00020'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lcom/android/tools/idea/avdmanager/emulatorcommand/EmulatorCommandBuilder;", "", "emulator", "Ljava/nio/file/Path;", "avd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "<init>", "(Ljava/nio/file/Path;Lcom/android/sdklib/internal/avd/AvdInfo;)V", "getAvd", "()Lcom/android/sdklib/internal/avd/AvdInfo;", "avdHome", "getAvdHome", "()Ljava/nio/file/Path;", "setAvdHome", "(Ljava/nio/file/Path;)V", "sdkLocation", "getSdkLocation", "setSdkLocation", "studioParams", "getStudioParams", "setStudioParams", "launchInToolWindow", "", "getLaunchInToolWindow", "()Z", "setLaunchInToolWindow", "(Z)V", "bootMode", "Lcom/android/sdklib/internal/avd/BootMode;", "getBootMode", "()Lcom/android/sdklib/internal/avd/BootMode;", "setBootMode", "(Lcom/android/sdklib/internal/avd/BootMode;)V", "studioEmuParams", "", "", "getStudioEmuParams", "()Ljava/util/List;", "build", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.android.core"})
public final class EmulatorCommandBuilder {
    @NotNull
    private final AvdInfo avd;
    @NotNull
    private final Path emulator;
    @Nullable
    private Path avdHome;
    @Nullable
    private Path sdkLocation;
    @Nullable
    private Path studioParams;
    private boolean launchInToolWindow;
    @NotNull
    private BootMode bootMode;
    @NotNull
    private final List<String> studioEmuParams;

    public EmulatorCommandBuilder(@NotNull Path emulator, @NotNull AvdInfo avd) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        this.avd = avd;
        String emulatorBinary = (String)this.avd.getUserSettings().get("emulatorBinary");
        if (emulatorBinary == null) {
            path = emulator;
        } else {
            Path path2 = emulator.resolveSibling(emulatorBinary).normalize();
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
        }
        this.emulator = path;
        this.bootMode = (BootMode)QuickBoot.INSTANCE;
        this.studioEmuParams = new ArrayList();
    }

    @NotNull
    public final AvdInfo getAvd() {
        return this.avd;
    }

    @Nullable
    public final Path getAvdHome() {
        return this.avdHome;
    }

    public final void setAvdHome(@Nullable Path path) {
        this.avdHome = path;
    }

    @Nullable
    public final Path getSdkLocation() {
        return this.sdkLocation;
    }

    public final void setSdkLocation(@Nullable Path path) {
        this.sdkLocation = path;
    }

    @Nullable
    public final Path getStudioParams() {
        return this.studioParams;
    }

    public final void setStudioParams(@Nullable Path path) {
        this.studioParams = path;
    }

    public final boolean getLaunchInToolWindow() {
        return this.launchInToolWindow;
    }

    public final void setLaunchInToolWindow(boolean bl) {
        this.launchInToolWindow = bl;
    }

    @NotNull
    public final BootMode getBootMode() {
        return this.bootMode;
    }

    public final void setBootMode(@NotNull BootMode bootMode) {
        Intrinsics.checkNotNullParameter((Object)bootMode, (String)"<set-?>");
        this.bootMode = bootMode;
    }

    @NotNull
    public final List<String> getStudioEmuParams() {
        return this.studioEmuParams;
    }

    @NotNull
    public final GeneralCommandLine build() {
        GeneralCommandLine command;
        block5: {
            String it;
            command = new GeneralCommandLine();
            command.setExePath(((Object)this.emulator).toString());
            if (this.avdHome != null) {
                command.getEnvironment().put("ANDROID_AVD_HOME", String.valueOf(this.avdHome));
            }
            if (this.sdkLocation != null) {
                command.getEnvironment().put("ANDROID_HOME", String.valueOf(this.sdkLocation));
            }
            EmulatorCommandBuilderKt.access$addParametersIfParameter2IsntNull(command, "-netdelay", this.avd.getProperty("runtime.network.latency"));
            EmulatorCommandBuilderKt.access$addParametersIfParameter2IsntNull(command, "-netspeed", this.avd.getProperty("runtime.network.speed"));
            command.addParameters(this.bootMode.arguments());
            EmulatorCommandBuilderKt.access$addParametersIfParameter2IsntNull(command, "-studio-params", this.studioParams);
            String[] stringArray = new String[]{"-avd", this.avd.getName()};
            command.addParameters(stringArray);
            if (this.launchInToolWindow) {
                command.addParameter("-qt-hide-window");
                command.addParameter("-grpc-use-token");
                stringArray = new String[]{"-idle-grpc-timeout", "300"};
                command.addParameters(stringArray);
            }
            command.addParameters(this.studioEmuParams);
            String string = (String)this.avd.getUserSettings().get("commandLineOptions");
            if (string != null) {
                it = string;
                boolean bl = false;
                command.addParameters(EmulatorCommandBuilderKt.access$parseCommandLineOptions(it));
            }
            if (!((Boolean)StudioFlags.AVD_COMMAND_LINE_OPTIONS_ENABLED.get()).booleanValue()) break block5;
            String string2 = this.avd.getProperty("commandLineOptions");
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                command.addParameters(EmulatorCommandBuilderKt.access$parseCommandLineOptions(it));
            }
        }
        return command;
    }
}

