/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view.table;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorClient;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskTreeModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntrySelectionModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.AlarmEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.JobEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WakeLockEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskInspectorTab;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryFormatUtilKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.table.BackgroundTaskTreeTableViewKt;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.NewUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/table/BackgroundTaskTreeTableView;", "", "tab", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;", "client", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;", "selectionModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "uiDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "treeModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskTreeModel;", "getTreeModel", "()Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskTreeModel;", "expandedPaths", "", "Ljavax/swing/tree/TreePath;", "getExpandedPaths", "()Ljava/util/Set;", "restoreExpandedPaths", "", "tree", "Ljavax/swing/JTree;", "app-inspection.inspectors.backgroundtask.view"})
@SourceDebugExtension(value={"SMAP\nBackgroundTaskTreeTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTaskTreeTableView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/table/BackgroundTaskTreeTableView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
public final class BackgroundTaskTreeTableView {
    @NotNull
    private final JComponent component;
    @NotNull
    private final BackgroundTaskTreeModel treeModel;
    @NotNull
    private final Set<TreePath> expandedPaths;

    public BackgroundTaskTreeTableView(final @NotNull BackgroundTaskInspectorTab tab, @NotNull BackgroundTaskInspectorClient client, @NotNull EntrySelectionModel selectionModel, @NotNull CoroutineScope scope, @NotNull CoroutineDispatcher uiDispatcher) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)uiDispatcher, (String)"uiDispatcher");
        this.treeModel = new BackgroundTaskTreeModel(client, scope, uiDispatcher);
        this.expandedPaths = new LinkedHashSet();
        final Tree tree = new Tree((TreeModel)this.treeModel);
        tree.setRootVisible(false);
        tree.setBorder(BackgroundTaskTreeTableViewKt.access$getTABLE_ROW_BORDER$p());
        tree.setRowHeight(0);
        tree.getSelectionModel().setSelectionMode(1);
        this.treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.treeStructureChanged(event);
                tree.expandPath(event.getTreePath());
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Set<TreePath> set2 = this.getExpandedPaths();
                TreePath treePath = event.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"getPath(...)");
                set2.add(treePath);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getExpandedPaths().remove(event.getPath());
            }
        });
        this.treeModel.addOnFilteredListener((Function1<? super String, Unit>)((Function1)arg_0 -> BackgroundTaskTreeTableView._init_$lambda$0(this, tree, arg_0)));
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JTree");
                JTree tree = (JTree)object;
                int row = tree.getClosestRowForLocation(e.getX(), e.getY());
                Rectangle bounds = tree.getRowBounds(row);
                Rectangle tableBounds = new Rectangle(0, bounds.y, bounds.width + bounds.x, bounds.height);
                if (tableBounds.contains(e.getPoint())) {
                    TreePath path = tree.getPathForRow(row);
                    Object object2 = path.getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode = object2 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object2 : null;
                    if ((defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null) instanceof BackgroundTaskEntry) {
                        tab.setDetailsViewVisible(true);
                    }
                }
            }
        });
        tree.addTreeSelectionListener(arg_0 -> BackgroundTaskTreeTableView._init_$lambda$1(selectionModel, client, this, tree, arg_0));
        selectionModel.registerEntrySelectionListener((Function1<? super BackgroundTaskEntry, Unit>)((Function1)arg_0 -> BackgroundTaskTreeTableView._init_$lambda$2(tree, this, arg_0)));
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)tree).setShowVerticalLines(true).setBorder(BorderFactory.createEmptyBorder()).setTreeSorter((arg_0, arg_1) -> BackgroundTaskTreeTableView._init_$lambda$3(this, arg_0, arg_1));
        builder.setHeaderRowCellRenderer(BackgroundTaskTreeTableView::_init_$lambda$4);
        builder.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.access$getTABLE_COLUMN_HEADER_BORDER$p()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof BackgroundTaskEntry) {
                    this.append(((BackgroundTaskEntry)data2).getClassName());
                } else if (data2 instanceof String) {
                    this.append((String)data2);
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getCLASS_NAME_COMPARATOR()));
        builder.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Status").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.access$getTABLE_COLUMN_HEADER_BORDER$p()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof BackgroundTaskEntry) {
                    this.append(EntryFormatUtilKt.capitalizedName(((BackgroundTaskEntry)data2).getStatus()));
                    Icon stateIcon = EntryFormatUtilKt.icon((BackgroundTaskEntry)data2);
                    this.setIcon(selected && !NewUI.isEnabled() && stateIcon != null ? ColoredIconGenerator.generateWhiteIcon((Icon)stateIcon) : stateIcon);
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getSTATUS_COMPARATOR()));
        builder.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Start").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.access$getTABLE_COLUMN_HEADER_BORDER$p()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (data2 instanceof BackgroundTaskEntry) {
                    this.append(EntryFormatUtilKt.toFormattedTimeString(((BackgroundTaskEntry)data2).getStartTimeMs()));
                }
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getSTART_TIME_COMPARATOR()));
        builder.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Retries").setHeaderAlignment(2).setHeaderBorder((Border)BackgroundTaskTreeTableViewKt.access$getTABLE_COLUMN_HEADER_BORDER$p()).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                SimpleColoredComponent simpleColoredComponent = data2 instanceof WorkEntry || data2 instanceof JobEntry ? this.append(String.valueOf(((BackgroundTaskEntry)data2).getRetries())) : this.append("-");
            }
        }).setComparator(BackgroundTaskTreeTableViewKt.getSTART_TIME_COMPARATOR()));
        JComponent jComponent = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"build(...)");
        this.component = jComponent;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final BackgroundTaskTreeModel getTreeModel() {
        return this.treeModel;
    }

    @NotNull
    public final Set<TreePath> getExpandedPaths() {
        return this.expandedPaths;
    }

    private final void restoreExpandedPaths(JTree tree) {
        for (TreePath path : this.expandedPaths) {
            tree.expandPath(path);
        }
    }

    private static final Unit _init_$lambda$0(BackgroundTaskTreeTableView this$0, Tree $tree, String it) {
        this$0.restoreExpandedPaths((JTree)$tree);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(EntrySelectionModel $selectionModel, BackgroundTaskInspectorClient $client, BackgroundTaskTreeTableView this$0, Tree $tree, TreeSelectionEvent event) {
        if (event.isAddedPath()) {
            Object object = event.getPath().getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
            if (defaultMutableTreeNode == null) {
                return;
            }
            DefaultMutableTreeNode node = defaultMutableTreeNode;
            Object object2 = node.getUserObject();
            BackgroundTaskEntry backgroundTaskEntry = object2 instanceof BackgroundTaskEntry ? (BackgroundTaskEntry)object2 : null;
            if (backgroundTaskEntry == null) {
                return;
            }
            BackgroundTaskEntry entry = backgroundTaskEntry;
            $selectionModel.setSelectedEntry(entry);
            object = entry;
            if (object instanceof AlarmEntry) {
                $client.getTracker().trackAlarmSelected();
            } else if (object instanceof JobEntry) {
                if (((JobEntry)entry).getTargetWorkId() == null) {
                    $client.getTracker().trackJobSelected();
                } else {
                    $client.getTracker().trackJobUnderWorkSelected();
                }
            } else if (object instanceof WorkEntry) {
                $client.getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.TABLE_CONTEXT);
            } else if (object instanceof WakeLockEntry) {
                $client.getTracker().trackWakeLockSelected();
            }
        } else {
            BackgroundTaskEntry backgroundTaskEntry = $selectionModel.getSelectedEntry();
            if (backgroundTaskEntry == null) {
                return;
            }
            BackgroundTaskEntry entry = backgroundTaskEntry;
            DefaultMutableTreeNode defaultMutableTreeNode = this$0.treeModel.getTreeNode(entry.getId());
            if (defaultMutableTreeNode == null) {
                return;
            }
            DefaultMutableTreeNode node = defaultMutableTreeNode;
            TreePath treePath = new TreePath(node.getPath());
            if ($tree.isExpanded(treePath)) {
                $tree.getSelectionModel().setSelectionPath(treePath);
            }
        }
    }

    private static final Unit _init_$lambda$2(Tree $tree, BackgroundTaskTreeTableView this$0, BackgroundTaskEntry entry) {
        if (entry == null) {
            TreePath $this$lambda_u242_u240 = $tree.getSelectionPath();
            boolean bl = false;
            $tree.removeSelectionPath($this$lambda_u242_u240);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = this$0.treeModel.getTreeNode(entry.getId());
            if (defaultMutableTreeNode == null) {
                return Unit.INSTANCE;
            }
            DefaultMutableTreeNode node = defaultMutableTreeNode;
            $tree.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
            $tree.scrollPathToVisible($tree.getSelectionModel().getSelectionPath());
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(BackgroundTaskTreeTableView this$0, Comparator comparator, SortOrder sortOrder) {
        if (comparator != null) {
            this$0.treeModel.sort(comparator);
        }
    }

    private static final Component _init_$lambda$4(JTree jTree, Object value2, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel;
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        Object object = ((DefaultMutableTreeNode)value2).getUserObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        JLabel $this$lambda_u244_u240 = jLabel = new JLabel((String)object);
        boolean bl5 = false;
        $this$lambda_u244_u240.setPreferredSize(new Dimension($this$lambda_u244_u240.getPreferredSize().width, 30));
        return jLabel;
    }
}

