/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorClient;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ComponentProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ComponentProvidersKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryFormatUtilKt;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/IdListProvider;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/ComponentProvider;", "", "", "client", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;", "currentWork", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo;", "selectWork", "Lkotlin/Function1;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry;", "", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo;Lkotlin/jvm/functions/Function1;)V", "convert", "Ljavax/swing/JComponent;", "data", "app-inspection.inspectors.backgroundtask.view"})
@SourceDebugExtension(value={"SMAP\nComponentProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentProviders.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/IdListProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1869#2,2:302\n*S KotlinDebug\n*F\n+ 1 ComponentProviders.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/IdListProvider\n*L\n158#1:302,2\n*E\n"})
public final class IdListProvider
implements ComponentProvider<List<? extends String>> {
    @NotNull
    private final BackgroundTaskInspectorClient client;
    @NotNull
    private final WorkManagerInspectorProtocol.WorkInfo currentWork;
    @NotNull
    private final Function1<WorkEntry, Unit> selectWork;

    public IdListProvider(@NotNull BackgroundTaskInspectorClient client, @NotNull WorkManagerInspectorProtocol.WorkInfo currentWork, @NotNull Function1<? super WorkEntry, Unit> selectWork) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)currentWork, (String)"currentWork");
        Intrinsics.checkNotNullParameter(selectWork, (String)"selectWork");
        this.client = client;
        this.currentWork = currentWork;
        this.selectWork = selectWork;
    }

    @Override
    @NotNull
    public JComponent convert(@NotNull List<String> data2) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        String currId = this.currentWork.getId();
        if (!((Collection)data2).isEmpty()) {
            JPanel jPanel;
            JPanel $this$convert_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
            boolean bl = false;
            Iterable $this$forEach$iv = data2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component component;
                String id2 = (String)element$iv;
                boolean bl2 = false;
                BackgroundTaskEntry entry = this.client.getEntry(id2);
                if (entry != null) {
                    ActionLink actionLink;
                    WorkManagerInspectorProtocol.WorkInfo work = ((WorkEntry)entry).getWorkInfo();
                    JPanel mixedLabel = new JPanel((LayoutManager)new HorizontalLayout(2, 0, 2, null));
                    ActionLink $this$convert_u24lambda_u240_u240_u241 = actionLink = new ActionLink(id2, arg_0 -> IdListProvider.convert$lambda$0$0$0(this, entry, arg_0));
                    boolean bl3 = false;
                    $this$convert_u24lambda_u240_u240_u241.setIcon(EntryFormatUtilKt.icon(entry));
                    if (work.getTagsCount() > 0) {
                        ProtocolStringList protocolStringList = work.getTagsList();
                        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getTagsList(...)");
                        $this$convert_u24lambda_u240_u240_u241.setToolTipText("<html><b>Tags</b><br>" + CollectionsKt.joinToString$default((Iterable)((Iterable)protocolStringList), (CharSequence)"<br>", null, null, (int)0, null, IdListProvider::convert$lambda$0$0$1$0, (int)30, null) + "</html>");
                    }
                    ActionLink actionLink2 = actionLink;
                    mixedLabel.add((Component)actionLink2);
                    if (Intrinsics.areEqual((Object)id2, (Object)currId)) {
                        mixedLabel.add(new JLabel("(Current)"));
                    }
                    component = $this$convert_u24lambda_u240.add(mixedLabel);
                    continue;
                }
                component = $this$convert_u24lambda_u240.add((Component)new JBLabel(id2));
            }
            jComponent = jPanel;
        } else {
            jComponent = (JComponent)ComponentProvidersKt.access$createEmptyContentLabel();
        }
        return jComponent;
    }

    private static final Unit convert$lambda$0$0$0(IdListProvider this$0, BackgroundTaskEntry $entry, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.selectWork.invoke((Object)$entry);
        return Unit.INSTANCE;
    }

    private static final CharSequence convert$lambda$0$0$1$0(String it) {
        return "\"" + it + "\"";
    }
}

