/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries;

import backgroundtask.inspection.BackgroundTaskInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskUtilKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EventWrapper;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\u00020!X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010$\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001cR\"\u0010,\u001a\u0004\u0018\u00010+2\b\u0010$\u001a\u0004\u0018\u00010+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00064"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskEntry;", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "_className", "_status", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry$State;", "_startTime", "", "_isValid", "", "_tags", "", "isValid", "()Z", "className", "getClassName", "status", "getStatus", "startTimeMs", "getStartTimeMs", "()J", "tags", "getTags", "()Ljava/util/List;", "callstacks", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "getCallstacks", "retries", "", "getRetries", "()I", "value", "Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$AlarmSet;", "alarmSet", "getAlarmSet", "()Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$AlarmSet;", "alarmFiredTimestamps", "getAlarmFiredTimestamps", "Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;", "latestEvent", "getLatestEvent", "()Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$Event;", "consume", "", "eventWrapper", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EventWrapper;", "State", "app-inspection.inspectors.backgroundtask.model"})
public final class AlarmEntry
implements BackgroundTaskEntry {
    @NotNull
    private final String id;
    @NotNull
    private String _className;
    @NotNull
    private State _status;
    private long _startTime;
    private boolean _isValid;
    @NotNull
    private List<String> _tags;
    @NotNull
    private final List<BackgroundTaskCallStack> callstacks;
    private final int retries;
    @Nullable
    private BackgroundTaskInspectorProtocol.AlarmSet alarmSet;
    @NotNull
    private final List<Long> alarmFiredTimestamps;
    @Nullable
    private BackgroundTaskInspectorProtocol.Event latestEvent;

    public AlarmEntry(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.id = id2;
        this._className = "";
        this._status = State.UNSPECIFIED;
        this._startTime = -1L;
        this._tags = new ArrayList();
        this.callstacks = new ArrayList();
        this.alarmFiredTimestamps = new ArrayList();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this._isValid;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this._className;
    }

    @Override
    @NotNull
    public String getStatus() {
        return this._status.name();
    }

    @Override
    public long getStartTimeMs() {
        return this._startTime;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this._tags;
    }

    @Override
    @NotNull
    public List<BackgroundTaskCallStack> getCallstacks() {
        return this.callstacks;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Nullable
    public final BackgroundTaskInspectorProtocol.AlarmSet getAlarmSet() {
        return this.alarmSet;
    }

    @NotNull
    public final List<Long> getAlarmFiredTimestamps() {
        return this.alarmFiredTimestamps;
    }

    @Nullable
    public final BackgroundTaskInspectorProtocol.Event getLatestEvent() {
        return this.latestEvent;
    }

    @Override
    public void consume(@NotNull EventWrapper eventWrapper) {
        Intrinsics.checkNotNullParameter((Object)eventWrapper, (String)"eventWrapper");
        this.latestEvent = eventWrapper.getBackgroundTaskEvent();
        long timestamp = eventWrapper.getBackgroundTaskEvent().getTimestamp();
        BackgroundTaskInspectorProtocol.Event event = this.latestEvent;
        Intrinsics.checkNotNull((Object)event);
        BackgroundTaskInspectorProtocol.BackgroundTaskEvent backgroundTaskEvent = event.getBackgroundTaskEvent();
        BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase metadataCase = backgroundTaskEvent.getMetadataCase();
        switch (metadataCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metadataCase.ordinal()]) {
            case 1: {
                this._isValid = true;
                this.alarmSet = backgroundTaskEvent.getAlarmSet();
                String string = backgroundTaskEvent.getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStacktrace(...)");
                Object object = BackgroundTaskUtilKt.getTopExternalClassSimpleName(string, "android.app.AlarmManager");
                if (object == null) {
                    object = "Alarm " + this.getId();
                }
                this._className = object;
                this._status = State.SET;
                BackgroundTaskInspectorProtocol.Event event2 = this.latestEvent;
                Intrinsics.checkNotNull((Object)event2);
                this._startTime = event2.getTimestamp();
                BackgroundTaskInspectorProtocol.AlarmSet alarmSet = this.alarmSet;
                Intrinsics.checkNotNull((Object)alarmSet);
                if (alarmSet.hasListener()) {
                    BackgroundTaskInspectorProtocol.AlarmSet alarmSet2 = this.alarmSet;
                    Intrinsics.checkNotNull((Object)alarmSet2);
                    String string2 = alarmSet2.getListener().getTag();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTag(...)");
                    this._tags.add(string2);
                }
                this.getCallstacks().clear();
                List<BackgroundTaskCallStack> list2 = this.getCallstacks();
                String string3 = backgroundTaskEvent.getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStacktrace(...)");
                boolean bl = list2.add(new BackgroundTaskCallStack(timestamp, string3));
                break;
            }
            case 2: {
                this._status = State.CANCELLED;
                List<BackgroundTaskCallStack> list3 = this.getCallstacks();
                String string = backgroundTaskEvent.getStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStacktrace(...)");
                boolean bl = list3.add(new BackgroundTaskCallStack(timestamp, string));
                break;
            }
            case 3: {
                this._status = State.FIRED;
                BackgroundTaskInspectorProtocol.Event event3 = this.latestEvent;
                Intrinsics.checkNotNull((Object)event3);
                boolean bl = this.alarmFiredTimestamps.add(event3.getTimestamp());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry$State;", "", "<init>", "(Ljava/lang/String;I)V", "SET", "CANCELLED", "FIRED", "UNSPECIFIED", "app-inspection.inspectors.backgroundtask.model"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State SET = new State();
        public static final /* enum */ State CANCELLED = new State();
        public static final /* enum */ State FIRED = new State();
        public static final /* enum */ State UNSPECIFIED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.SET, State.CANCELLED, State.FIRED, State.UNSPECIFIED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.values().length];
            try {
                nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.ALARM_SET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.ALARM_CANCELLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.ALARM_FIRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

