/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.resolver;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.appinspection.inspector.api.launch.RunningArtifactCoordinate;
import com.android.tools.idea.io.FileService;
import com.android.utils.FileUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\tH\u0007J\f\u0010\u0010\u001a\u00020\u0011*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/appinspection/ide/resolver/AppInspectorArtifactPaths;", "", "fileService", "Lcom/android/tools/idea/io/FileService;", "<init>", "(Lcom/android/tools/idea/io/FileService;)V", "jars", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/idea/appinspection/inspector/api/launch/RunningArtifactCoordinate;", "Ljava/nio/file/Path;", "getInspectorArchive", "inspector", "populateInspectorArchive", "", "artifactCoordinate", "archive", "inspectorJarFileName", "", "app-inspection.ide"})
public final class AppInspectorArtifactPaths {
    @NotNull
    private final FileService fileService;
    @NotNull
    private final ConcurrentHashMap<RunningArtifactCoordinate, Path> jars;

    public AppInspectorArtifactPaths(@NotNull FileService fileService) {
        Intrinsics.checkNotNullParameter((Object)fileService, (String)"fileService");
        this.fileService = fileService;
        this.jars = new ConcurrentHashMap();
    }

    @Nullable
    public final Path getInspectorArchive(@NotNull RunningArtifactCoordinate inspector) {
        Intrinsics.checkNotNullParameter((Object)inspector, (String)"inspector");
        if (!this.jars.containsKey(inspector)) {
            Path cachePath = this.fileService.getOrCreateCacheDir("inspector-jars");
            String[] stringArray = new String[]{inspector.getGroupId(), inspector.getArtifactId(), inspector.getVersion(), this.inspectorJarFileName(inspector)};
            Path jarPath = Paths.get(((Object)cachePath).toString(), stringArray);
            Intrinsics.checkNotNull((Object)jarPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(jarPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ((Map)this.jars).put(inspector, jarPath);
            }
        }
        return this.jars.get(inspector);
    }

    @WorkerThread
    public final void populateInspectorArchive(@NotNull RunningArtifactCoordinate artifactCoordinate, @NotNull Path archive) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinate, (String)"artifactCoordinate");
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        try {
            Path destDir = this.fileService.getOrCreateCacheDir("inspector-jars").resolve(artifactCoordinate.getGroupId()).resolve(artifactCoordinate.getArtifactId()).resolve(artifactCoordinate.getVersion());
            Files.createDirectories(destDir, new FileAttribute[0]);
            Path destFile = destDir.resolve(this.inspectorJarFileName(artifactCoordinate));
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            FileUtils.copyFile((Path)archive, (Path)destFile, (CopyOption[])copyOptionArray);
            ((Map)this.jars).put(artifactCoordinate, destFile);
        }
        catch (IOException e) {
            Logger.getInstance(AppInspectorArtifactPaths.class).error((Throwable)e);
        }
    }

    private final String inspectorJarFileName(RunningArtifactCoordinate $this$inspectorJarFileName) {
        return $this$inspectorJarFileName.getGroupId() + "-" + $this$inspectorJarFileName.getArtifactId() + "-" + $this$inspectorJarFileName.getVersion() + "-inspector.jar";
    }
}

