/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.apk.analyzer.FilteredTreeModel;
import com.android.tools.apk.analyzer.dex.DexFileStats;
import com.android.tools.apk.analyzer.dex.DexFiles;
import com.android.tools.apk.analyzer.dex.DexReferences;
import com.android.tools.apk.analyzer.dex.DexViewFilters;
import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.internal.ProguardMappingFiles;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.dex.DexNodeIcons;
import com.android.tools.idea.apk.viewer.dex.GenerateProguardKeepRuleAction;
import com.android.tools.idea.apk.viewer.dex.NavigateToSourceAction;
import com.android.tools.idea.apk.viewer.dex.SelectProguardMapsDialog;
import com.android.tools.idea.apk.viewer.dex.ShowDisassemblyAction;
import com.android.tools.idea.apk.viewer.dex.ShowReferencesAction;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DexFileViewer
extends UserDataHolderBase
implements ApkFileEditorComponent,
FileEditor {
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private final Tree myTree;
    private final JPanel myTopPanel;
    @NotNull
    private final Path[] myDexFiles;
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myApkFolder;
    @NotNull
    private final DexViewFilters myDexFilters;
    private final DexTreeNodeRenderer myDexTreeRenderer;
    @Nullable
    private ProguardMappings myProguardMappings;
    private boolean myDeobfuscateNames;
    private ListenableFuture<DexReferences> myDexReferences;
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("APK Analyzer (Info)");
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("APK Analyzer (Important)");

    public DexFileViewer(@NotNull Project project, @NotNull Path[] dexFiles, @Nullable VirtualFile apkFolder, @Nullable ProguardMappings proguardMappings) {
        Preconditions.checkArgument((dexFiles.length > 0 || apkFolder != null ? 1 : 0) != 0, (Object)"Must have at least one dex file or an APK folder");
        this.myDexFiles = dexFiles;
        this.myProject = project;
        this.myApkFolder = apkFolder;
        this.myProguardMappings = proguardMappings;
        this.myDisposable = Disposer.newDisposable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable);
        this.myLoadingPanel.startLoading();
        this.myTree = new Tree((TreeModel)new DefaultTreeModel((TreeNode)new LoadingNode()));
        this.myTree.setName("DexTree");
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        final TreeSpeedSearch speedSearch2 = TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, path -> {
            Object o = path.getLastPathComponent();
            if (!(o instanceof DexElementNode)) {
                return "";
            }
            DexElementNode node = (DexElementNode)o;
            return node.getName();
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    DexFileViewer.this.showDisassembly(true);
                }
            }
        });
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!speedSearch2.isPopupActive() && e.getKeyChar() == ' ') {
                    DexFileViewer.this.showDisassembly(false);
                }
            }
        });
        this.myDexTreeRenderer = new DexTreeNodeRenderer();
        if (this.myProguardMappings != null) {
            this.myDeobfuscateNames = true;
            this.myDexTreeRenderer.setMappings(this.myProguardMappings);
        }
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setPreferredWidth(500).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getName).reversed()).setRenderer((ColoredTreeCellRenderer)this.myDexTreeRenderer)).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Defined Methods").setPreferredWidth(100).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getMethodDefinitionsCount)).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Referenced Methods").setPreferredWidth(100).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getMethodReferencesCount)).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Size").setPreferredWidth(50).setHeaderAlignment(2).setComparator(Comparator.comparing(DexElementNode::getSize)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer()));
        builder.setTreeSorter((comparator, order) -> {
            if (comparator != null) {
                TreeModel model = this.myTree.getModel();
                TreePath selectionPath = this.myTree.getSelectionPath();
                Object root = model.getRoot();
                if (root instanceof DexElementNode) {
                    ((DexElementNode)root).sort(comparator.reversed());
                }
                if (model instanceof DefaultTreeModel) {
                    ((DefaultTreeModel)model).reload();
                }
                this.myTree.setSelectionPath(selectionPath);
                this.myTree.scrollPathToVisible(selectionPath);
            }
        });
        JComponent columnTree = builder.build();
        this.myLoadingPanel.add((Component)columnTree, (Object)"Center");
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myLoadingPanel.add((Component)this.myTopPanel, (Object)"North");
        this.myDexFilters = new DexViewFilters();
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add((AnAction)new ShowFieldsAction(this.myTree, this.myDexFilters));
        actionGroup2.add((AnAction)new ShowMethodsAction(this.myTree, this.myDexFilters));
        actionGroup2.add((AnAction)new ShowReferencedAction(this.myTree, this.myDexFilters));
        actionGroup2.addSeparator();
        actionGroup2.add((AnAction)new ShowRemovedNodesAction(this.myTree, this.myDexFilters));
        actionGroup2.add((AnAction)new LoadProguardAction());
        actionGroup2.add((AnAction)new DeobfuscateNodesAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DexFileViewer", (ActionGroup)actionGroup2, true);
        toolbar.setTargetComponent((JComponent)this.myTopPanel);
        this.myTopPanel.add((Component)toolbar.getComponent(), "West");
        ActionGroup group2 = this.createPopupActionGroup(this.myTree);
        PopupHandler.installPopupMenu((JComponent)this.myTree, (ActionGroup)group2, (String)"unknown");
        this.initDex();
    }

    public VirtualFile getFile() {
        if (this.myApkFolder != null) {
            return this.myApkFolder;
        }
        return VirtualFileManager.getInstance().findFileByNioPath(this.myDexFiles[0]);
    }

    @NotNull
    private ActionGroup createPopupActionGroup(@NotNull Tree tree) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(this.createShowDisassemblyAction(tree));
        group2.add((AnAction)new ShowReferencesAction(tree, this));
        group2.add((AnAction)new GenerateProguardKeepRuleAction(tree));
        group2.add((AnAction)new NavigateToSourceAction(tree));
        return group2;
    }

    @NotNull
    private AnAction createShowDisassemblyAction(@NotNull Tree tree) {
        return new ShowDisassemblyAction(tree, (Supplier<ProguardMap>)((Supplier)() -> {
            if (this.myDeobfuscateNames && this.myProguardMappings != null) {
                return this.myProguardMappings.map;
            }
            return null;
        }));
    }

    private void showDisassembly(boolean requireLeaf) {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object component = path.getLastPathComponent();
        if (component instanceof DexElementNode && (!requireLeaf || ((DexElementNode)component).isLeaf())) {
            ActionManager.getInstance().tryToExecute(this.createShowDisassemblyAction(this.myTree), null, null, "unknown", true);
        }
    }

    public void selectProguardMapping() {
        SelectProguardMapsDialog dialog2 = new SelectProguardMapsDialog(this.myProject, this.myApkFolder);
        try {
            if (!dialog2.showAndGet()) {
                return;
            }
            ProguardMappingFiles mappingFiles = dialog2.getMappingFiles();
            ArrayList<String> loaded = new ArrayList<String>(3);
            ArrayList<String> errors = new ArrayList<String>(3);
            Path mappingFile = mappingFiles.mappingFile;
            ProguardMap proguardMap = new ProguardMap();
            if (mappingFile != null) {
                try {
                    proguardMap.readFromReader((Reader)new InputStreamReader(Files.newInputStream(mappingFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(mappingFile.getFileName().toString());
                }
                catch (IOException | ParseException e) {
                    errors.add(mappingFile.getFileName().toString());
                    proguardMap = null;
                }
            }
            Path seedsFile = mappingFiles.seedsFile;
            ProguardSeedsMap seeds = null;
            if (seedsFile != null) {
                try {
                    seeds = ProguardSeedsMap.parse((Reader)new InputStreamReader(Files.newInputStream(seedsFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(seedsFile.getFileName().toString());
                }
                catch (IOException e) {
                    errors.add(seedsFile.getFileName().toString());
                }
            }
            if ((this.myProguardMappings == null || this.myProguardMappings.map == null) && proguardMap != null) {
                this.myDeobfuscateNames = true;
            }
            Path usageFile = mappingFiles.usageFile;
            ProguardUsagesMap usage = null;
            if (usageFile != null) {
                try {
                    usage = ProguardUsagesMap.parse((Reader)new InputStreamReader(Files.newInputStream(usageFile, new OpenOption[0]), Charsets.UTF_8));
                    loaded.add(usageFile.getFileName().toString());
                }
                catch (IOException e) {
                    errors.add(usageFile.getFileName().toString());
                }
            }
            ProguardMappings proguardMappings = this.myProguardMappings = loaded.isEmpty() ? null : new ProguardMappings(proguardMap, seeds, usage);
            if (errors.isEmpty() && loaded.isEmpty()) {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer couldn't find any ProGuard mapping files. The filenames must match one of: mapping.txt, seeds.txt, usage.txt", MessageType.ERROR).notify(this.myProject);
            } else if (errors.isEmpty()) {
                LOGGING_NOTIFICATION.createNotification("APK Analyzer successfully loaded maps from: " + StringUtil.join(loaded, (String)", "), MessageType.INFO).notify(this.myProject);
            } else if (loaded.isEmpty()) {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer encountered problems loading: " + StringUtil.join(errors, (String)", "), MessageType.WARNING).notify(this.myProject);
            } else {
                BALLOON_NOTIFICATION.createNotification("APK Analyzer successfully loaded maps from: " + StringUtil.join(loaded, (String)",") + "\nThere were problems loading: " + StringUtil.join(errors, (String)", "), MessageType.WARNING).notify(this.myProject);
            }
            this.myDexTreeRenderer.setMappings(this.myProguardMappings);
            this.initDex();
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Error Loading Mappings...");
        }
    }

    public void initDex() {
        ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> {
            HashMap dexFiles = Maps.newHashMapWithExpectedSize((int)this.myDexFiles.length);
            for (int i = 0; i < this.myDexFiles.length; ++i) {
                dexFiles.put(this.myDexFiles[i], DexFiles.getDexFile((Path)this.myDexFiles[i]));
            }
            return dexFiles;
        });
        ListenableFuture treeNodeFuture = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<Map<Path, DexBackedDexFile>, DexPackageNode>(){

            @NotNull
            public DexPackageNode apply(@Nullable Map<Path, DexBackedDexFile> input2) {
                assert (input2 != null);
                PackageTreeCreator treeCreator = new PackageTreeCreator(DexFileViewer.this.myProguardMappings, DexFileViewer.this.myDeobfuscateNames);
                return treeCreator.constructPackageTree(input2);
            }
        }, (Executor)pooledThreadExecutor);
        Futures.addCallback((ListenableFuture)treeNodeFuture, (FutureCallback)new FutureCallback<DexPackageNode>(){

            public void onSuccess(DexPackageNode result2) {
                DexFileViewer.this.myLoadingPanel.stopLoading();
                DexFileViewer.this.myTree.setRootVisible(false);
                FilteredTreeModel treeModel = new FilteredTreeModel((TreeNode)result2, (Predicate)DexFileViewer.this.myDexFilters);
                DexFileViewer.this.myTree.setModel((TreeModel)treeModel);
                treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                    protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                        Enumeration expanded = DexFileViewer.this.myTree.getExpandedDescendants(new TreePath(DexFileViewer.this.myTree.getModel().getRoot()));
                        if (expanded == null) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            for (TreePath path : Collections.list(expanded)) {
                                DexFileViewer.this.myTree.expandPath(path);
                            }
                        });
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                DexFileViewer.this.myLoadingPanel.stopLoading();
            }
        }, (Executor)EdtExecutorService.getInstance());
        ListenableFuture dexStatsFuture = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<Map<Path, DexBackedDexFile>, DexFileStats>(this){

            @NotNull
            public DexFileStats apply(@Nullable Map<Path, DexBackedDexFile> input2) {
                assert (input2 != null);
                return DexFileStats.create(input2.values());
            }
        }, (Executor)pooledThreadExecutor);
        if (((BorderLayout)this.myTopPanel.getLayout()).getLayoutComponent("East") == null) {
            final SimpleColoredComponent titleComponent = new SimpleColoredComponent();
            titleComponent.setIcon(AllIcons.Actions.Refresh);
            titleComponent.append("Loading dex stats");
            this.myTopPanel.add((Component)titleComponent, "East");
            Futures.addCallback((ListenableFuture)dexStatsFuture, (FutureCallback)new FutureCallback<DexFileStats>(){

                public void onSuccess(DexFileStats result2) {
                    titleComponent.clear();
                    titleComponent.setIcon(AllIcons.General.Information);
                    titleComponent.append(DexFileViewer.this.myDexFiles.length == 1 ? "This dex file defines " : "These dex files define ");
                    titleComponent.append(Integer.toString(result2.classCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" classes with ");
                    titleComponent.append(Integer.toString(result2.definedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" methods, and references ");
                    titleComponent.append(Integer.toString(result2.referencedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    titleComponent.append(" methods.");
                }

                public void onFailure(@NotNull Throwable t) {
                    titleComponent.clear();
                    titleComponent.setIcon(AllIcons.General.Error);
                    titleComponent.append("Error parsing dex file: " + t.getMessage());
                }
            }, (Executor)EdtExecutorService.getInstance());
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myLoadingPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLoadingPanel;
    }

    @NotNull
    public String getName() {
        return "Dex Viewer";
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        for (Path file : this.myDexFiles) {
            if (Files.isRegularFile(file, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Nullable
    public ProguardMappings getProguardMappings() {
        return this.myProguardMappings;
    }

    public boolean isDeobfuscateNames() {
        return this.myDeobfuscateNames;
    }

    @Nullable
    ListenableFuture<DexReferences> getDexReferences() {
        if (this.myDexReferences == null) {
            ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
            ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> {
                DexBackedDexFile[] files2 = new DexBackedDexFile[this.myDexFiles.length];
                for (int i = 0; i < files2.length; ++i) {
                    files2[i] = DexFiles.getDexFile((Path)this.myDexFiles[i]);
                }
                return files2;
            });
            this.myDexReferences = Futures.transform((ListenableFuture)dexFileFuture, (Function)new Function<DexBackedDexFile[], DexReferences>(this){

                public DexReferences apply(@Nullable DexBackedDexFile[] inputs) {
                    assert (inputs != null);
                    return new DexReferences(inputs);
                }
            }, (Executor)pooledThreadExecutor);
        }
        return this.myDexReferences;
    }

    private static class DexTreeNodeRenderer
    extends ColoredTreeCellRenderer {
        @Nullable
        private ProguardMappings myMappings;

        private DexTreeNodeRenderer() {
        }

        public void setMappings(@Nullable ProguardMappings mappings) {
            this.myMappings = mappings;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value2 instanceof DexElementNode)) {
                return;
            }
            DexElementNode node = (DexElementNode)value2;
            if (this.myMappings != null && node.isSeed(this.myMappings.seeds, this.myMappings.map, true)) {
                this.append(node.getName(), new SimpleTextAttributes(1, null));
            } else if (node.isRemoved()) {
                this.append(node.getName(), new SimpleTextAttributes(6, null));
            } else if (!node.isDefined()) {
                this.append(node.getName(), new SimpleTextAttributes(2, null));
            } else {
                this.append(node.getName());
            }
            this.setIcon(DexNodeIcons.forNode(node));
        }
    }

    private static class MethodCountRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myShowDefinedCount;

        public MethodCountRenderer(boolean showDefinedCount) {
            this.myShowDefinedCount = showDefinedCount;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof DexElementNode) {
                int count;
                DexElementNode node = (DexElementNode)value2;
                int n = count = this.myShowDefinedCount ? node.getMethodDefinitionsCount() : node.getMethodReferencesCount();
                if (count != 0) {
                    this.append(Integer.toString(count));
                }
            }
        }
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private SizeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof DexElementNode) {
                DexElementNode node = (DexElementNode)value2;
                this.append(HumanReadableUtil.getHumanizedSize((long)node.getSize()));
            }
        }
    }

    private static class ShowFieldsAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public ShowFieldsAction(@NotNull Tree tree, @NotNull DexViewFilters options) {
            super("Show fields", "Toggle between show/hide fields", IconManager.getInstance().getPlatformIcon(PlatformIcons.Field));
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowFields();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowFields(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
    }

    private static class ShowMethodsAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public ShowMethodsAction(@NotNull Tree tree, @NotNull DexViewFilters options) {
            super("Show methods", "Toggle between show/hide methods", IconManager.getInstance().getPlatformIcon(PlatformIcons.Method));
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowMethods();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowMethods(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
    }

    private static class ShowReferencedAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public ShowReferencedAction(@NotNull Tree tree, @NotNull DexViewFilters options) {
            super("Show referenced-only nodes", "Toggle between show/hide referenced-only nodes", AllIcons.ObjectBrowser.ShowMembers);
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            String text2 = this.myDexViewFilters.isShowReferencedNodes() ? "Show all referenced methods and fields" : "Show defined methods and fields";
            e.getPresentation().setText(text2);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowReferencedNodes();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowReferencedNodes(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
    }

    private class ShowRemovedNodesAction
    extends ToggleAction
    implements DumbAware {
        private final Tree myTree;
        private final DexViewFilters myDexViewFilters;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public ShowRemovedNodesAction(@NotNull Tree tree, DexViewFilters options) {
            super("Show removed nodes", "Toggle between show/hide nodes removed by Proguard", AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myTree = tree;
            this.myDexViewFilters = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myDexViewFilters.isShowRemovedNodes();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.myDexViewFilters.setShowRemovedNodes(state2);
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(DexFileViewer.this.myProguardMappings != null && DexFileViewer.this.myProguardMappings.usage != null);
        }
    }

    private class LoadProguardAction
    extends AnAction
    implements DumbAware {
        public LoadProguardAction() {
            super("Load Proguard Mappings...", null, AllIcons.ObjectBrowser.AbbreviatePackageNames);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DexFileViewer.this.selectProguardMapping();
        }

        public void update(@NotNull AnActionEvent e) {
            if (DexFileViewer.this.myProguardMappings != null) {
                e.getPresentation().setText("Change Proguard Mappings...");
            } else {
                e.getPresentation().setText("Load Proguard Mappings...");
            }
        }
    }

    private class DeobfuscateNodesAction
    extends ToggleAction
    implements DumbAware {
        public DeobfuscateNodesAction() {
            super(DeobfuscateNodesAction.getActionText(DexFileViewer.this.myDeobfuscateNames), null, EmptyIcon.ICON_0);
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return DexFileViewer.this.myDeobfuscateNames;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            DexFileViewer.this.myDeobfuscateNames = state2;
            DexFileViewer.this.initDex();
            e.getPresentation().setText(DeobfuscateNodesAction.getActionText(state2));
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(DexFileViewer.this.myProguardMappings != null && DexFileViewer.this.myProguardMappings.map != null);
            presentation.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        }

        private static String getActionText(Boolean state2) {
            return state2 != false ? "Show Obfuscated Names" : "Show Deobfuscated Names";
        }
    }
}

