/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.apk.debugging.editor.ChooseAndAttachJavaSourcesTask;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.io.File;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmaliFileNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        File filePath;
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file);
        if (module == null) {
            return null;
        }
        DexSourceFiles dexSourceFiles = DexSourceFiles.getInstance(project);
        if (ApkFacet.getInstance(module) == null || !dexSourceFiles.isSmaliFile(file)) {
            return null;
        }
        File outputFolderPath = dexSourceFiles.getDefaultSmaliOutputFolderPath();
        if (!FileUtil.isAncestor((File)outputFolderPath, (File)(filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file)), (boolean)false)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        String classFqn = psiFile instanceof SmaliFile ? dexSourceFiles.findJavaClassName((SmaliFile)psiFile) : null;
        PsiClass javaPsiClass = StringUtil.isNotEmpty((String)classFqn) ? dexSourceFiles.findJavaPsiClass(classFqn) : null;
        PsiAnchor psiClassAnchor = javaPsiClass != null ? PsiAnchor.create((PsiElement)javaPsiClass) : null;
        return fileEditor -> SmaliFileNotificationProvider.createPanel(module, fileEditor, psiClassAnchor, classFqn);
    }

    @NotNull
    private static EditorNotificationPanel createPanel(@NotNull Module module, @NotNull FileEditor fileEditor, @Nullable PsiAnchor psiClassAnchor, @Nullable String classFqn) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        panel2.setText("Disassembled classes.dex file. To set up breakpoints for debugging, please attach Kotlin/Java source files.");
        if (StringUtil.isNotEmpty((String)classFqn)) {
            if (psiClassAnchor != null) {
                panel2.createActionLabel("Open Kotlin/Java file", () -> {
                    PsiElement javaPsiClass = psiClassAnchor.retrieve();
                    if (javaPsiClass == null) {
                        return;
                    }
                    NavigationUtil.openFileWithPsiElement((PsiElement)javaPsiClass, (boolean)true, (boolean)true);
                });
            } else {
                panel2.createActionLabel("Attach Kotlin/Java Sources...", (Runnable)new ChooseAndAttachJavaSourcesTask(classFqn, module, DexSourceFiles.getInstance(module.getProject())));
            }
        }
        return panel2;
    }
}

