/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.Slow;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/adb/wireless/QrCodeGenerator;", "", "<init>", "()V", "encodeQrCode", "Lcom/google/zxing/common/BitMatrix;", "contents", "", "size", "", "encodeQrCodeToImage", "Ljava/awt/image/BufferedImage;", "backgroundColor", "Ljava/awt/Color;", "foregroundColor", "isIso88591", "", "intellij.android.adb"})
@StabilityInferred(parameters=1)
public final class QrCodeGenerator {
    @NotNull
    public static final QrCodeGenerator INSTANCE = new QrCodeGenerator();
    public static final int $stable;

    private QrCodeGenerator() {
    }

    @JvmStatic
    @Slow
    @NotNull
    public static final BitMatrix encodeQrCode(@NotNull String contents, int size) throws WriterException {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        EnumMap hints = new EnumMap(EncodeHintType.class);
        if (!INSTANCE.isIso88591(contents)) {
            ((Map)hints).put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
        }
        BitMatrix bitMatrix = new MultiFormatWriter().encode(contents, BarcodeFormat.QR_CODE, size, size, (Map)hints);
        Intrinsics.checkNotNullExpressionValue((Object)bitMatrix, (String)"encode(...)");
        return bitMatrix;
    }

    public static /* synthetic */ BitMatrix encodeQrCode$default(String string, int n, int n2, Object object) throws WriterException {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return QrCodeGenerator.encodeQrCode(string, n);
    }

    @JvmStatic
    @Slow
    @NotNull
    public static final BufferedImage encodeQrCodeToImage(@NotNull String contents, @NotNull Color backgroundColor, @NotNull Color foregroundColor) throws WriterException {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)foregroundColor, (String)"foregroundColor");
        BitMatrix bits = QrCodeGenerator.encodeQrCode$default(contents, 0, 2, null);
        BufferedImage img = new BufferedImage(bits.getWidth(), bits.getHeight(), 2);
        int n = bits.getHeight();
        for (int y = 0; y < n; ++y) {
            int n2 = bits.getWidth();
            for (int x = 0; x < n2; ++x) {
                img.setRGB(x, y, bits.get(x, y) ? foregroundColor.getRGB() : backgroundColor.getRGB());
            }
        }
        return img;
    }

    private final boolean isIso88591(String contents) {
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        return encoder.canEncode(contents);
    }
}

