/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.PairingCodeInputPanel;
import com.android.tools.idea.adb.wireless.PairingCodePairingDialog;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.ui.JSingleDigitTextField;
import com.android.tools.idea.ui.OneTimeOverrideFocusTraversalPolicy;
import com.android.tools.idea.ui.SimpleDialog;
import com.android.tools.idea.ui.SimpleDialogOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010'\u001a\u00020\u001eJ\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\"J\u000e\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020)R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u00103\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00067"}, d2={"Lcom/android/tools/idea/adb/wireless/PairingCodePairingDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dialog", "Lcom/android/tools/idea/ui/SimpleDialog;", "pairingPanel", "Lcom/android/tools/idea/adb/wireless/PairingCodeInputPanel;", "getPairingPanel", "()Lcom/android/tools/idea/adb/wireless/PairingCodeInputPanel;", "pairingPanel$delegate", "Lkotlin/Lazy;", "validationHandler", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "getValidationHandler", "()Lkotlin/jvm/functions/Function0;", "setValidationHandler", "(Lkotlin/jvm/functions/Function0;)V", "okButtonHandler", "", "getOkButtonHandler", "setOkButtonHandler", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "pairingCodeComponent", "Ljavax/swing/JComponent;", "getPairingCodeComponent", "()Ljavax/swing/JComponent;", "currentPairingCode", "", "getCurrentPairingCode", "()Ljava/lang/String;", "isPairingCodeValid", "()Z", "createCenterPanel", "show", "", "setDevice", "service", "Lcom/android/tools/idea/adb/wireless/PairingMdnsService;", "showPairingInProgress", "text", "showPairingSuccess", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "showPairingError", "panelPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "getPanelPreferredSize", "()Lcom/intellij/util/ui/JBDimension;", "intellij.android.adb"})
@StabilityInferred(parameters=0)
public final class PairingCodePairingDialog {
    @NotNull
    private final SimpleDialog dialog;
    @NotNull
    private final Lazy pairingPanel$delegate;
    @NotNull
    private Function0<ValidationInfo> validationHandler;
    @NotNull
    private Function0<Boolean> okButtonHandler;
    public static final int $stable = 8;

    public PairingCodePairingDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.pairingPanel$delegate = LazyKt.lazy(() -> PairingCodePairingDialog.pairingPanel_delegate$lambda$0(this));
        DialogWrapper.IdeModalityType ideModalityType = DialogWrapper.IdeModalityType.IDE;
        SimpleDialogOptions options = new SimpleDialogOptions(project, true, ideModalityType, "Enter pairing code", true, () -> PairingCodePairingDialog._init_$lambda$0(this), () -> PairingCodePairingDialog._init_$lambda$1(this), false, "Pair", () -> PairingCodePairingDialog._init_$lambda$2(this), null, () -> PairingCodePairingDialog._init_$lambda$3(this), 1152, null);
        this.dialog = new SimpleDialog(options);
        this.dialog.init();
        final OneTimeOverrideFocusTraversalPolicy focusPolicy = OneTimeOverrideFocusTraversalPolicy.Companion.install(this.dialog.getRootPane());
        this.getPairingPanel().getLastPairingCodeDigitComponent().addListener(new JSingleDigitTextField.Listener(){

            @Override
            public void onDigitEntered(JSingleDigitTextField.Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                focusPolicy.getOneTimeComponentAfter().set(dialog.getOkButton());
                event.getComponent().transferFocus();
                event.setConsumed(true);
            }
        });
        this.validationHandler = validationHandler.1.INSTANCE;
        this.okButtonHandler = PairingCodePairingDialog::okButtonHandler$lambda$0;
    }

    private final PairingCodeInputPanel getPairingPanel() {
        Lazy lazy = this.pairingPanel$delegate;
        return (PairingCodeInputPanel)lazy.getValue();
    }

    @NotNull
    public final Function0<ValidationInfo> getValidationHandler() {
        return this.validationHandler;
    }

    public final void setValidationHandler(@NotNull Function0<ValidationInfo> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.validationHandler = function0;
    }

    @NotNull
    public final Function0<Boolean> getOkButtonHandler() {
        return this.okButtonHandler;
    }

    public final void setOkButtonHandler(@NotNull Function0<Boolean> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.okButtonHandler = function0;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.dialog.getDisposable();
    }

    @NotNull
    public final JComponent getPairingCodeComponent() {
        JSingleDigitTextField jSingleDigitTextField = this.getPairingPanel().getFirstPairingCodeDigitComponent();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSingleDigitTextField), (String)"getFirstPairingCodeDigitComponent(...)");
        return (JComponent)((Object)jSingleDigitTextField);
    }

    @NotNull
    public final String getCurrentPairingCode() {
        String string = this.getPairingPanel().getPairingCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPairingCode(...)");
        return string;
    }

    public final boolean isPairingCodeValid() {
        return this.getCurrentPairingCode().length() == 6;
    }

    @NotNull
    public final JComponent createCenterPanel() {
        this.getPairingPanel().getComponent().setPreferredSize((Dimension)this.getPanelPreferredSize());
        JComponent jComponent = this.getPairingPanel().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    public final void show() {
        this.dialog.show();
    }

    public final void setDevice(@NotNull PairingMdnsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.getPairingPanel().setDevice(service);
    }

    public final void showPairingInProgress(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.getPairingPanel().showProgress(text2);
        this.getPairingPanel().setDigitsEnabled(false);
        this.dialog.setOkButtonEnabled(false);
        this.dialog.setCancelButtonEnabled(false);
    }

    public final void showPairingSuccess(@NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.getPairingPanel().showSuccess(device2);
        this.dialog.setOkButtonEnabled(true);
        this.dialog.setCancelButtonEnabled(true);
        this.dialog.setOkButtonText("Done");
        this.dialog.setCancelButtonVisible(false);
    }

    public final void showPairingError() {
        this.getPairingPanel().showPairingError();
        this.getPairingPanel().setDigitsEnabled(true);
        this.dialog.setOkButtonEnabled(true);
        this.dialog.setCancelButtonEnabled(true);
    }

    private final JBDimension getPanelPreferredSize() {
        return new JBDimension(500, 200);
    }

    private static final PairingCodeInputPanel pairingPanel_delegate$lambda$0(PairingCodePairingDialog this$0) {
        return new PairingCodeInputPanel(this$0.getDisposable());
    }

    private static final JComponent _init_$lambda$0(PairingCodePairingDialog this$0) {
        return this$0.createCenterPanel();
    }

    private static final JComponent _init_$lambda$1(PairingCodePairingDialog this$0) {
        return (JComponent)((Object)this$0.getPairingPanel().getFirstPairingCodeDigitComponent());
    }

    private static final boolean _init_$lambda$2(PairingCodePairingDialog this$0) {
        return (Boolean)this$0.okButtonHandler.invoke();
    }

    private static final ValidationInfo _init_$lambda$3(PairingCodePairingDialog this$0) {
        return (ValidationInfo)this$0.validationHandler.invoke();
    }

    private static final boolean okButtonHandler$lambda$0() {
        return false;
    }
}

