/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.ui.JSingleDigitTextField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

@UiThread
public class PairingCodeInputPanel {
    public static final int PAIRING_CODE_DIGIT_COUNT = 6;
    @NotNull
    private JPanel myRootContainer;
    @NotNull
    private JBLabel myDeviceAddressLabel;
    @NotNull
    private JBLabel myPairingProgressLabel;
    @NotNull
    private AsyncProcessIcon myPairingProgressAsyncIcon;
    @NotNull
    private JBLabel myStatusIconLabel;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit1;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit2;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit3;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit4;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit5;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit6;
    @NotNull
    private final List<JSingleDigitTextField> myAllDigitTextFields;

    public PairingCodeInputPanel(@NotNull Disposable parentDisposable) {
        this.setupUI();
        this.myPairingProgressLabel.setText("");
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myStatusIconLabel.setVisible(false);
        this.myAllDigitTextFields = Arrays.asList(this.myPairingCodeDigit1, this.myPairingCodeDigit2, this.myPairingCodeDigit3, this.myPairingCodeDigit4, this.myPairingCodeDigit5, this.myPairingCodeDigit6);
        for (int i = 0; i < this.myAllDigitTextFields.size(); ++i) {
            this.myAllDigitTextFields.get(i).setName("PairingCode-Digit-" + i);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myPairingProgressAsyncIcon);
    }

    private void createUIComponents() {
        this.myPairingProgressAsyncIcon = new AsyncProcessIcon("pairing code pairing progress");
        this.myPairingCodeDigit1 = new JSingleDigitTextField();
        this.myPairingCodeDigit2 = new JSingleDigitTextField();
        this.myPairingCodeDigit3 = new JSingleDigitTextField();
        this.myPairingCodeDigit4 = new JSingleDigitTextField();
        this.myPairingCodeDigit5 = new JSingleDigitTextField();
        this.myPairingCodeDigit6 = new JSingleDigitTextField();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootContainer;
    }

    @NotNull
    public JSingleDigitTextField getLastPairingCodeDigitComponent() {
        return this.myAllDigitTextFields.get(this.myAllDigitTextFields.size() - 1);
    }

    @NotNull
    public JSingleDigitTextField getFirstPairingCodeDigitComponent() {
        return this.myAllDigitTextFields.get(0);
    }

    @NotNull
    public String getPairingCode() {
        StringBuilder sb = new StringBuilder();
        this.myAllDigitTextFields.forEach(textField2 -> {
            String text2 = textField2.getText();
            if (text2 == null || text2.isEmpty()) {
                text2 = "0";
            }
            sb.append(text2);
        });
        return sb.toString();
    }

    public void setDevice(@NotNull PairingMdnsService service) {
        this.myDeviceAddressLabel.setText(service.getDisplayString());
    }

    public void showProgress(@NotNull String text2) {
        this.myStatusIconLabel.setVisible(false);
        this.myPairingProgressAsyncIcon.setVisible(true);
        this.myPairingProgressLabel.setText(text2);
    }

    public void showSuccess(@NotNull AdbOnlineDevice device2) {
        this.myStatusIconLabel.setIcon(StudioIcons.Common.SUCCESS);
        this.myStatusIconLabel.setVisible(true);
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myPairingProgressLabel.setText(String.format("%s connected", device2.getDisplayString()));
    }

    public void showPairingError() {
        this.myStatusIconLabel.setIcon(StudioIcons.Common.ERROR);
        this.myStatusIconLabel.setVisible(true);
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myPairingProgressLabel.setText("There was an error pairing the device");
    }

    public void setDigitsEnabled(boolean enabled) {
        this.myAllDigitTextFields.forEach(textField2 -> textField2.setEnabled(enabled));
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootContainer = new JPanel();
        this.myRootContainer.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myRootContainer.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 20), null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Enter the 6 digit code shown on the device at");
        this.myRootContainer.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 3, 0, 0, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myRootContainer.add((Component)panel1, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDeviceAddressLabel = new JBLabel();
        Font myDeviceAddressLabelFont = this.getFont(null, 1, -1, this.myDeviceAddressLabel.getFont());
        if (myDeviceAddressLabelFont != null) {
            this.myDeviceAddressLabel.setFont(myDeviceAddressLabelFont);
        }
        this.myDeviceAddressLabel.setText("[xxx.xxx.xxx.xxx]");
        panel1.add((Component)this.myDeviceAddressLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText(" to pair.");
        panel1.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRootContainer.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 30), null, 1, false));
        Spacer spacer3 = new Spacer();
        this.myRootContainer.add((Component)spacer3, new GridConstraints(4, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        this.myRootContainer.add((Component)panel2, new GridConstraints(4, 1, 1, 1, 0, 2, 3, 3, null, null, null, 0, false));
        this.myPairingCodeDigit1.setColumns(2);
        this.myPairingCodeDigit1.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel2.add((Component)((Object)this.myPairingCodeDigit1), gbc);
        this.myPairingCodeDigit2.setColumns(2);
        this.myPairingCodeDigit2.setHorizontalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel2.add((Component)((Object)this.myPairingCodeDigit2), gbc);
        this.myPairingCodeDigit3.setColumns(2);
        this.myPairingCodeDigit3.setHorizontalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel2.add((Component)((Object)this.myPairingCodeDigit3), gbc);
        this.myPairingCodeDigit4.setColumns(2);
        this.myPairingCodeDigit4.setHorizontalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel2.add((Component)((Object)this.myPairingCodeDigit4), gbc);
        this.myPairingCodeDigit5.setColumns(2);
        this.myPairingCodeDigit5.setHorizontalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel2.add((Component)((Object)this.myPairingCodeDigit5), gbc);
        this.myPairingCodeDigit6.setColumns(2);
        this.myPairingCodeDigit6.setHorizontalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel2.add((Component)((Object)this.myPairingCodeDigit6), gbc);
        Spacer spacer4 = new Spacer();
        this.myRootContainer.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myRootContainer.add((Component)panel3, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.myPairingProgressLabel = new JBLabel();
        this.myPairingProgressLabel.setText("(some text)");
        panel3.add((Component)this.myPairingProgressLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(0, 0, 1, 1, 4, 2, 0, 3, null, null, null, 0, false));
        panel4.add((Component)this.myPairingProgressAsyncIcon, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 3, null, null, null, 0, false));
        this.myStatusIconLabel = new JBLabel();
        panel4.add((Component)this.myStatusIconLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        panel4.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(2, 0), null, 0, false));
        Spacer spacer6 = new Spacer();
        this.myRootContainer.add((Component)spacer6, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myRootContainer.add((Component)spacer7, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(1, 10), null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

