/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

@UiThread
public class PairingCodeDevicePanel {
    @NotNull
    private final PairingMdnsService myPairingMdnsService;
    @NotNull
    private JButton myPairButton;
    @NotNull
    private JBLabel myDeviceIpLabel;
    @NotNull
    private JPanel myRootContainer;
    @NotNull
    private JBLabel myAvailableToPairLabel;

    public PairingCodeDevicePanel(@NotNull PairingMdnsService pairingMdnsService, final @NotNull Runnable pairActionRunnable) {
        this.setupUI();
        this.myPairingMdnsService = pairingMdnsService;
        this.myRootContainer.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        this.myRootContainer.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairButton.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myAvailableToPairLabel.setForeground(UIColors.LIGHT_LABEL);
        RelativeFont.SMALL.install((Component)this.myAvailableToPairLabel);
        this.myPairButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pairActionRunnable.run();
            }
        });
        this.myDeviceIpLabel.setText(pairingMdnsService.getDisplayString());
    }

    @NotNull
    public Component getComponent() {
        return this.myRootContainer;
    }

    @NotNull
    public PairingMdnsService getMdnsService() {
        return this.myPairingMdnsService;
    }

    private void setupUI() {
        this.myRootContainer = new JPanel();
        this.myRootContainer.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), 0, 0));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Device at ");
        this.myRootContainer.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRootContainer.add((Component)spacer1, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myAvailableToPairLabel = new JBLabel();
        this.myAvailableToPairLabel.setText("Available to pair");
        this.myRootContainer.add((Component)this.myAvailableToPairLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 5, 0, null, null, null, 0, false));
        this.myPairButton = new JButton();
        this.myPairButton.setText("Pair");
        this.myRootContainer.add((Component)this.myPairButton, new GridConstraints(0, 2, 2, 1, 0, 0, 1, 0, null, null, null, 0, false));
        this.myDeviceIpLabel = new JBLabel();
        Font myDeviceIpLabelFont = this.getFont(null, 1, -1, this.myDeviceIpLabel.getFont());
        if (myDeviceIpLabelFont != null) {
            this.myDeviceIpLabel.setFont(myDeviceIpLabelFont);
        }
        this.myDeviceIpLabel.setText("xxx-xxx-xxx-xxx");
        this.myRootContainer.add((Component)this.myDeviceIpLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

