/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.tools.idea.adb.AdbServerBurstMode;
import com.android.tools.idea.adb.AdbServerLogLevel;
import com.android.tools.idea.adb.AdbServerMdnsBackend;
import com.android.tools.idea.adb.AdbServerUsbBackend;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service
public final class AdbOptionsService {
    static final int USER_MANAGED_ADB_PORT_MIN_VALUE = 5037;
    public static final int USER_MANAGED_ADB_PORT_DEFAULT = 5038;
    static final int USER_MANAGED_ADB_PORT_MAX_VALUE = 65535;
    private static final String USB_BACKEND_NAME = "adb.usb.backend.name";
    private static final String MDNS_BACKEND_NAME = "adb.mdns.backend.name3";
    private static final String BURST_MODE_NAME = "adb.burst.mode";
    private static final String LOG_ENABLED = "adb.log.enabled";
    private static final String LOG_LEVEL_NAME = "adb.log.level";
    private static final String USE_USER_MANAGED_ADB = "AdbOptionsService.use.user.managed.adb";
    private static final String USER_MANAGED_ADB_PORT = "AdbOptionsService.user.managed.adb.port";
    private static final boolean USE_USER_MANAGED_ADB_DEFAULT = false;
    private final Object LOCK = new Object();
    @NotNull
    private final List<AdbOptionsListener> myListeners = new SmartList();

    public static AdbOptionsService getInstance() {
        return (AdbOptionsService)ApplicationManager.getApplication().getService(AdbOptionsService.class);
    }

    @NotNull
    public AdbServerUsbBackend getAdbServerUsbBackend() {
        String value2 = PropertiesComponent.getInstance().getValue(USB_BACKEND_NAME, AdbServerUsbBackend.DEFAULT.name());
        try {
            return AdbServerUsbBackend.valueOf(value2);
        }
        catch (IllegalArgumentException e) {
            return AdbServerUsbBackend.DEFAULT;
        }
    }

    @NotNull
    public AdbServerMdnsBackend getAdbServerMdnsBackend() {
        AdbServerMdnsBackend defaultMdnsBackend = AdbServerMdnsBackend.OPENSCREEN;
        String value2 = PropertiesComponent.getInstance().getValue(MDNS_BACKEND_NAME, defaultMdnsBackend.name());
        try {
            return AdbServerMdnsBackend.valueOf(value2);
        }
        catch (IllegalArgumentException e) {
            return defaultMdnsBackend;
        }
    }

    @NotNull
    public AdbServerBurstMode getAdbServerBurstMode() {
        AdbServerBurstMode defaultBurstMode = AdbServerBurstMode.DEFAULT;
        String value2 = PropertiesComponent.getInstance().getValue(BURST_MODE_NAME, defaultBurstMode.name());
        try {
            return AdbServerBurstMode.valueOf(value2);
        }
        catch (IllegalArgumentException e) {
            return defaultBurstMode;
        }
    }

    @NotNull
    public AdbServerLogLevel getAdbServerLogLevel() {
        AdbServerLogLevel defaultLogLevel = AdbServerLogLevel.MINIMAL;
        String value2 = PropertiesComponent.getInstance().getValue(LOG_LEVEL_NAME, defaultLogLevel.name());
        try {
            return AdbServerLogLevel.valueOf(value2);
        }
        catch (IllegalArgumentException e) {
            return defaultLogLevel;
        }
    }

    public boolean shouldUseUserManagedAdb() {
        return PropertiesComponent.getInstance().getBoolean(USE_USER_MANAGED_ADB, false);
    }

    int getUserManagedAdbPort() {
        return PropertiesComponent.getInstance().getInt(USER_MANAGED_ADB_PORT, 5038);
    }

    boolean getAdbServerLogsEnabled() {
        return PropertiesComponent.getInstance().getBoolean(LOG_ENABLED, false);
    }

    @NotNull
    public AdbOptionsUpdater getOptionsUpdater() {
        return new AdbOptionsUpdater(this);
    }

    private void commitOptions(@NotNull AdbOptionsUpdater options) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(USB_BACKEND_NAME, options.getAdbServerUsbBackend().name());
        props.setValue(MDNS_BACKEND_NAME, options.getAdbServerMdnsBackend().name());
        props.setValue(USE_USER_MANAGED_ADB, options.useUserManagedAdb());
        props.setValue(USER_MANAGED_ADB_PORT, options.getUserManagedAdbPort(), 5038);
        props.setValue(BURST_MODE_NAME, options.getBurstMode().name());
        props.setValue(LOG_ENABLED, options.getAdbServerLogsEnabled());
        props.setValue(LOG_LEVEL_NAME, options.getAdbServerLogLevel().name());
        this.updateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        ImmutableList listeners;
        Iterator iterator2 = this.LOCK;
        synchronized (iterator2) {
            listeners = ImmutableList.copyOf(this.myListeners);
        }
        for (AdbOptionsListener listener2 : listeners) {
            listener2.optionsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull AdbOptionsListener listener2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull AdbOptionsListener listener2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    public static class AdbOptionsUpdater {
        @NotNull
        private final AdbOptionsService myService;
        private AdbServerUsbBackend myServerBackend;
        private AdbServerMdnsBackend myServerMdnsBackend;
        private boolean myUseUserManagedAdb;
        private int myUserManagedAdbPort;
        private AdbServerBurstMode myServerBurstMode;
        private boolean myLogEnabled;
        private AdbServerLogLevel myAdbServerLogLevel;

        private AdbOptionsUpdater(@NotNull AdbOptionsService service) {
            this.myService = service;
            this.myServerBackend = service.getAdbServerUsbBackend();
            this.myServerMdnsBackend = service.getAdbServerMdnsBackend();
            this.myUseUserManagedAdb = service.shouldUseUserManagedAdb();
            this.myUserManagedAdbPort = service.getUserManagedAdbPort();
            this.myServerBurstMode = service.getAdbServerBurstMode();
            this.myLogEnabled = service.getAdbServerLogsEnabled();
            this.myAdbServerLogLevel = service.getAdbServerLogLevel();
        }

        public AdbServerUsbBackend getAdbServerUsbBackend() {
            return this.myServerBackend;
        }

        public AdbOptionsUpdater setAdbServerUsbBackend(AdbServerUsbBackend serverBackend) {
            this.myServerBackend = serverBackend;
            return this;
        }

        public AdbServerMdnsBackend getAdbServerMdnsBackend() {
            return this.myServerMdnsBackend;
        }

        public AdbOptionsUpdater setAdbServerMdnsBackend(AdbServerMdnsBackend serverBackend) {
            this.myServerMdnsBackend = serverBackend;
            return this;
        }

        public AdbServerLogLevel getAdbServerLogLevel() {
            return this.myAdbServerLogLevel;
        }

        public AdbOptionsUpdater setAdbServerLogLevel(AdbServerLogLevel adbServerLogLevel) {
            this.myAdbServerLogLevel = adbServerLogLevel;
            return this;
        }

        public boolean useUserManagedAdb() {
            return this.myUseUserManagedAdb;
        }

        public AdbOptionsUpdater setUseUserManagedAdb(boolean useUserManagedAdb) {
            this.myUseUserManagedAdb = useUserManagedAdb;
            return this;
        }

        public int getUserManagedAdbPort() {
            return this.myUserManagedAdbPort;
        }

        public AdbOptionsUpdater setUserManagedAdbPort(int userManagedAdbPort) {
            this.myUserManagedAdbPort = userManagedAdbPort;
            return this;
        }

        public AdbServerBurstMode getBurstMode() {
            return this.myServerBurstMode;
        }

        public AdbOptionsUpdater setBurstMode(AdbServerBurstMode burstMode) {
            this.myServerBurstMode = burstMode;
            return this;
        }

        public boolean getAdbServerLogsEnabled() {
            return this.myLogEnabled;
        }

        public AdbOptionsUpdater setAdbServerLogsEnabled(boolean logEnabled) {
            this.myLogEnabled = logEnabled;
            return this;
        }

        public void commit() {
            this.myService.commitOptions(this);
        }
    }

    public static interface AdbOptionsListener {
        public void optionsChanged();
    }
}

